/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.spi;

import com.ibm.websphere.ras.annotation.Trivial;
import io.openliberty.checkpoint.spi.CheckpointHook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public enum CheckpointPhase {
    FEATURES,
    APPLICATIONS,
    DEPLOYMENT,
    INACTIVE(true);

    public static final String CHECKPOINT_PROPERTY = "io.openliberty.checkpoint";
    public static final String CHECKPOINT_ACTIVE_FILTER = "(!(io.openliberty.checkpoint=INACTIVE))";
    public static final String CHECKPOINT_RESTORED_PROPERTY = "io.openliberty.checkpoint.restored";
    public static final String CONDITION_PROCESS_RUNNING_ID = "io.openliberty.process.running";
    private static Map<String, CheckpointPhase> phases;
    private volatile boolean restored = false;
    private volatile boolean noMoreAddHooks = false;
    private final List<CheckpointHook> singleThreadedHooks = new ArrayList<CheckpointHook>();
    private final List<CheckpointHook> multiThreadedHooks = new ArrayList<CheckpointHook>();
    static CheckpointPhase THE_PHASE;
    private static final boolean DEBUG;

    private CheckpointPhase() {
        this(false);
    }

    private CheckpointPhase(boolean inactive) {
        if (inactive) {
            this.restored = true;
            this.noMoreAddHooks = true;
        }
    }

    public static CheckpointPhase getPhase(String p) {
        return phases.get(p.trim().toUpperCase());
    }

    static synchronized void setPhase(String p) {
        CheckpointPhase phase;
        if (THE_PHASE != INACTIVE) {
            return;
        }
        CheckpointPhase.debug(() -> "phase set to: " + p);
        CheckpointPhase checkpointPhase = phase = p == null ? null : phases.get(p.trim().toUpperCase());
        if (phase == null) {
            phase = INACTIVE;
        }
        THE_PHASE = phase;
    }

    public final boolean restored() {
        return this == INACTIVE || this.restored;
    }

    public final boolean addSingleThreadedHook(CheckpointHook hook) {
        return this.addHook(hook, false);
    }

    public final boolean addMultiThreadedHook(CheckpointHook hook) {
        return this.addHook(hook, true);
    }

    private synchronized boolean addHook(CheckpointHook hook, boolean multiThreaded) {
        if (this != THE_PHASE) {
            throw new IllegalStateException("Cannot add hooks to a checkpoint phase that is not in progress.");
        }
        if (this == INACTIVE) {
            return false;
        }
        if (this.noMoreAddHooks) {
            return false;
        }
        if (this.restored) {
            return false;
        }
        CheckpointPhase.debug(() -> "Hook added: " + hook + " " + multiThreaded);
        if (multiThreaded) {
            this.multiThreadedHooks.add(hook);
        } else {
            this.singleThreadedHooks.add(hook);
        }
        return true;
    }

    private synchronized List<CheckpointHook> getAndClearHooks(boolean multiThreaded) {
        CheckpointPhase.debug(() -> "Calling getHooks: " + multiThreaded);
        this.noMoreAddHooks = true;
        List<CheckpointHook> current = multiThreaded ? this.multiThreadedHooks : this.singleThreadedHooks;
        ArrayList<CheckpointHook> hooks = new ArrayList<CheckpointHook>(current);
        current.clear();
        return hooks;
    }

    public static synchronized CheckpointPhase getPhase() {
        return THE_PHASE;
    }

    private static boolean debugEnabled() {
        return System.getProperty("io.openliberty.checkpoint.debug") != null;
    }

    @Trivial
    private static void debug(Supplier<String> message) {
        if (DEBUG) {
            System.out.println("DEBUG CheckpointPhase: current phase - " + String.valueOf((Object)THE_PHASE) + " - " + message.get());
        }
    }

    final CheckpointHook createCheckpointHook(boolean multiThreaded) {
        return new CheckpointPhaseHookImpl(multiThreaded);
    }

    static {
        phases = new HashMap<String, CheckpointPhase>();
        for (CheckpointPhase p : CheckpointPhase.values()) {
            phases.put(p.toString(), p);
        }
        THE_PHASE = INACTIVE;
        DEBUG = CheckpointPhase.debugEnabled();
    }

    static final class CheckpointPhaseHookImpl
    implements CheckpointHook {
        private volatile List<CheckpointHook> hooks = Collections.emptyList();
        private final boolean multiThreaded;

        CheckpointPhaseHookImpl(boolean multiThreaded) {
            this.multiThreaded = multiThreaded;
        }

        @Override
        public void prepare() {
            CheckpointPhase phase = CheckpointPhase.getPhase();
            CheckpointPhase.debug(() -> "prepare phase: " + (Object)((Object)phase));
            this.hooks = phase.getAndClearHooks(this.multiThreaded);
            for (CheckpointHook hook : this.hooks) {
                CheckpointPhase.debug(() -> "prepare operation on static hook: " + hook);
                hook.prepare();
            }
            Collections.reverse(this.hooks);
        }

        @Override
        public void restore() {
            for (CheckpointHook hook : this.hooks) {
                CheckpointPhase.debug(() -> "prepare operation on static hook: " + hook);
                hook.restore();
            }
            this.hooks.clear();
        }
    }
}

