/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.testing.export;

import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class TestHandler
extends SpanExporter.Handler {
    private final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private final List<SpanData> spanDataList = new LinkedList<SpanData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Collection<SpanData> spanDataList) {
        Object object = this.monitor;
        synchronized (object) {
            this.spanDataList.addAll(spanDataList);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<SpanData> waitForExport(int numberOfSpans) {
        ArrayList<SpanData> ret;
        Object object = this.monitor;
        synchronized (object) {
            while (this.spanDataList.size() < numberOfSpans) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            ret = new ArrayList<SpanData>(this.spanDataList);
            this.spanDataList.clear();
        }
        return ret;
    }
}

