/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.internal;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import io.opencensus.implcore.internal.DaemonThreadFactory;
import io.opencensus.implcore.internal.EventQueue;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DisruptorEventQueue
implements EventQueue {
    private static final int DISRUPTOR_BUFFER_SIZE = 8192;
    private static final DisruptorEventQueue eventQueue = new DisruptorEventQueue();
    private final Disruptor<DisruptorEvent> disruptor = new Disruptor((EventFactory)DisruptorEventFactory.INSTANCE, 8192, (ThreadFactory)new DaemonThreadFactory("OpenCensus.Disruptor"), ProducerType.MULTI, (WaitStrategy)new SleepingWaitStrategy());
    private final RingBuffer<DisruptorEvent> ringBuffer;

    private DisruptorEventQueue() {
        this.disruptor.handleEventsWith(new EventHandler[]{DisruptorEventHandler.INSTANCE});
        this.disruptor.start();
        this.ringBuffer = this.disruptor.getRingBuffer();
    }

    public static DisruptorEventQueue getInstance() {
        return eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(EventQueue.Entry entry) {
        long sequence = this.ringBuffer.next();
        try {
            DisruptorEvent event = (DisruptorEvent)this.ringBuffer.get(sequence);
            event.setEntry(entry);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    private static enum DisruptorEventHandler implements EventHandler<DisruptorEvent>
    {
        INSTANCE;


        public void onEvent(DisruptorEvent event, long sequence, boolean endOfBatch) {
            EventQueue.Entry entry = event.getEntry();
            if (entry != null) {
                entry.process();
            }
            event.setEntry(null);
        }
    }

    private static enum DisruptorEventFactory implements EventFactory<DisruptorEvent>
    {
        INSTANCE;


        public DisruptorEvent newInstance() {
            return new DisruptorEvent();
        }
    }

    private static final class DisruptorEvent {
        @Nullable
        private volatile EventQueue.Entry entry = null;

        private DisruptorEvent() {
        }

        void setEntry(@Nullable EventQueue.Entry entry) {
            this.entry = entry;
        }

        @Nullable
        EventQueue.Entry getEntry() {
            return this.entry;
        }
    }
}

