/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import com.google.common.base.Preconditions;
import io.opencensus.tags.TaggingState;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CurrentTaggingState {
    @GuardedBy(value="this")
    private TaggingState currentState = TaggingState.ENABLED;
    @GuardedBy(value="this")
    private boolean isRead;

    public synchronized TaggingState get() {
        this.isRead = true;
        return this.getInternal();
    }

    public synchronized TaggingState getInternal() {
        return this.currentState;
    }

    synchronized void set(TaggingState state) {
        Preconditions.checkState((!this.isRead ? 1 : 0) != 0, (Object)"State was already read, cannot set state.");
        this.currentState = (TaggingState)Preconditions.checkNotNull((Object)state, (Object)"state");
    }
}

