/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.export;

import io.opencensus.common.Duration;
import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.trace.export.InProcessRunningSpanStoreImpl;
import io.opencensus.implcore.trace.export.InProcessSampledSpanStoreImpl;
import io.opencensus.implcore.trace.export.RunningSpanStoreImpl;
import io.opencensus.implcore.trace.export.SampledSpanStoreImpl;
import io.opencensus.implcore.trace.export.SpanExporterImpl;
import io.opencensus.trace.export.ExportComponent;

public final class ExportComponentImpl
extends ExportComponent {
    private static final int EXPORTER_BUFFER_SIZE = 32;
    private static final Duration EXPORTER_SCHEDULE_DELAY = Duration.create((long)5L, (int)0);
    private final SpanExporterImpl spanExporter = SpanExporterImpl.create(32, EXPORTER_SCHEDULE_DELAY);
    private final RunningSpanStoreImpl runningSpanStore;
    private final SampledSpanStoreImpl sampledSpanStore;

    public SpanExporterImpl getSpanExporter() {
        return this.spanExporter;
    }

    public RunningSpanStoreImpl getRunningSpanStore() {
        return this.runningSpanStore;
    }

    public SampledSpanStoreImpl getSampledSpanStore() {
        return this.sampledSpanStore;
    }

    public static ExportComponentImpl createWithInProcessStores(EventQueue eventQueue) {
        return new ExportComponentImpl(true, eventQueue);
    }

    public static ExportComponentImpl createWithoutInProcessStores(EventQueue eventQueue) {
        return new ExportComponentImpl(false, eventQueue);
    }

    private ExportComponentImpl(boolean supportInProcessStores, EventQueue eventQueue) {
        this.runningSpanStore = supportInProcessStores ? new InProcessRunningSpanStoreImpl() : RunningSpanStoreImpl.getNoopRunningSpanStoreImpl();
        this.sampledSpanStore = supportInProcessStores ? new InProcessSampledSpanStoreImpl(eventQueue) : SampledSpanStoreImpl.getNoopSampledSpanStoreImpl();
    }
}

