/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.opencensus.common.Clock;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.stats.MeasureMapInternal;
import io.opencensus.implcore.stats.MutableViewData;
import io.opencensus.stats.Measure;
import io.opencensus.stats.Measurement;
import io.opencensus.stats.StatsCollectionState;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.tags.TagContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class MeasureToViewMap {
    @GuardedBy(value="this")
    private final Multimap<String, MutableViewData> mutableMap = HashMultimap.create();
    @GuardedBy(value="this")
    private final Map<View.Name, View> registeredViews = new HashMap<View.Name, View>();
    @GuardedBy(value="this")
    private final Map<String, Measure> registeredMeasures = Maps.newHashMap();
    @Nullable
    private volatile Set<View> exportedViews;

    MeasureToViewMap() {
    }

    @Nullable
    synchronized ViewData getView(View.Name viewName, Clock clock, StatsCollectionState state) {
        MutableViewData view = this.getMutableViewData(viewName);
        return view == null ? null : view.toViewData(clock.now(), state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<View> getExportedViews() {
        Set<View> views = this.exportedViews;
        if (views == null) {
            MeasureToViewMap measureToViewMap = this;
            synchronized (measureToViewMap) {
                this.exportedViews = views = MeasureToViewMap.filterExportedViews(this.registeredViews.values());
            }
        }
        return views;
    }

    private static Set<View> filterExportedViews(Collection<View> allViews) {
        HashSet views = Sets.newHashSet();
        for (View view : allViews) {
            if (!(view.getWindow() instanceof View.AggregationWindow.Cumulative)) continue;
            views.add(view);
        }
        return Collections.unmodifiableSet(views);
    }

    synchronized void registerView(View view, Clock clock) {
        this.exportedViews = null;
        View existing = this.registeredViews.get(view.getName());
        if (existing != null) {
            if (existing.equals(view)) {
                return;
            }
            throw new IllegalArgumentException("A different view with the same name is already registered: " + existing);
        }
        Measure measure = view.getMeasure();
        Measure registeredMeasure = this.registeredMeasures.get(measure.getName());
        if (registeredMeasure != null && !registeredMeasure.equals(measure)) {
            throw new IllegalArgumentException("A different measure with the same name is already registered: " + registeredMeasure);
        }
        this.registeredViews.put(view.getName(), view);
        if (registeredMeasure == null) {
            this.registeredMeasures.put(measure.getName(), measure);
        }
        this.mutableMap.put((Object)view.getMeasure().getName(), (Object)MutableViewData.create(view, clock.now()));
    }

    @Nullable
    private synchronized MutableViewData getMutableViewData(View.Name viewName) {
        View view = this.registeredViews.get(viewName);
        if (view == null) {
            return null;
        }
        Collection views = this.mutableMap.get((Object)view.getMeasure().getName());
        for (MutableViewData viewData : views) {
            if (!viewData.getView().getName().equals(viewName)) continue;
            return viewData;
        }
        throw new AssertionError((Object)("Internal error: Not recording stats for view: \"" + viewName + "\" registeredViews=" + this.registeredViews + ", mutableMap=" + this.mutableMap));
    }

    synchronized void record(TagContext tags, MeasureMapInternal stats, Timestamp timestamp) {
        Iterator<Measurement> iterator = stats.iterator();
        while (iterator.hasNext()) {
            Measurement measurement = iterator.next();
            Measure measure = measurement.getMeasure();
            if (!measure.equals(this.registeredMeasures.get(measure.getName()))) {
                return;
            }
            Collection views = this.mutableMap.get((Object)measure.getName());
            for (MutableViewData view : views) {
                measurement.match((Function)new RecordDoubleValueFunc(tags, view, timestamp), (Function)new RecordLongValueFunc(tags, view, timestamp), Functions.throwAssertionError());
            }
        }
    }

    synchronized void clearStats() {
        for (Map.Entry entry : this.mutableMap.asMap().entrySet()) {
            for (MutableViewData mutableViewData : (Collection)entry.getValue()) {
                mutableViewData.clearStats();
            }
        }
    }

    synchronized void resumeStatsCollection(Timestamp now) {
        for (Map.Entry entry : this.mutableMap.asMap().entrySet()) {
            for (MutableViewData mutableViewData : (Collection)entry.getValue()) {
                mutableViewData.resumeStatsCollection(now);
            }
        }
    }

    private static final class RecordLongValueFunc
    implements Function<Measurement.MeasurementLong, Void> {
        private final TagContext tags;
        private final MutableViewData view;
        private final Timestamp timestamp;

        public Void apply(Measurement.MeasurementLong arg) {
            this.view.record(this.tags, arg.getValue(), this.timestamp);
            return null;
        }

        private RecordLongValueFunc(TagContext tags, MutableViewData view, Timestamp timestamp) {
            this.tags = tags;
            this.view = view;
            this.timestamp = timestamp;
        }
    }

    private static final class RecordDoubleValueFunc
    implements Function<Measurement.MeasurementDouble, Void> {
        private final TagContext tags;
        private final MutableViewData view;
        private final Timestamp timestamp;

        public Void apply(Measurement.MeasurementDouble arg) {
            this.view.record(this.tags, arg.getValue(), this.timestamp);
            return null;
        }

        private RecordDoubleValueFunc(TagContext tags, MutableViewData view, Timestamp timestamp) {
            this.tags = tags;
            this.view = view;
            this.timestamp = timestamp;
        }
    }
}

