/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.opencensus.common.Duration;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.stats.MutableAggregation;
import io.opencensus.implcore.stats.MutableViewData;
import io.opencensus.stats.Aggregation;
import io.opencensus.tags.TagValue;
import java.util.List;
import java.util.Map;

final class IntervalBucket {
    private static final Duration ZERO = Duration.create((long)0L, (int)0);
    private final Timestamp start;
    private final Duration duration;
    private final Aggregation aggregation;
    private final Map<List<TagValue>, MutableAggregation> tagValueAggregationMap = Maps.newHashMap();

    IntervalBucket(Timestamp start, Duration duration, Aggregation aggregation) {
        Preconditions.checkNotNull((Object)start, (Object)"Start");
        Preconditions.checkNotNull((Object)duration, (Object)"Duration");
        Preconditions.checkArgument((duration.compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Duration must be positive");
        Preconditions.checkNotNull((Object)aggregation, (Object)"Aggregation");
        this.start = start;
        this.duration = duration;
        this.aggregation = aggregation;
    }

    Map<List<TagValue>, MutableAggregation> getTagValueAggregationMap() {
        return this.tagValueAggregationMap;
    }

    Timestamp getStart() {
        return this.start;
    }

    void record(List<TagValue> tagValues, double value) {
        if (!this.tagValueAggregationMap.containsKey(tagValues)) {
            this.tagValueAggregationMap.put(tagValues, MutableViewData.createMutableAggregation(this.aggregation));
        }
        this.tagValueAggregationMap.get(tagValues).add(value);
    }

    double getFraction(Timestamp now) {
        Duration elapsedTime = now.subtractTimestamp(this.start);
        Preconditions.checkArgument((elapsedTime.compareTo(ZERO) >= 0 && elapsedTime.compareTo(this.duration) < 0 ? 1 : 0) != 0, (Object)"This bucket must be current.");
        return (double)MutableViewData.toMillis(elapsedTime) / (double)MutableViewData.toMillis(this.duration);
    }

    void clearStats() {
        this.tagValueAggregationMap.clear();
    }
}

