/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.zipkin;

import com.google.common.io.BaseEncoding;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.NetworkEvent;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;

final class ZipkinExporterHandler
extends SpanExporter.Handler {
    static final Logger logger = Logger.getLogger(ZipkinExporterHandler.class.getName());
    private static final String STATUS_CODE = "census.status_code";
    private static final String STATUS_DESCRIPTION = "census.status_description";
    private static final Function<Object, String> RETURN_STRING = new Function<Object, String>(){

        public String apply(Object input) {
            return input.toString();
        }
    };
    private final SpanBytesEncoder encoder;
    private final Sender sender;
    private final Endpoint localEndpoint;

    ZipkinExporterHandler(SpanBytesEncoder encoder, Sender sender, String serviceName) {
        this.encoder = encoder;
        this.sender = sender;
        this.localEndpoint = ZipkinExporterHandler.produceLocalEndpoint(serviceName);
    }

    static Endpoint produceLocalEndpoint(String serviceName) {
        Endpoint.Builder builder;
        block5: {
            builder = Endpoint.newBuilder().serviceName(serviceName);
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                if (nics == null) {
                    return builder.build();
                }
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        builder.ip(address);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    static Span generateSpan(SpanData spanData, Endpoint localEndpoint) {
        SpanContext context = spanData.getContext();
        long startTimestamp = ZipkinExporterHandler.toEpochMicros(spanData.getStartTimestamp());
        long endTimestamp = ZipkinExporterHandler.toEpochMicros(spanData.getEndTimestamp());
        Span.Builder spanBuilder = Span.newBuilder().traceId(ZipkinExporterHandler.encodeTraceId(context.getTraceId())).id(ZipkinExporterHandler.encodeSpanId(context.getSpanId())).kind(ZipkinExporterHandler.toSpanKind(spanData)).name(spanData.getName()).timestamp(Long.valueOf(ZipkinExporterHandler.toEpochMicros(spanData.getStartTimestamp()))).duration(Long.valueOf(endTimestamp - startTimestamp)).localEndpoint(localEndpoint);
        if (spanData.getParentSpanId() != null && spanData.getParentSpanId().isValid()) {
            spanBuilder.parentId(ZipkinExporterHandler.encodeSpanId(spanData.getParentSpanId()));
        }
        for (Map.Entry label : spanData.getAttributes().getAttributeMap().entrySet()) {
            spanBuilder.putTag((String)label.getKey(), ZipkinExporterHandler.attributeValueToString((AttributeValue)label.getValue()));
        }
        spanBuilder.putTag(STATUS_CODE, spanData.getStatus().getCanonicalCode().toString());
        if (spanData.getStatus().getDescription() != null) {
            spanBuilder.putTag(STATUS_DESCRIPTION, spanData.getStatus().getDescription());
        }
        for (SpanData.TimedEvent annotation : spanData.getAnnotations().getEvents()) {
            spanBuilder.addAnnotation(ZipkinExporterHandler.toEpochMicros(annotation.getTimestamp()), ((Annotation)annotation.getEvent()).getDescription());
        }
        for (SpanData.TimedEvent networkEvent : spanData.getNetworkEvents().getEvents()) {
            spanBuilder.addAnnotation(ZipkinExporterHandler.toEpochMicros(networkEvent.getTimestamp()), ((NetworkEvent)networkEvent.getEvent()).getType().name());
        }
        return spanBuilder.build();
    }

    private static String encodeTraceId(TraceId traceId) {
        return BaseEncoding.base16().lowerCase().encode(traceId.getBytes());
    }

    private static String encodeSpanId(SpanId spanId) {
        return BaseEncoding.base16().lowerCase().encode(spanId.getBytes());
    }

    private static Span.Kind toSpanKind(SpanData spanData) {
        if (Boolean.TRUE.equals(spanData.getHasRemoteParent())) {
            return Span.Kind.SERVER;
        }
        if (spanData.getName().startsWith("Sent.")) {
            return Span.Kind.CLIENT;
        }
        return null;
    }

    private static long toEpochMicros(Timestamp timestamp) {
        return TimeUnit.SECONDS.toMicros(timestamp.getSeconds()) + TimeUnit.NANOSECONDS.toMicros(timestamp.getNanos());
    }

    private static String attributeValueToString(AttributeValue attributeValue) {
        return (String)attributeValue.match(RETURN_STRING, RETURN_STRING, RETURN_STRING, Functions.returnNull());
    }

    public void export(Collection<SpanData> spanDataList) {
        ArrayList<byte[]> encodedSpans = new ArrayList<byte[]>(spanDataList.size());
        for (SpanData spanData : spanDataList) {
            encodedSpans.add(this.encoder.encode((Object)ZipkinExporterHandler.generateSpan(spanData, this.localEndpoint)));
        }
        try {
            this.sender.sendSpans(encodedSpans).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

