/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.stackdriver;

import com.google.auth.Credentials;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceConfiguration;
import io.opencensus.trace.AttributeValue;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_StackdriverTraceConfiguration
extends StackdriverTraceConfiguration {
    private final Credentials credentials;
    private final String projectId;
    private final TraceServiceStub traceServiceStub;
    private final Map<String, AttributeValue> fixedAttributes;
    private final Duration deadline;

    private AutoValue_StackdriverTraceConfiguration(@Nullable Credentials credentials, String projectId, @Nullable TraceServiceStub traceServiceStub, Map<String, AttributeValue> fixedAttributes, Duration deadline) {
        this.credentials = credentials;
        this.projectId = projectId;
        this.traceServiceStub = traceServiceStub;
        this.fixedAttributes = fixedAttributes;
        this.deadline = deadline;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public TraceServiceStub getTraceServiceStub() {
        return this.traceServiceStub;
    }

    @Override
    public Map<String, AttributeValue> getFixedAttributes() {
        return this.fixedAttributes;
    }

    @Override
    public Duration getDeadline() {
        return this.deadline;
    }

    public String toString() {
        return "StackdriverTraceConfiguration{credentials=" + this.credentials + ", projectId=" + this.projectId + ", traceServiceStub=" + this.traceServiceStub + ", fixedAttributes=" + this.fixedAttributes + ", deadline=" + this.deadline + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StackdriverTraceConfiguration) {
            StackdriverTraceConfiguration that = (StackdriverTraceConfiguration)o;
            return (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials())) && this.projectId.equals(that.getProjectId()) && (this.traceServiceStub == null ? that.getTraceServiceStub() == null : this.traceServiceStub.equals(that.getTraceServiceStub())) && this.fixedAttributes.equals(that.getFixedAttributes()) && this.deadline.equals(that.getDeadline());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.credentials == null ? 0 : this.credentials.hashCode();
        h *= 1000003;
        h ^= this.projectId.hashCode();
        h *= 1000003;
        h ^= this.traceServiceStub == null ? 0 : this.traceServiceStub.hashCode();
        h *= 1000003;
        h ^= this.fixedAttributes.hashCode();
        h *= 1000003;
        return h ^= this.deadline.hashCode();
    }

    static final class Builder
    extends StackdriverTraceConfiguration.Builder {
        private Credentials credentials;
        private String projectId;
        private TraceServiceStub traceServiceStub;
        private Map<String, AttributeValue> fixedAttributes;
        private Duration deadline;

        Builder() {
        }

        @Override
        public StackdriverTraceConfiguration.Builder setCredentials(@Nullable Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public StackdriverTraceConfiguration.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        String getProjectId() {
            if (this.projectId == null) {
                throw new IllegalStateException("Property \"projectId\" has not been set");
            }
            return this.projectId;
        }

        @Override
        public StackdriverTraceConfiguration.Builder setTraceServiceStub(@Nullable TraceServiceStub traceServiceStub) {
            this.traceServiceStub = traceServiceStub;
            return this;
        }

        @Override
        public StackdriverTraceConfiguration.Builder setFixedAttributes(Map<String, AttributeValue> fixedAttributes) {
            if (fixedAttributes == null) {
                throw new NullPointerException("Null fixedAttributes");
            }
            this.fixedAttributes = fixedAttributes;
            return this;
        }

        @Override
        Map<String, AttributeValue> getFixedAttributes() {
            if (this.fixedAttributes == null) {
                throw new IllegalStateException("Property \"fixedAttributes\" has not been set");
            }
            return this.fixedAttributes;
        }

        @Override
        public StackdriverTraceConfiguration.Builder setDeadline(Duration deadline) {
            if (deadline == null) {
                throw new NullPointerException("Null deadline");
            }
            this.deadline = deadline;
            return this;
        }

        @Override
        Duration getDeadline() {
            if (this.deadline == null) {
                throw new IllegalStateException("Property \"deadline\" has not been set");
            }
            return this.deadline;
        }

        @Override
        StackdriverTraceConfiguration autoBuild() {
            String missing = "";
            if (this.projectId == null) {
                missing = missing + " projectId";
            }
            if (this.fixedAttributes == null) {
                missing = missing + " fixedAttributes";
            }
            if (this.deadline == null) {
                missing = missing + " deadline";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_StackdriverTraceConfiguration(this.credentials, this.projectId, this.traceServiceStub, this.fixedAttributes, this.deadline);
        }
    }
}

