/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.resource.util.ResourceUtils;
import io.opencensus.exporter.trace.ocagent.TraceProtoUtils;
import io.opencensus.proto.agent.common.v1.LibraryInfo;
import io.opencensus.proto.agent.common.v1.Node;
import io.opencensus.proto.agent.common.v1.ProcessIdentifier;
import io.opencensus.proto.agent.common.v1.ServiceInfo;
import io.opencensus.proto.resource.v1.Resource;
import io.opencensus.resource.Resource;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Map;
import javax.annotation.Nullable;

final class OcAgentNodeUtils {
    @VisibleForTesting
    static final String OC_AGENT_EXPORTER_VERSION = "0.31.0";
    @Nullable
    private static final Resource AUTO_DETECTED_RESOURCE = ResourceUtils.detectResource();

    static Node getNodeInfo(String serviceName) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        Timestamp censusTimestamp = Timestamp.fromMillis((long)System.currentTimeMillis());
        return Node.newBuilder().setIdentifier(OcAgentNodeUtils.getProcessIdentifier(jvmName, censusTimestamp)).setLibraryInfo(OcAgentNodeUtils.getLibraryInfo("0.29.0")).setServiceInfo(OcAgentNodeUtils.getServiceInfo(serviceName)).build();
    }

    @VisibleForTesting
    static ProcessIdentifier getProcessIdentifier(String jvmName, Timestamp censusTimestamp) {
        int pid;
        String hostname;
        int delimiterIndex = jvmName.indexOf(64);
        if (delimiterIndex < 1) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "localhost";
            }
            pid = new SecureRandom().nextInt();
        } else {
            hostname = jvmName.substring(delimiterIndex + 1, jvmName.length());
            try {
                pid = Integer.parseInt(jvmName.substring(0, delimiterIndex));
            }
            catch (NumberFormatException e) {
                pid = new SecureRandom().nextInt();
            }
        }
        return ProcessIdentifier.newBuilder().setHostName(hostname).setPid(pid).setStartTimestamp(TraceProtoUtils.toTimestampProto(censusTimestamp)).build();
    }

    @VisibleForTesting
    static LibraryInfo getLibraryInfo(String currentOcJavaVersion) {
        return LibraryInfo.newBuilder().setLanguage(LibraryInfo.Language.JAVA).setCoreLibraryVersion(currentOcJavaVersion).setExporterVersion(OC_AGENT_EXPORTER_VERSION).build();
    }

    @VisibleForTesting
    static ServiceInfo getServiceInfo(String serviceName) {
        return ServiceInfo.newBuilder().setName(serviceName).build();
    }

    @Nullable
    static io.opencensus.proto.resource.v1.Resource getAutoDetectedResourceProto() {
        return OcAgentNodeUtils.toResourceProto(AUTO_DETECTED_RESOURCE);
    }

    @Nullable
    @VisibleForTesting
    static io.opencensus.proto.resource.v1.Resource toResourceProto(@Nullable Resource resource) {
        if (resource == null || resource.getType() == null) {
            return null;
        }
        Resource.Builder resourceProtoBuilder = io.opencensus.proto.resource.v1.Resource.newBuilder();
        resourceProtoBuilder.setType(resource.getType());
        for (Map.Entry keyValuePairs : resource.getLabels().entrySet()) {
            resourceProtoBuilder.putLabels((String)keyValuePairs.getKey(), (String)keyValuePairs.getValue());
        }
        return resourceProtoBuilder.build();
    }

    private OcAgentNodeUtils() {
    }
}

