/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.handler.ssl.SslContext;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.ocagent.AutoValue_OcAgentTraceExporterConfiguration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class OcAgentTraceExporterConfiguration {
    @VisibleForTesting
    static final String DEFAULT_END_POINT = "localhost:55678";
    @VisibleForTesting
    static final String DEFAULT_SERVICE_NAME = "OpenCensus";
    @VisibleForTesting
    static final Duration DEFAULT_RETRY_INTERVAL = Duration.create((long)300L, (int)0);
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create((long)10L, (int)0);
    @VisibleForTesting
    static final Duration ZERO = Duration.create((long)0L, (int)0);

    OcAgentTraceExporterConfiguration() {
    }

    public abstract String getEndPoint();

    public abstract Boolean getUseInsecure();

    @Nullable
    public abstract SslContext getSslContext();

    public abstract String getServiceName();

    public abstract Duration getRetryInterval();

    public abstract boolean getEnableConfig();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_OcAgentTraceExporterConfiguration.Builder().setEndPoint(DEFAULT_END_POINT).setServiceName(DEFAULT_SERVICE_NAME).setEnableConfig(true).setUseInsecure(true).setRetryInterval(DEFAULT_RETRY_INTERVAL).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setEndPoint(String var1);

        public abstract Builder setUseInsecure(Boolean var1);

        public abstract Builder setSslContext(SslContext var1);

        public abstract Builder setServiceName(String var1);

        public abstract Builder setRetryInterval(Duration var1);

        public abstract Builder setEnableConfig(boolean var1);

        public abstract Builder setDeadline(Duration var1);

        abstract Duration getRetryInterval();

        abstract OcAgentTraceExporterConfiguration autoBuild();

        abstract Duration getDeadline();

        public OcAgentTraceExporterConfiguration build() {
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            Preconditions.checkArgument((this.getRetryInterval().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Retry interval must be positive.");
            return this.autoBuild();
        }
    }
}

