/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.ocagent;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.opencensus.proto.agent.trace.v1.ExportTraceServiceRequest;
import io.opencensus.proto.agent.trace.v1.ExportTraceServiceResponse;
import io.opencensus.proto.agent.trace.v1.TraceServiceGrpc;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OcAgentTraceServiceExportRpcHandler {
    private static final Logger logger = Logger.getLogger(OcAgentTraceServiceExportRpcHandler.class.getName());
    @Nullable
    @GuardedBy(value="this")
    private StreamObserver<ExportTraceServiceRequest> exportRequestObserver;
    @Nullable
    @GuardedBy(value="this")
    private Status terminateStatus;

    private OcAgentTraceServiceExportRpcHandler() {
    }

    private synchronized void setExportRequestObserver(StreamObserver<ExportTraceServiceRequest> exportRequestObserver) {
        this.exportRequestObserver = exportRequestObserver;
    }

    static OcAgentTraceServiceExportRpcHandler create(TraceServiceGrpc.TraceServiceStub stub) {
        OcAgentTraceServiceExportRpcHandler exportRpcHandler = new OcAgentTraceServiceExportRpcHandler();
        ExportResponseObserver exportResponseObserver = new ExportResponseObserver(exportRpcHandler);
        try {
            StreamObserver exportRequestObserver = stub.export((StreamObserver)exportResponseObserver);
            exportRpcHandler.setExportRequestObserver((StreamObserver<ExportTraceServiceRequest>)exportRequestObserver);
        }
        catch (StatusRuntimeException e) {
            exportRpcHandler.onComplete(e);
        }
        return exportRpcHandler;
    }

    synchronized void onExport(ExportTraceServiceRequest request) {
        if (this.isCompleted() || this.exportRequestObserver == null) {
            return;
        }
        try {
            this.exportRequestObserver.onNext((Object)request);
        }
        catch (Exception e) {
            this.onComplete(e);
        }
    }

    synchronized void onComplete(@Nullable Throwable error) {
        if (this.isCompleted()) {
            return;
        }
        Status status = error == null ? Status.OK : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus() : Status.UNKNOWN);
        this.terminateStatus = status;
    }

    synchronized boolean isCompleted() {
        return this.terminateStatus != null;
    }

    @Nullable
    @VisibleForTesting
    synchronized Status getTerminateStatus() {
        return this.terminateStatus;
    }

    @VisibleForTesting
    static class ExportResponseObserver
    implements StreamObserver<ExportTraceServiceResponse> {
        private final OcAgentTraceServiceExportRpcHandler exportRpcHandler;

        ExportResponseObserver(OcAgentTraceServiceExportRpcHandler exportRpcHandler) {
            this.exportRpcHandler = exportRpcHandler;
        }

        public void onNext(ExportTraceServiceResponse value) {
        }

        public void onError(Throwable t) {
            logger.log(Level.WARNING, "Export stream is disconnected.", t);
            this.exportRpcHandler.onComplete(t);
        }

        public void onCompleted() {
            this.exportRpcHandler.onComplete(null);
        }
    }
}

