/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.jaeger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thrift.internal.senders.ThriftSender;
import io.jaegertracing.thriftjava.Process;
import io.opencensus.exporter.trace.jaeger.JaegerExporterConfiguration;
import io.opencensus.exporter.trace.jaeger.JaegerExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class JaegerTraceExporter {
    private static final String REGISTER_NAME = JaegerTraceExporter.class.getName();
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private JaegerTraceExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(JaegerExporterConfiguration configuration) {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Jaeger exporter is already registered.");
            ThriftSender sender = configuration.getThriftSender();
            if (sender == null) {
                sender = new HttpSender.Builder(configuration.getThriftEndpoint()).build();
            }
            Process process = new Process(configuration.getServiceName());
            JaegerExporterHandler newHandler = new JaegerExporterHandler(sender, process, configuration.getDeadline());
            handler = newHandler;
            JaegerTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), (SpanExporter.Handler)newHandler);
        }
    }

    @Deprecated
    public static void createAndRegister(String thriftEndpoint, String serviceName) {
        JaegerTraceExporter.createAndRegister(JaegerExporterConfiguration.builder().setThriftEndpoint(thriftEndpoint).setServiceName(serviceName).build());
    }

    @Deprecated
    public static void createWithSender(ThriftSender sender, String serviceName) {
        JaegerTraceExporter.createAndRegister(JaegerExporterConfiguration.builder().setThriftSender(sender).setServiceName(serviceName).build());
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Jaeger exporter is not registered.");
            JaegerTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

