/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.jaeger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.jaegertracing.internal.exceptions.SenderException;
import io.jaegertracing.thrift.internal.senders.ThriftSender;
import io.jaegertracing.thriftjava.Log;
import io.jaegertracing.thriftjava.Process;
import io.jaegertracing.thriftjava.Span;
import io.jaegertracing.thriftjava.SpanRef;
import io.jaegertracing.thriftjava.SpanRefType;
import io.jaegertracing.thriftjava.Tag;
import io.jaegertracing.thriftjava.TagType;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Timestamp;
import io.opencensus.exporter.trace.util.TimeLimitedHandler;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class JaegerExporterHandler
extends TimeLimitedHandler {
    private static final String EXPORT_SPAN_NAME = "ExportJaegerTraces";
    @VisibleForTesting
    static final String SPAN_KIND = "span.kind";
    private static final Tag SERVER_KIND_TAG = new Tag("span.kind", TagType.STRING).setVStr("server");
    private static final Tag CLIENT_KIND_TAG = new Tag("span.kind", TagType.STRING).setVStr("client");
    private static final String DESCRIPTION = "message";
    private static final Tag RECEIVED_MESSAGE_EVENT_TAG = new Tag("message", TagType.STRING).setVStr("received message");
    private static final Tag SENT_MESSAGE_EVENT_TAG = new Tag("message", TagType.STRING).setVStr("sent message");
    private static final String MESSAGE_EVENT_ID = "id";
    private static final String MESSAGE_EVENT_COMPRESSED_SIZE = "compressed_size";
    private static final String MESSAGE_EVENT_UNCOMPRESSED_SIZE = "uncompressed_size";
    @VisibleForTesting
    static final String STATUS_CODE = "status.code";
    @VisibleForTesting
    static final String STATUS_MESSAGE = "status.message";
    private static final Function<? super String, Tag> stringAttributeConverter = new Function<String, Tag>(){

        public Tag apply(String value) {
            Tag tag = new Tag();
            tag.setVType(TagType.STRING);
            tag.setVStr(value);
            return tag;
        }
    };
    private static final Function<? super Boolean, Tag> booleanAttributeConverter = new Function<Boolean, Tag>(){

        public Tag apply(Boolean value) {
            Tag tag = new Tag();
            tag.setVType(TagType.BOOL);
            tag.setVBool(value.booleanValue());
            return tag;
        }
    };
    private static final Function<? super Double, Tag> doubleAttributeConverter = new Function<Double, Tag>(){

        public Tag apply(Double value) {
            Tag tag = new Tag();
            tag.setVType(TagType.DOUBLE);
            tag.setVDouble(value.doubleValue());
            return tag;
        }
    };
    private static final Function<? super Long, Tag> longAttributeConverter = new Function<Long, Tag>(){

        public Tag apply(Long value) {
            Tag tag = new Tag();
            tag.setVType(TagType.LONG);
            tag.setVLong(value.longValue());
            return tag;
        }
    };
    private static final Function<Object, Tag> defaultAttributeConverter = new Function<Object, Tag>(){

        public Tag apply(Object value) {
            Tag tag = new Tag();
            tag.setVType(TagType.STRING);
            tag.setVStr(value.toString());
            return tag;
        }
    };
    private final byte[] spanIdBuffer = new byte[8];
    private final byte[] traceIdBuffer = new byte[16];
    private final byte[] optionsBuffer = new byte[4];
    private final ThriftSender sender;
    private final Process process;

    JaegerExporterHandler(ThriftSender sender, Process process, Duration deadline) {
        super(deadline, EXPORT_SPAN_NAME);
        this.sender = (ThriftSender)Preconditions.checkNotNull((Object)sender, (Object)"Jaeger sender must NOT be null.");
        this.process = (Process)Preconditions.checkNotNull((Object)process, (Object)"Process sending traces must NOT be null.");
    }

    public void timeLimitedExport(Collection<SpanData> spanDataList) throws SenderException {
        List<Span> spans = this.spanDataToJaegerThriftSpans(spanDataList);
        this.sender.send(this.process, spans);
    }

    private List<Span> spanDataToJaegerThriftSpans(Collection<SpanData> spanDataList) {
        ArrayList spans = Lists.newArrayListWithExpectedSize((int)spanDataList.size());
        for (SpanData spanData : spanDataList) {
            spans.add(this.spanDataToJaegerThriftSpan(spanData));
        }
        return spans;
    }

    private Span spanDataToJaegerThriftSpan(SpanData spanData) {
        long startTimeInMicros = JaegerExporterHandler.timestampToMicros(spanData.getStartTimestamp());
        long endTimeInMicros = JaegerExporterHandler.timestampToMicros(spanData.getEndTimestamp());
        SpanContext context = spanData.getContext();
        this.copyToBuffer(context.getTraceId());
        List<Tag> tags = JaegerExporterHandler.attributesToTags(spanData.getAttributes().getAttributeMap(), JaegerExporterHandler.spanKindToTag(spanData.getKind()));
        JaegerExporterHandler.addStatusTags(tags, spanData.getStatus());
        return new Span(this.traceIdLow(), this.traceIdHigh(), this.spanIdToLong(context.getSpanId()), this.spanIdToLong(spanData.getParentSpanId()), spanData.getName(), this.optionsToFlags(context.getTraceOptions()), startTimeInMicros, endTimeInMicros - startTimeInMicros).setReferences(this.linksToReferences(spanData.getLinks().getLinks())).setTags(tags).setLogs(JaegerExporterHandler.timedEventsToLogs(spanData.getAnnotations().getEvents(), spanData.getMessageEvents().getEvents()));
    }

    private void copyToBuffer(TraceId traceId) {
        traceId.copyBytesTo(this.traceIdBuffer, 0);
    }

    private long traceIdHigh() {
        return Longs.fromBytes((byte)this.traceIdBuffer[0], (byte)this.traceIdBuffer[1], (byte)this.traceIdBuffer[2], (byte)this.traceIdBuffer[3], (byte)this.traceIdBuffer[4], (byte)this.traceIdBuffer[5], (byte)this.traceIdBuffer[6], (byte)this.traceIdBuffer[7]);
    }

    private long traceIdLow() {
        return Longs.fromBytes((byte)this.traceIdBuffer[8], (byte)this.traceIdBuffer[9], (byte)this.traceIdBuffer[10], (byte)this.traceIdBuffer[11], (byte)this.traceIdBuffer[12], (byte)this.traceIdBuffer[13], (byte)this.traceIdBuffer[14], (byte)this.traceIdBuffer[15]);
    }

    private long spanIdToLong(@Nullable SpanId spanId) {
        if (spanId == null) {
            return 0L;
        }
        spanId.copyBytesTo(this.spanIdBuffer, 0);
        return Longs.fromByteArray((byte[])this.spanIdBuffer);
    }

    private int optionsToFlags(TraceOptions traceOptions) {
        traceOptions.copyBytesTo(this.optionsBuffer, this.optionsBuffer.length - 1);
        return Ints.fromByteArray((byte[])this.optionsBuffer);
    }

    private List<SpanRef> linksToReferences(List<Link> links) {
        ArrayList spanRefs = Lists.newArrayListWithExpectedSize((int)links.size());
        for (Link link : links) {
            this.copyToBuffer(link.getTraceId());
            spanRefs.add(new SpanRef(JaegerExporterHandler.linkTypeToRefType(link.getType()), this.traceIdLow(), this.traceIdHigh(), this.spanIdToLong(link.getSpanId())));
        }
        return spanRefs;
    }

    private static long timestampToMicros(@Nullable Timestamp timestamp) {
        return timestamp == null ? 0L : TimeUnit.SECONDS.toMicros(timestamp.getSeconds()) + TimeUnit.NANOSECONDS.toMicros(timestamp.getNanos());
    }

    private static SpanRefType linkTypeToRefType(Link.Type type) {
        switch (type) {
            case CHILD_LINKED_SPAN: {
                return SpanRefType.CHILD_OF;
            }
            case PARENT_LINKED_SPAN: {
                return SpanRefType.FOLLOWS_FROM;
            }
        }
        throw new UnsupportedOperationException(String.format("Failed to convert link type [%s] to a Jaeger SpanRefType.", type));
    }

    private static List<Tag> attributesToTags(Map<String, AttributeValue> attributes, @Nullable Tag extraTag) {
        ArrayList tags = Lists.newArrayListWithExpectedSize((int)(attributes.size() + 1));
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            Tag tag = (Tag)entry.getValue().match(stringAttributeConverter, booleanAttributeConverter, longAttributeConverter, doubleAttributeConverter, defaultAttributeConverter);
            tag.setKey(entry.getKey());
            tags.add(tag);
        }
        if (extraTag != null) {
            tags.add(extraTag);
        }
        return tags;
    }

    private static List<Log> timedEventsToLogs(List<SpanData.TimedEvent<Annotation>> annotations, List<SpanData.TimedEvent<MessageEvent>> messageEvents) {
        long timestampsInMicros;
        ArrayList logs = Lists.newArrayListWithExpectedSize((int)(annotations.size() + messageEvents.size()));
        for (SpanData.TimedEvent<Annotation> timedEvent : annotations) {
            timestampsInMicros = JaegerExporterHandler.timestampToMicros(timedEvent.getTimestamp());
            logs.add(new Log(timestampsInMicros, JaegerExporterHandler.attributesToTags(((Annotation)timedEvent.getEvent()).getAttributes(), JaegerExporterHandler.descriptionToTag(((Annotation)timedEvent.getEvent()).getDescription()))));
        }
        for (SpanData.TimedEvent<Annotation> timedEvent : messageEvents) {
            timestampsInMicros = JaegerExporterHandler.timestampToMicros(timedEvent.getTimestamp());
            Tag tagMessageId = new Tag(MESSAGE_EVENT_ID, TagType.LONG).setVLong(((MessageEvent)timedEvent.getEvent()).getMessageId());
            Tag tagCompressedSize = new Tag(MESSAGE_EVENT_COMPRESSED_SIZE, TagType.LONG).setVLong(((MessageEvent)timedEvent.getEvent()).getCompressedMessageSize());
            Tag tagUncompressedSize = new Tag(MESSAGE_EVENT_UNCOMPRESSED_SIZE, TagType.LONG).setVLong(((MessageEvent)timedEvent.getEvent()).getUncompressedMessageSize());
            logs.add(new Log(timestampsInMicros, Arrays.asList(((MessageEvent)timedEvent.getEvent()).getType() == MessageEvent.Type.RECEIVED ? RECEIVED_MESSAGE_EVENT_TAG : SENT_MESSAGE_EVENT_TAG, tagMessageId, tagCompressedSize, tagUncompressedSize)));
        }
        return logs;
    }

    private static Tag descriptionToTag(String description) {
        Tag tag = new Tag(DESCRIPTION, TagType.STRING);
        tag.setVStr(description);
        return tag;
    }

    @Nullable
    private static Tag spanKindToTag(@Nullable Span.Kind kind) {
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case CLIENT: {
                return CLIENT_KIND_TAG;
            }
            case SERVER: {
                return SERVER_KIND_TAG;
            }
        }
        return null;
    }

    private static void addStatusTags(List<Tag> tags, @Nullable Status status) {
        if (status == null) {
            return;
        }
        Tag statusTag = new Tag(STATUS_CODE, TagType.LONG).setVLong((long)status.getCanonicalCode().value());
        tags.add(statusTag);
        if (status.getDescription() != null) {
            tags.add(new Tag(STATUS_MESSAGE, TagType.STRING).setVStr(status.getDescription()));
        }
    }
}

