/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.jaeger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.jaegertracing.thrift.internal.senders.ThriftSender;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.jaeger.AutoValue_JaegerExporterConfiguration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class JaegerExporterConfiguration {
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create((long)10L, (int)0);

    JaegerExporterConfiguration() {
    }

    public abstract String getServiceName();

    public abstract String getThriftEndpoint();

    @Nullable
    public abstract ThriftSender getThriftSender();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_JaegerExporterConfiguration.Builder().setThriftEndpoint("").setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.fromMillis((long)0L);

        Builder() {
        }

        public abstract Builder setServiceName(String var1);

        public abstract Builder setThriftEndpoint(String var1);

        public abstract Builder setThriftSender(ThriftSender var1);

        public abstract Builder setDeadline(Duration var1);

        abstract Duration getDeadline();

        abstract String getThriftEndpoint();

        @Nullable
        abstract ThriftSender getThriftSender();

        abstract JaegerExporterConfiguration autoBuild();

        public JaegerExporterConfiguration build() {
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            Preconditions.checkArgument((!this.getThriftEndpoint().isEmpty() || this.getThriftSender() != null ? 1 : 0) != 0, (Object)"Neither Thrift endpoint nor Thrift sender is specified.");
            return this.autoBuild();
        }
    }
}

