/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.jaeger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thriftjava.Process;
import io.opencensus.exporter.trace.jaeger.JaegerExporterHandler;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class JaegerTraceExporter {
    private static final String REGISTER_NAME = JaegerTraceExporter.class.getName();
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static SpanExporter.Handler handler = null;

    private JaegerTraceExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAndRegister(String thriftEndpoint, String serviceName) {
        Object object = monitor;
        synchronized (object) {
            SpanExporter.Handler newHandler;
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Jaeger exporter is already registered.");
            handler = newHandler = JaegerTraceExporter.newHandler(thriftEndpoint, serviceName);
            JaegerTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), newHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createWithSender(HttpSender httpSender, String serviceName) {
        Object object = monitor;
        synchronized (object) {
            SpanExporter.Handler newHandler;
            Preconditions.checkState((handler == null ? 1 : 0) != 0, (Object)"Jaeger exporter is already registered.");
            handler = newHandler = JaegerTraceExporter.newHandlerWithSender(httpSender, serviceName);
            JaegerTraceExporter.register(Tracing.getExportComponent().getSpanExporter(), newHandler);
        }
    }

    private static SpanExporter.Handler newHandler(String thriftEndpoint, String serviceName) {
        HttpSender sender = new HttpSender.Builder(thriftEndpoint).build();
        Process process = new Process(serviceName);
        return new JaegerExporterHandler(sender, process);
    }

    private static SpanExporter.Handler newHandlerWithSender(HttpSender sender, String serviceName) {
        Process process = new Process(serviceName);
        return new JaegerExporterHandler(sender, process);
    }

    @VisibleForTesting
    static void register(SpanExporter spanExporter, SpanExporter.Handler handler) {
        spanExporter.registerHandler(REGISTER_NAME, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister() {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((handler != null ? 1 : 0) != 0, (Object)"Jaeger exporter is not registered.");
            JaegerTraceExporter.unregister(Tracing.getExportComponent().getSpanExporter());
            handler = null;
        }
    }

    @VisibleForTesting
    static void unregister(SpanExporter spanExporter) {
        spanExporter.unregisterHandler(REGISTER_NAME);
    }
}

