/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.instana;

import com.google.common.io.BaseEncoding;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Scope;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class InstanaExporterHandler
extends SpanExporter.Handler {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Sampler probabilitySpampler = Samplers.probabilitySampler((double)1.0E-4);
    private final URL agentEndpoint;
    private static final Function<Object, String> RETURN_STRING = new Function<Object, String>(){

        public String apply(Object input) {
            return input.toString();
        }
    };

    InstanaExporterHandler(URL agentEndpoint) {
        this.agentEndpoint = agentEndpoint;
    }

    private static String encodeTraceId(TraceId traceId) {
        return BaseEncoding.base16().lowerCase().encode(traceId.getBytes(), 0, 8);
    }

    private static String encodeSpanId(SpanId spanId) {
        return BaseEncoding.base16().lowerCase().encode(spanId.getBytes());
    }

    private static String toSpanName(SpanData spanData) {
        return spanData.getName();
    }

    private static String toSpanType(SpanData spanData) {
        if (spanData.getKind() == Span.Kind.SERVER || spanData.getKind() == null && (spanData.getParentSpanId() == null || Boolean.TRUE.equals(spanData.getHasRemoteParent()))) {
            return "ENTRY";
        }
        if (spanData.getKind() == Span.Kind.CLIENT || spanData.getKind() == null && spanData.getName().startsWith("Sent.")) {
            return "EXIT";
        }
        return "INTERMEDIATE";
    }

    private static long toMillis(Timestamp timestamp) {
        return TimeUnit.SECONDS.toMillis(timestamp.getSeconds()) + TimeUnit.NANOSECONDS.toMillis(timestamp.getNanos());
    }

    private static long toMillis(Timestamp start, Timestamp end) {
        Duration duration = end.subtractTimestamp(start);
        return TimeUnit.SECONDS.toMillis(duration.getSeconds()) + TimeUnit.NANOSECONDS.toMillis(duration.getNanos());
    }

    @Nullable
    private static String attributeValueToString(AttributeValue attributeValue) {
        return (String)attributeValue.match(RETURN_STRING, RETURN_STRING, RETURN_STRING, Functions.returnNull());
    }

    static String convertToJson(Collection<SpanData> spanDataList) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (SpanData span : spanDataList) {
            Map attributeMap;
            SpanContext spanContext = span.getContext();
            SpanId parentSpanId = span.getParentSpanId();
            Timestamp startTimestamp = span.getStartTimestamp();
            Timestamp endTimestamp = span.getEndTimestamp();
            Status status = span.getStatus();
            if (status == null || endTimestamp == null) continue;
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append('{');
            sb.append("\"spanId\":\"").append(InstanaExporterHandler.encodeSpanId(spanContext.getSpanId())).append("\",");
            sb.append("\"traceId\":\"").append(InstanaExporterHandler.encodeTraceId(spanContext.getTraceId())).append("\",");
            if (parentSpanId != null) {
                sb.append("\"parentId\":\"").append(InstanaExporterHandler.encodeSpanId(parentSpanId)).append("\",");
            }
            sb.append("\"timestamp\":").append(InstanaExporterHandler.toMillis(startTimestamp)).append(',');
            sb.append("\"duration\":").append(InstanaExporterHandler.toMillis(startTimestamp, endTimestamp)).append(',');
            sb.append("\"name\":\"").append(InstanaExporterHandler.toSpanName(span)).append("\",");
            sb.append("\"type\":\"").append(InstanaExporterHandler.toSpanType(span)).append('\"');
            if (!status.isOk()) {
                sb.append(",\"error\":").append("true");
            }
            if ((attributeMap = span.getAttributes().getAttributeMap()).size() > 0) {
                StringBuilder dataSb = new StringBuilder();
                dataSb.append('{');
                for (Map.Entry entry : attributeMap.entrySet()) {
                    if (dataSb.length() > 1) {
                        dataSb.append(',');
                    }
                    dataSb.append("\"").append((String)entry.getKey()).append("\":\"").append(InstanaExporterHandler.attributeValueToString((AttributeValue)entry.getValue())).append("\"");
                }
                dataSb.append('}');
                sb.append(",\"data\":").append((CharSequence)dataSb);
            }
            sb.append('}');
        }
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Collection<SpanData> spanDataList) {
        Scope scope = tracer.spanBuilder("ExportInstanaTraces").setSampler(probabilitySpampler).startScopedSpan();
        try {
            String json = InstanaExporterHandler.convertToJson(spanDataList);
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                HttpURLConnection connection = (HttpURLConnection)this.agentEndpoint.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                outputStream = connection.getOutputStream();
                outputStream.write(json.getBytes(Charset.defaultCharset()));
                outputStream.flush();
                inputStream = connection.getInputStream();
                if (connection.getResponseCode() != 200) {
                    tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription("Response " + connection.getResponseCode()));
                }
            }
            catch (IOException e) {
                tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription(e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            scope.close();
        }
    }
}

