/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.datadog;

import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.datadog.DatadogTraceConfiguration;

final class AutoValue_DatadogTraceConfiguration
extends DatadogTraceConfiguration {
    private final String agentEndpoint;
    private final String service;
    private final String type;
    private final Duration deadline;

    private AutoValue_DatadogTraceConfiguration(String agentEndpoint, String service, String type, Duration deadline) {
        this.agentEndpoint = agentEndpoint;
        this.service = service;
        this.type = type;
        this.deadline = deadline;
    }

    @Override
    public String getAgentEndpoint() {
        return this.agentEndpoint;
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Duration getDeadline() {
        return this.deadline;
    }

    public String toString() {
        return "DatadogTraceConfiguration{agentEndpoint=" + this.agentEndpoint + ", service=" + this.service + ", type=" + this.type + ", deadline=" + this.deadline + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatadogTraceConfiguration) {
            DatadogTraceConfiguration that = (DatadogTraceConfiguration)o;
            return this.agentEndpoint.equals(that.getAgentEndpoint()) && this.service.equals(that.getService()) && this.type.equals(that.getType()) && this.deadline.equals(that.getDeadline());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.agentEndpoint.hashCode();
        h *= 1000003;
        h ^= this.service.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        return h ^= this.deadline.hashCode();
    }

    static final class Builder
    extends DatadogTraceConfiguration.Builder {
        private String agentEndpoint;
        private String service;
        private String type;
        private Duration deadline;

        Builder() {
        }

        @Override
        public DatadogTraceConfiguration.Builder setAgentEndpoint(String agentEndpoint) {
            if (agentEndpoint == null) {
                throw new NullPointerException("Null agentEndpoint");
            }
            this.agentEndpoint = agentEndpoint;
            return this;
        }

        @Override
        public DatadogTraceConfiguration.Builder setService(String service) {
            if (service == null) {
                throw new NullPointerException("Null service");
            }
            this.service = service;
            return this;
        }

        @Override
        public DatadogTraceConfiguration.Builder setType(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public DatadogTraceConfiguration.Builder setDeadline(Duration deadline) {
            if (deadline == null) {
                throw new NullPointerException("Null deadline");
            }
            this.deadline = deadline;
            return this;
        }

        @Override
        Duration getDeadline() {
            if (this.deadline == null) {
                throw new IllegalStateException("Property \"deadline\" has not been set");
            }
            return this.deadline;
        }

        @Override
        DatadogTraceConfiguration autoBuild() {
            String missing = "";
            if (this.agentEndpoint == null) {
                missing = missing + " agentEndpoint";
            }
            if (this.service == null) {
                missing = missing + " service";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.deadline == null) {
                missing = missing + " deadline";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DatadogTraceConfiguration(this.agentEndpoint, this.service, this.type, this.deadline);
        }
    }
}

