/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.datadog;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.opencensus.common.Duration;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.exporter.trace.datadog.DatadogSpan;
import io.opencensus.exporter.trace.util.TimeLimitedHandler;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class DatadogExporterHandler
extends TimeLimitedHandler {
    private static final String EXPORT_SPAN_NAME = "ExportDatadogTraces";
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final URL agentEndpoint;
    private final String service;
    private final String type;

    DatadogExporterHandler(String agentEndpoint, String service, String type, Duration deadline) throws MalformedURLException {
        super(deadline, EXPORT_SPAN_NAME);
        this.agentEndpoint = new URL(agentEndpoint);
        this.service = service;
        this.type = type;
    }

    private static String attributeValueToString(AttributeValue attributeValue) {
        return (String)attributeValue.match(Functions.returnToString(), Functions.returnToString(), Functions.returnToString(), Functions.returnToString(), Functions.throwIllegalArgumentException());
    }

    private static Map<String, String> attributesToMeta(Map<String, AttributeValue> attributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        attributes.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> result.put((String)entry.getKey(), DatadogExporterHandler.attributeValueToString((AttributeValue)entry.getValue())));
        return result;
    }

    private static long convertSpanId(SpanId spanId) {
        byte[] bytes = spanId.getBytes();
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes[i] & 0xFF);
        }
        if (result < 0L) {
            return -result;
        }
        return result;
    }

    private static long timestampToNanos(Timestamp timestamp) {
        return TimeUnit.SECONDS.toNanos(timestamp.getSeconds()) + (long)timestamp.getNanos();
    }

    private static Integer errorCode(@Nullable Status status) {
        if (status == null || status.equals((Object)Status.OK) || status.equals((Object)Status.ALREADY_EXISTS)) {
            return 0;
        }
        return 1;
    }

    String convertToJson(Collection<SpanData> spanDataList) {
        ArrayList<DatadogSpan> datadogSpans = new ArrayList<DatadogSpan>();
        for (SpanData sd : spanDataList) {
            SpanContext sc = sd.getContext();
            long startTime = DatadogExporterHandler.timestampToNanos(sd.getStartTimestamp());
            Timestamp endTimestamp = Optional.ofNullable(sd.getEndTimestamp()).orElseGet(() -> Tracing.getClock().now());
            long endTime = DatadogExporterHandler.timestampToNanos(endTimestamp);
            long duration = endTime - startTime;
            Long parentId = Optional.ofNullable(sd.getParentSpanId()).map(DatadogExporterHandler::convertSpanId).orElse(null);
            Map attributes = sd.getAttributes().getAttributeMap();
            Map<Object, Object> meta = attributes.isEmpty() ? new HashMap() : DatadogExporterHandler.attributesToMeta(attributes);
            String resource = meta.getOrDefault("resource", "UNKNOWN");
            DatadogSpan span = new DatadogSpan(sc.getTraceId().getLowerLong(), DatadogExporterHandler.convertSpanId(sc.getSpanId()), sd.getName(), resource, this.service, this.type, startTime, duration, parentId, DatadogExporterHandler.errorCode(sd.getStatus()), meta);
            datadogSpans.add(span);
        }
        Collection traces = datadogSpans.stream().collect(Collectors.groupingBy(DatadogSpan::getTraceId, Collectors.toList())).values();
        return gson.toJson(traces);
    }

    public void timeLimitedExport(Collection<SpanData> spanDataList) throws Exception {
        String data = this.convertToJson(spanDataList);
        HttpURLConnection connection = (HttpURLConnection)this.agentEndpoint.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(data.getBytes(Charset.defaultCharset()));
        outputStream.flush();
        outputStream.close();
        if (connection.getResponseCode() != 200) {
            throw new Exception("Response " + connection.getResponseCode());
        }
    }
}

