/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.metrics.ocagent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.handler.ssl.SslContext;
import io.opencensus.common.Duration;
import io.opencensus.exporter.metrics.ocagent.OcAgentMetricsExporterConfiguration;
import io.opencensus.exporter.metrics.ocagent.OcAgentMetricsExporterWorker;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.MetricProducerManager;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OcAgentMetricsExporter {
    @VisibleForTesting
    static final String DEFAULT_END_POINT = "localhost:55678";
    private static final String DEFAULT_SERVICE_NAME = "OpenCensus";
    private static final Duration DEFAULT_RETRY_INTERVAL = Duration.create((long)300L, (int)0);
    private static final Duration DEFAULT_EXPORT_INTERVAL = Duration.create((long)60L, (int)0);
    private static final Duration ZERO = Duration.create((long)0L, (int)0);
    private static final Object monitor = new Object();
    @Nullable
    @GuardedBy(value="monitor")
    private static OcAgentMetricsExporter exporter = null;
    private final Thread workerThread;

    public static void createAndRegister(OcAgentMetricsExporterConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        OcAgentMetricsExporter.createInternal(configuration.getEndPoint(), configuration.getUseInsecure(), configuration.getSslContext(), configuration.getServiceName(), configuration.getExportInterval(), configuration.getRetryInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInternal(@Nullable String endPoint, @Nullable Boolean useInsecure, @Nullable SslContext sslContext, @Nullable String serviceName, @Nullable Duration exportInterval, @Nullable Duration retryInterval) {
        if (endPoint == null || endPoint.isEmpty()) {
            endPoint = DEFAULT_END_POINT;
        }
        if (useInsecure == null) {
            useInsecure = false;
        }
        Preconditions.checkArgument((useInsecure == (sslContext == null) ? 1 : 0) != 0, (Object)"Either use insecure or provide a valid SslContext.");
        if (serviceName == null || serviceName.isEmpty()) {
            serviceName = DEFAULT_SERVICE_NAME;
        }
        if (exportInterval == null) {
            exportInterval = DEFAULT_EXPORT_INTERVAL;
        }
        if (retryInterval == null) {
            retryInterval = DEFAULT_RETRY_INTERVAL;
        }
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState((exporter == null ? 1 : 0) != 0, (Object)"OcAgent Metrics exporter is already created.");
            exporter = new OcAgentMetricsExporter(endPoint, useInsecure, sslContext, serviceName, exportInterval, retryInterval, Metrics.getExportComponent().getMetricProducerManager());
            OcAgentMetricsExporter.exporter.workerThread.start();
        }
    }

    private OcAgentMetricsExporter(String endPoint, Boolean useInsecure, @Nullable SslContext sslContext, String serviceName, Duration exportInterval, Duration retryInterval, MetricProducerManager metricProducerManager) {
        Preconditions.checkArgument((exportInterval.compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Duration must be positive");
        Preconditions.checkArgument((retryInterval.compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Duration must be positive");
        OcAgentMetricsExporterWorker worker = new OcAgentMetricsExporterWorker(endPoint, useInsecure, sslContext, exportInterval, retryInterval, serviceName, metricProducerManager);
        this.workerThread = new Thread(worker);
        this.workerThread.setDaemon(true);
        this.workerThread.setName("OcAgentMetricsExporterWorker");
    }
}

