/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.zpages;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.HtmlEscapers;
import com.google.common.io.BaseEncoding;
import io.opencensus.common.Duration;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.zpages.ZPageHandler;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.NetworkEvent;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.RunningSpanStore;
import io.opencensus.trace.export.SampledSpanStore;
import io.opencensus.trace.export.SpanData;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class TracezZPageHandler
extends ZPageHandler {
    private static final String TRACEZ_URL = "/tracez";
    private static final Tracer tracer = Tracing.getTracer();
    private static final String ZEBRA_STRIPE_COLOR = "#eee";
    private static final String SAMPLED_TRACE_ID_COLOR = "blue";
    private static final String NOT_SAMPLED_TRACE_ID_COLOR = "black";
    private static final String HEADER_SPAN_NAME = "zspanname";
    private static final String HEADER_SAMPLES_TYPE = "ztype";
    private static final String HEADER_SAMPLES_SUB_TYPE = "zsubtype";
    private static final Map<SampledSpanStore.LatencyBucketBoundaries, String> LATENCY_BUCKET_BOUNDARIES_STRING_MAP = TracezZPageHandler.buildLatencyBucketBoundariesStringMap();
    @Nullable
    private final RunningSpanStore runningSpanStore;
    @Nullable
    private final SampledSpanStore sampledSpanStore;

    private TracezZPageHandler(@Nullable RunningSpanStore runningSpanStore, @Nullable SampledSpanStore sampledSpanStore) {
        this.runningSpanStore = runningSpanStore;
        this.sampledSpanStore = sampledSpanStore;
    }

    static TracezZPageHandler create(@Nullable RunningSpanStore runningSpanStore, @Nullable SampledSpanStore sampledSpanStore) {
        return new TracezZPageHandler(runningSpanStore, sampledSpanStore);
    }

    @Override
    public String getUrlPath() {
        return TRACEZ_URL;
    }

    @Override
    public void emitHtml(Map<String, String> queryMap, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8)));
        out.write("<!DOCTYPE html>\n");
        out.write("<html lang=\"en\"><head>\n");
        out.write("<meta charset=\"utf-8\">\n");
        out.write("<title>TraceZ</title>\n");
        out.write("<link rel=\"shortcut icon\" href=\"//www.opencensus.io/favicon.ico\"/>\n");
        out.write("</head>\n");
        out.write("<body>\n");
        try {
            this.emitHtmlBody(queryMap, out);
        }
        catch (Throwable t) {
            out.write("Errors while generate the HTML page " + t);
        }
        out.write("</body>\n");
        out.write("</html>\n");
        out.close();
    }

    private void emitHtmlBody(Map<String, String> queryMap, PrintWriter out) throws UnsupportedEncodingException {
        if (this.runningSpanStore == null || this.sampledSpanStore == null) {
            out.write("OpenCensus implementation not available.");
            return;
        }
        Formatter formatter = new Formatter(out, Locale.US);
        this.emitSummaryTable(out, formatter);
        String spanName = queryMap.get(HEADER_SPAN_NAME);
        if (spanName != null) {
            tracer.getCurrentSpan().addAnnotation("Render spans.", (Map)ImmutableMap.builder().put((Object)"SpanName", (Object)AttributeValue.stringAttributeValue((String)spanName)).build());
            String typeStr = queryMap.get(HEADER_SAMPLES_TYPE);
            if (typeStr != null) {
                ArrayList<Object> spans = null;
                RequestType type = RequestType.fromString(typeStr);
                if (type == RequestType.UNKNOWN) {
                    return;
                }
                if (type == RequestType.RUNNING) {
                    spans = new ArrayList<SpanData>(this.runningSpanStore.getRunningSpans(RunningSpanStore.Filter.create((String)spanName, (int)0)));
                    Collections.sort(spans, new SpanDataComparator(true));
                } else {
                    String subtypeStr = queryMap.get(HEADER_SAMPLES_SUB_TYPE);
                    if (subtypeStr != null) {
                        int subtype = Integer.parseInt(subtypeStr);
                        if (type == RequestType.FAILED) {
                            if (subtype < 0 || subtype >= Status.CanonicalCode.values().length) {
                                return;
                            }
                            Status.CanonicalCode code = subtype == 0 ? null : Status.CanonicalCode.values()[subtype];
                            spans = new ArrayList(this.sampledSpanStore.getErrorSampledSpans(SampledSpanStore.ErrorFilter.create((String)spanName, (Status.CanonicalCode)code, (int)0)));
                        } else {
                            if (subtype < 0 || subtype >= SampledSpanStore.LatencyBucketBoundaries.values().length) {
                                return;
                            }
                            SampledSpanStore.LatencyBucketBoundaries latencyBucketBoundaries = SampledSpanStore.LatencyBucketBoundaries.values()[subtype];
                            spans = new ArrayList(this.sampledSpanStore.getLatencySampledSpans(SampledSpanStore.LatencyFilter.create((String)spanName, (long)latencyBucketBoundaries.getLatencyLowerNs(), (long)latencyBucketBoundaries.getLatencyUpperNs(), (int)0)));
                            Collections.sort(spans, new SpanDataComparator(false));
                        }
                    }
                }
                TracezZPageHandler.emitSpanNameAndCountPages(formatter, spanName, spans == null ? 0 : spans.size(), type);
                if (spans != null) {
                    TracezZPageHandler.emitSpans(out, formatter, spans);
                    TracezZPageHandler.emitLegend(out);
                }
            }
        }
    }

    private static void emitSpanNameAndCountPages(Formatter formatter, String spanName, int returnedNum, RequestType type) {
        formatter.format("<p><b>Span Name: %s </b></p>%n", HtmlEscapers.htmlEscaper().escape(spanName));
        formatter.format("%s Requests %d</b></p>%n", type == RequestType.RUNNING ? "Running" : (type == RequestType.FINISHED ? "Finished" : "Failed"), returnedNum);
    }

    private static void emitSpans(PrintWriter out, Formatter formatter, Collection<SpanData> spans) {
        out.write("<pre>\n");
        formatter.format("%-23s %18s%n", "When", "Elapsed(s)");
        out.write("-------------------------------------------\n");
        for (SpanData span : spans) {
            tracer.getCurrentSpan().addAnnotation("Render span.", (Map)ImmutableMap.builder().put((Object)"SpanId", (Object)AttributeValue.stringAttributeValue((String)BaseEncoding.base16().lowerCase().encode(span.getContext().getSpanId().getBytes()))).build());
            TracezZPageHandler.emitSingleSpan(out, formatter, span);
        }
        out.write("</pre>\n");
    }

    private static void emitSingleSpan(PrintWriter out, Formatter formatter, SpanData span) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUnit.SECONDS.toMillis(span.getStartTimestamp().getSeconds()));
        long microsField = TimeUnit.NANOSECONDS.toMicros(span.getStartTimestamp().getNanos());
        String elapsedSecondsStr = span.getEndTimestamp() != null ? String.format("%13.6f", (double)TracezZPageHandler.durationToNanos(span.getEndTimestamp().subtractTimestamp(span.getStartTimestamp())) * 1.0E-9) : String.format("%13s", " ");
        SpanContext spanContext = span.getContext();
        formatter.format("<b>%04d/%02d/%02d-%02d:%02d:%02d.%06d %s     TraceId: <b style=\"color:%s;\">%s</b> SpanId: %s ParentSpanId: %s</b>%n", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), microsField, elapsedSecondsStr, spanContext.getTraceOptions().isSampled() ? SAMPLED_TRACE_ID_COLOR : NOT_SAMPLED_TRACE_ID_COLOR, BaseEncoding.base16().lowerCase().encode(spanContext.getTraceId().getBytes()), BaseEncoding.base16().lowerCase().encode(spanContext.getSpanId().getBytes()), BaseEncoding.base16().lowerCase().encode(span.getParentSpanId() == null ? SpanId.INVALID.getBytes() : span.getParentSpanId().getBytes()));
        int lastEntryDayOfYear = calendar.get(6);
        Timestamp lastTimestampNanos = span.getStartTimestamp();
        SpanData.TimedEvents annotations = span.getAnnotations();
        SpanData.TimedEvents networkEvents = span.getNetworkEvents();
        ArrayList timedEvents = new ArrayList(annotations.getEvents());
        timedEvents.addAll(networkEvents.getEvents());
        Collections.sort(timedEvents, new TimedEventComparator());
        for (SpanData.TimedEvent event : timedEvents) {
            long deltaMicros = TimeUnit.NANOSECONDS.toMicros(TracezZPageHandler.durationToNanos(event.getTimestamp().subtractTimestamp(lastTimestampNanos)));
            String deltaString = deltaMicros >= 1000000L ? String.format("%.6f", (double)deltaMicros / 1000000.0) : String.format(".%6d", deltaMicros);
            calendar.setTimeInMillis(TimeUnit.SECONDS.toMillis(event.getTimestamp().getSeconds()) + TimeUnit.NANOSECONDS.toMillis(event.getTimestamp().getNanos()));
            microsField = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp().getNanos());
            int dayOfYear = calendar.get(6);
            if (dayOfYear == lastEntryDayOfYear) {
                formatter.format("%11s", "");
            } else {
                formatter.format("%04d/%02d/%02d-", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                lastEntryDayOfYear = dayOfYear;
            }
            formatter.format("%02d:%02d:%02d.%06d %13s ... %s%n", calendar.get(11), calendar.get(12), calendar.get(13), microsField, deltaString, HtmlEscapers.htmlEscaper().escape(event.getEvent() instanceof Annotation ? TracezZPageHandler.renderAnnotation((Annotation)event.getEvent()) : TracezZPageHandler.renderNetworkEvents((NetworkEvent)TracezZPageHandler.castNonNull(event.getEvent()))));
            lastTimestampNanos = event.getTimestamp();
        }
        Status status = span.getStatus();
        if (status != null) {
            formatter.format("%44s %s%n", "", HtmlEscapers.htmlEscaper().escape(TracezZPageHandler.renderStatus(status)));
        }
        formatter.format("%44s %s%n", "", HtmlEscapers.htmlEscaper().escape(TracezZPageHandler.renderAttributes(span.getAttributes().getAttributeMap())));
    }

    private static <T> T castNonNull(@Nullable T arg) {
        return arg;
    }

    private void emitSummaryTable(PrintWriter out, Formatter formatter) throws UnsupportedEncodingException {
        if (this.runningSpanStore == null || this.sampledSpanStore == null) {
            return;
        }
        RunningSpanStore.Summary runningSpanStoreSummary = this.runningSpanStore.getSummary();
        SampledSpanStore.Summary sampledSpanStoreSummary = this.sampledSpanStore.getSummary();
        out.write("<table style='border-spacing: 0'>\n");
        TracezZPageHandler.emitSummaryTableHeader(out, formatter);
        TreeSet spanNames = new TreeSet(runningSpanStoreSummary.getPerSpanNameSummary().keySet());
        spanNames.addAll(sampledSpanStoreSummary.getPerSpanNameSummary().keySet());
        boolean zebraColor = true;
        for (String spanName : spanNames) {
            out.write("<tr>\n");
            if (!zebraColor) {
                out.write("<tr>\n");
            } else {
                formatter.format("<tr style=\"background: %s\">%n", ZEBRA_STRIPE_COLOR);
            }
            zebraColor = !zebraColor;
            formatter.format("<td>%s</td>%n", HtmlEscapers.htmlEscaper().escape(spanName));
            out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
            RunningSpanStore.PerSpanNameSummary runningSpanStorePerSpanNameSummary = (RunningSpanStore.PerSpanNameSummary)runningSpanStoreSummary.getPerSpanNameSummary().get(spanName);
            TracezZPageHandler.emitSingleCell(out, formatter, spanName, runningSpanStorePerSpanNameSummary == null ? 0 : runningSpanStorePerSpanNameSummary.getNumRunningSpans(), RequestType.RUNNING, 0);
            SampledSpanStore.PerSpanNameSummary sampledSpanStorePerSpanNameSummary = (SampledSpanStore.PerSpanNameSummary)sampledSpanStoreSummary.getPerSpanNameSummary().get(spanName);
            out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
            Map latencyBucketsSummaries = sampledSpanStorePerSpanNameSummary != null ? sampledSpanStorePerSpanNameSummary.getNumbersOfLatencySampledSpans() : null;
            int subtype = 0;
            for (SampledSpanStore.LatencyBucketBoundaries latencyBucketsBoundaries : SampledSpanStore.LatencyBucketBoundaries.values()) {
                if (latencyBucketsSummaries != null) {
                    int numSamples = latencyBucketsSummaries.containsKey(latencyBucketsBoundaries) ? (Integer)latencyBucketsSummaries.get(latencyBucketsBoundaries) : 0;
                    TracezZPageHandler.emitSingleCell(out, formatter, spanName, numSamples, RequestType.FINISHED, subtype++);
                    continue;
                }
                TracezZPageHandler.emitSingleCell(out, formatter, spanName, -1, RequestType.FINISHED, subtype++);
            }
            out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
            if (sampledSpanStorePerSpanNameSummary != null) {
                Map errorBucketsSummaries = sampledSpanStorePerSpanNameSummary.getNumbersOfErrorSampledSpans();
                int numErrorSamples = 0;
                for (Map.Entry it : errorBucketsSummaries.entrySet()) {
                    numErrorSamples += ((Integer)it.getValue()).intValue();
                }
                TracezZPageHandler.emitSingleCell(out, formatter, spanName, numErrorSamples, RequestType.FAILED, 0);
            } else {
                TracezZPageHandler.emitSingleCell(out, formatter, spanName, -1, RequestType.FAILED, 0);
            }
            out.write("</tr>\n");
        }
        out.write("</table>");
    }

    private static void emitSummaryTableHeader(PrintWriter out, Formatter formatter) {
        out.write("<tr><td colspan=25 align=\"center\"><font size=\"5\"><b>TraceZ Summary</b></font></td></tr>\n");
        out.write("<tr>\n");
        out.write("<td colspan=1 align=\"center\"><b>Span Name</b></td>\n");
        out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
        out.write("<td colspan=1 align=\"center\"><b>Running</b></td>\n");
        out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
        out.write("<td colspan=9 align=\"center\"><b>Latency Samples</b></td>\n");
        out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
        out.write("<td colspan=1 align=\"center\"><b>Error Samples</b></td>\n");
        out.write("</tr>\n");
        out.write("<tr>\n");
        out.write("<td colspan=1></td>\n");
        out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
        out.write("<td colspan=1></td>\n");
        out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
        for (SampledSpanStore.LatencyBucketBoundaries latencyBucketsBoundaries : SampledSpanStore.LatencyBucketBoundaries.values()) {
            formatter.format("<td colspan=1 align=\"center\"><b>[%s]</b></td>%n", LATENCY_BUCKET_BOUNDARIES_STRING_MAP.get(latencyBucketsBoundaries));
        }
        out.write("<td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>");
        out.write("<td colspan=1></td>\n");
        out.write("</tr>\n");
    }

    private static void emitSingleCell(PrintWriter out, Formatter formatter, String spanName, int numSamples, RequestType type, int subtype) throws UnsupportedEncodingException {
        if (numSamples > 0) {
            formatter.format("<td align=\"center\"><a href='?%s=%s&%s=%d&%s=%d'>%d</a></td>%n", HEADER_SPAN_NAME, URLEncoder.encode(spanName, "UTF-8"), HEADER_SAMPLES_TYPE, type.getValue(), HEADER_SAMPLES_SUB_TYPE, subtype, numSamples);
        } else if (numSamples < 0) {
            out.write("<td align=\"center\">N/A</td>\n");
        } else {
            out.write("<td align=\"center\">0</td>\n");
        }
    }

    private static void emitLegend(PrintWriter out) {
        out.write("<br>\n");
        out.printf("<p><b style=\"color:%s;\">TraceId</b> means sampled request. <b style=\"color:%s;\">TraceId</b> means not sampled request.</p>%n", SAMPLED_TRACE_ID_COLOR, NOT_SAMPLED_TRACE_ID_COLOR);
    }

    private static Map<SampledSpanStore.LatencyBucketBoundaries, String> buildLatencyBucketBoundariesStringMap() {
        HashMap<SampledSpanStore.LatencyBucketBoundaries, String> ret = new HashMap<SampledSpanStore.LatencyBucketBoundaries, String>();
        for (SampledSpanStore.LatencyBucketBoundaries latencyBucketBoundaries : SampledSpanStore.LatencyBucketBoundaries.values()) {
            ret.put(latencyBucketBoundaries, TracezZPageHandler.latencyBucketBoundariesToString(latencyBucketBoundaries));
        }
        return Collections.unmodifiableMap(ret);
    }

    private static long durationToNanos(Duration duration) {
        return TimeUnit.SECONDS.toNanos(duration.getSeconds()) + (long)duration.getNanos();
    }

    private static String latencyBucketBoundariesToString(SampledSpanStore.LatencyBucketBoundaries latencyBucketBoundaries) {
        switch (latencyBucketBoundaries) {
            case ZERO_MICROSx10: {
                return ">0us";
            }
            case MICROSx10_MICROSx100: {
                return ">10us";
            }
            case MICROSx100_MILLIx1: {
                return ">100us";
            }
            case MILLIx1_MILLIx10: {
                return ">1ms";
            }
            case MILLIx10_MILLIx100: {
                return ">10ms";
            }
            case MILLIx100_SECONDx1: {
                return ">100ms";
            }
            case SECONDx1_SECONDx10: {
                return ">1s";
            }
            case SECONDx10_SECONDx100: {
                return ">10s";
            }
            case SECONDx100_MAX: {
                return ">100s";
            }
        }
        throw new IllegalArgumentException("No value string available for: " + latencyBucketBoundaries);
    }

    private static String renderNetworkEvents(NetworkEvent networkEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (networkEvent.getType() == NetworkEvent.Type.RECV) {
            stringBuilder.append("Received message");
        } else if (networkEvent.getType() == NetworkEvent.Type.SENT) {
            stringBuilder.append("Sent message");
        } else {
            stringBuilder.append("Unknown");
        }
        stringBuilder.append(" id=");
        stringBuilder.append(networkEvent.getMessageId());
        stringBuilder.append(" uncompressed_size=");
        stringBuilder.append(networkEvent.getUncompressedMessageSize());
        stringBuilder.append(" compressed_size=");
        stringBuilder.append(networkEvent.getCompressedMessageSize());
        return stringBuilder.toString();
    }

    private static String renderAnnotation(Annotation annotation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(annotation.getDescription());
        if (!annotation.getAttributes().isEmpty()) {
            stringBuilder.append(" ");
            stringBuilder.append(TracezZPageHandler.renderAttributes(annotation.getAttributes()));
        }
        return stringBuilder.toString();
    }

    private static String renderStatus(Status status) {
        return status.toString();
    }

    private static String renderAttributes(Map<String, AttributeValue> attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attributes:{");
        boolean first = true;
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            if (first) {
                first = false;
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(TracezZPageHandler.attributeValueToString(entry.getValue()));
                continue;
            }
            stringBuilder.append(", ");
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(TracezZPageHandler.attributeValueToString(entry.getValue()));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Nullable
    private static String attributeValueToString(AttributeValue attributeValue) {
        return (String)attributeValue.match((Function)new Function<String, String>(){

            public String apply(String stringValue) {
                return stringValue;
            }
        }, (Function)new Function<Boolean, String>(){

            public String apply(Boolean booleanValue) {
                return booleanValue.toString();
            }
        }, (Function)new Function<Long, String>(){

            public String apply(Long longValue) {
                return longValue.toString();
            }
        }, Functions.returnNull());
    }

    private static final class SpanDataComparator
    implements Comparator<SpanData>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean incremental;

        private SpanDataComparator(boolean incremental) {
            this.incremental = incremental;
        }

        @Override
        public int compare(SpanData o1, SpanData o2) {
            return this.incremental ? o1.getStartTimestamp().compareTo(o2.getStartTimestamp()) : o2.getStartTimestamp().compareTo(o1.getStartTimestamp());
        }
    }

    private static final class TimedEventComparator
    implements Comparator<SpanData.TimedEvent<?>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private TimedEventComparator() {
        }

        @Override
        public int compare(SpanData.TimedEvent<?> o1, SpanData.TimedEvent<?> o2) {
            return o1.getTimestamp().compareTo(o2.getTimestamp());
        }
    }

    private static enum RequestType {
        RUNNING(0),
        FINISHED(1),
        FAILED(2),
        UNKNOWN(-1);

        private final int value;

        private RequestType(int value) {
            this.value = value;
        }

        static RequestType fromString(String str) {
            int value = Integer.parseInt(str);
            switch (value) {
                case 0: {
                    return RUNNING;
                }
                case 1: {
                    return FINISHED;
                }
                case 2: {
                    return FAILED;
                }
            }
            return UNKNOWN;
        }

        int getValue() {
            return this.value;
        }
    }
}

