/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.zpages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.opencensus.common.Function;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.zpages.ZPageHandler;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.Measure;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class StatszZPageHandler
extends ZPageHandler {
    private static final Object monitor = new Object();
    private final ViewManager viewManager;
    @GuardedBy(value="monitor")
    private final Map<String, Measure> measures = Maps.newTreeMap();
    @GuardedBy(value="monitor")
    private final Set<View> cachedViews = Sets.newHashSet();
    @GuardedBy(value="monitor")
    private final TreeNode root = new TreeNode();
    @VisibleForTesting
    static final String QUERY_PATH = "path";
    private static final String STATSZ_URL = "/statsz";
    private static final String TITLE_COLOR = "#eeeeff";
    private static final String TABLE_BACKGROUND_COLOR = "#fff5ee";
    private static final String TABLE_HEADER_COLOR = "#eee5de";
    private static final String ALIGN_CENTER = "align=\"center\"";
    private static final String TABLE_BORDER = "border=\"1\"";
    private static final String CLASS_LARGER_TR = "directory-tr";
    private static final String TABLE_HEADER_VIEW = "View Name";
    private static final String TABLE_HEADER_DESCRIPTION = "Description";
    private static final String TABLE_HEADER_MEASURE = "Measure";
    private static final String TABLE_HEADER_AGGREGATION = "Aggregation Type";
    private static final String TABLE_HEADER_START = "Start Time";
    private static final String TABLE_HEADER_END = "End Time";
    private static final String TABLE_HEADER_UNIT = "Unit";
    private static final String TABLE_HEADER_MEASURE_TYPE = "Type";
    private static final String TABLE_HEADER_SUM = "Sum";
    private static final String TABLE_HEADER_COUNT = "Count";
    private static final String TABLE_HEADER_MEAN = "Mean";
    private static final String TABLE_HEADER_MAX = "Max";
    private static final String TABLE_HEADER_MIN = "Min";
    private static final String TABLE_HEADER_DEV = "Sum of Squared Deviations";
    private static final String TABLE_HEADER_HISTOGRAM = "Histogram";
    private static final String TABLE_HEADER_RANGE = "Range";
    private static final String TABLE_HEADER_BUCKET_SIZE = "Bucket Size";
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');

    @Override
    public String getUrlPath() {
        return STATSZ_URL;
    }

    @Override
    public void emitHtml(Map<String, String> queryMap, OutputStream outputStream) {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8)));
        out.write("<!DOCTYPE html>\n");
        out.write("<html lang=\"en\"><head>\n");
        out.write("<meta charset=\"utf-8\">\n");
        out.write("<title>StatsZ</title>\n");
        out.write("<link rel=\"shortcut icon\" href=\"//www.opencensus.io/favicon.ico\"/>\n");
        Formatter formatter = new Formatter(out, Locale.US);
        StatszZPageHandler.emitStyles(out, formatter);
        out.write("</head>\n");
        out.write("<body>\n");
        try {
            this.emitHtmlBody(queryMap, out, formatter);
        }
        catch (Throwable t) {
            out.write("Errors while generate the HTML page " + t);
        }
        out.write("</body>\n");
        out.write("</html>\n");
        out.close();
    }

    private static void emitStyles(PrintWriter out, Formatter formatter) {
        out.write("<style>");
        formatter.format("h2{background-color: %s;}", TITLE_COLOR);
        formatter.format("table{background-color: %s;}", TABLE_BACKGROUND_COLOR);
        formatter.format("thead{background-color: %s;}", TABLE_HEADER_COLOR);
        formatter.format(".%s{font-size:150%%}", CLASS_LARGER_TR);
        out.write("</style>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitHtmlBody(Map<String, String> queryMap, PrintWriter out, Formatter formatter) {
        Object object = monitor;
        synchronized (object) {
            StatszZPageHandler.groupViewsByDirectoriesAndGetMeasures(this.viewManager.getAllExportedViews(), this.root, this.measures, this.cachedViews);
            out.write("<h1><a href='?'>StatsZ</a></h1>");
            out.write("<p></p>");
            String path = queryMap.get(QUERY_PATH);
            TreeNode current = this.findNode(path);
            this.emitDirectoryTable(current, path, out, formatter);
            if (current != null && current.view != null) {
                ViewData viewData = this.viewManager.getView(current.view.getName());
                StatszZPageHandler.emitViewData(viewData, current.view.getName(), out, formatter);
            }
            StatszZPageHandler.emitMeasureTable(this.measures, out, formatter);
        }
    }

    private static void groupViewsByDirectoriesAndGetMeasures(Set<View> views, TreeNode root, Map<String, Measure> measures, Set<View> cachedViews) {
        for (View view : views) {
            if (cachedViews.contains(view)) continue;
            cachedViews.add(view);
            List dirs = PATH_SPLITTER.splitToList((CharSequence)view.getName().asString());
            TreeNode node = root;
            for (int i = 0; i < dirs.size() && node != null; ++i) {
                String dir = (String)dirs.get(i);
                if ("".equals(dir) && i == 0) continue;
                ++node.views;
                if (i != dirs.size() - 1) {
                    node.children.putIfAbsent(dir, new TreeNode());
                    node = (TreeNode)node.children.get(dir);
                    continue;
                }
                node.children.putIfAbsent(dir, new TreeNode(view));
            }
            Measure measure = view.getMeasure();
            measures.putIfAbsent(measure.getName(), measure);
        }
    }

    @GuardedBy(value="monitor")
    private void emitDirectoryTable(TreeNode currentNode, String path, PrintWriter out, Formatter formatter) {
        out.write("<h2>Views</h2>");
        if (currentNode == null) {
            formatter.format("<p><font size=+2>Directory not found: %s. Return to root.</font></p>", path);
            currentNode = this.root;
        }
        if (currentNode == this.root || path == null) {
            path = "";
        }
        StatszZPageHandler.emitDirectoryHeader(path, out, formatter);
        out.write("<table frame=box cellspacing=0 cellpadding=2>");
        for (Map.Entry<String, TreeNode> entry : currentNode.children.entrySet()) {
            TreeNode child = entry.getValue();
            String relativePath = entry.getKey();
            if (child.view == null) {
                formatter.format("<tr class=\"%s\"><td>Directory: <a href='?%s=%s'>%s</a> (%d %s)</td></tr>", CLASS_LARGER_TR, QUERY_PATH, path + '/' + relativePath, relativePath, child.views, child.views > 1 ? "views" : "view");
                continue;
            }
            String viewName = child.view.getName().asString();
            formatter.format("<tr class=\"%s\"><td>View: <a href='?%s=%s'>%s</a></td></tr>", CLASS_LARGER_TR, QUERY_PATH, path + '/' + relativePath, viewName);
        }
        out.write("</table>");
        out.write("<p></p>");
    }

    @GuardedBy(value="monitor")
    private TreeNode findNode(String path) {
        if (Strings.isNullOrEmpty((String)path) || "/".equals(path)) {
            return this.root;
        }
        List dirs = PATH_SPLITTER.splitToList((CharSequence)path);
        TreeNode node = this.root;
        for (int i = 0; i < dirs.size(); ++i) {
            String dir = (String)dirs.get(i);
            if ("".equals(dir) && i == 0) continue;
            if (!node.children.containsKey(dir)) {
                return null;
            }
            node = (TreeNode)node.children.get(dir);
        }
        return node;
    }

    private static void emitDirectoryHeader(String path, PrintWriter out, Formatter formatter) {
        List dirs = PATH_SPLITTER.splitToList((CharSequence)path);
        StringBuilder currentPath = new StringBuilder("");
        out.write("<h3>Current Path: ");
        for (int i = 0; i < dirs.size(); ++i) {
            String dir = (String)dirs.get(i);
            currentPath.append(dir);
            formatter.format("<a href='?%s=%s'>%s</a>", QUERY_PATH, currentPath.toString(), dir + '/');
            currentPath.append('/');
        }
        out.write("</h2>");
    }

    private static void emitViewData(ViewData viewData, View.Name viewName, PrintWriter out, Formatter formatter) {
        if (viewData == null) {
            formatter.format("<p class=\"%s\">No Stats found for View %s.</p>", CLASS_LARGER_TR, viewName.asString());
            return;
        }
        View view = viewData.getView();
        StatszZPageHandler.emitViewInfo(view, viewData.getWindowData(), out, formatter);
        formatter.format("<p class=\"%s\">Stats for View %s</p>", CLASS_LARGER_TR, view.getName().asString());
        out.write("<p></p>");
        formatter.format("<table %s frame=box cellspacing=0 cellpadding=2>", TABLE_BORDER);
        StatszZPageHandler.emitViewDataTableHeader(view, out, formatter);
        for (Map.Entry<List<TagValue>, AggregationData> entry : viewData.getAggregationMap().entrySet()) {
            StatszZPageHandler.emitViewDataRow(view, entry, out, formatter);
        }
        out.write("</table>");
        out.write("<p></p>");
    }

    private static void emitViewInfo(View view, ViewData.AggregationWindowData windowData, PrintWriter out, final Formatter formatter) {
        formatter.format("<table width=100%% %s>", TABLE_BORDER);
        StatszZPageHandler.emitViewInfoHeader(out, formatter);
        out.write("<tbody>");
        out.write("<tr>");
        formatter.format("<td>%s</td>", view.getName().asString());
        formatter.format("<td>%s</td>", view.getDescription());
        formatter.format("<td>%s</td>", view.getMeasure().getName());
        String aggregationType = (String)view.getAggregation().match(Functions.returnConstant((Object)TABLE_HEADER_SUM), Functions.returnConstant((Object)TABLE_HEADER_COUNT), Functions.returnConstant((Object)TABLE_HEADER_MEAN), Functions.returnConstant((Object)"Distribution"), Functions.throwAssertionError());
        formatter.format("<td>%s</td>", aggregationType);
        windowData.match((Function)new Function<ViewData.AggregationWindowData.CumulativeData, Void>(){

            public Void apply(ViewData.AggregationWindowData.CumulativeData arg) {
                formatter.format("<td>%s</td>", StatszZPageHandler.toDate(arg.getStart()));
                formatter.format("<td>%s</td>", StatszZPageHandler.toDate(arg.getEnd()));
                return null;
            }
        }, Functions.throwAssertionError(), Functions.throwAssertionError());
        out.write("</tr>");
        out.write("</tbody>");
        out.write("</table>");
        out.write("<p></p>");
    }

    private static Date toDate(Timestamp timestamp) {
        return Date.from(Instant.ofEpochMilli(timestamp.getSeconds() * 1000L + (long)timestamp.getNanos() / 1000000L));
    }

    private static void emitViewInfoHeader(PrintWriter out, Formatter formatter) {
        out.write("<thead>");
        out.write("<tr>");
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_VIEW);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_DESCRIPTION);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_MEASURE);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_AGGREGATION);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_START);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_END);
        out.write("</tr>");
        out.write("</thead>");
    }

    private static void emitViewDataTableHeader(View view, PrintWriter out, final Formatter formatter) {
        out.write("<thead>");
        out.write("<tr>");
        for (TagKey tagKey : view.getColumns()) {
            formatter.format("<th class=\"l1\">TagKey: %s (string)</th>", tagKey.getName());
        }
        final String unit = view.getMeasure().getUnit();
        view.getAggregation().match((Function)new Function<Aggregation.Sum, Void>(){

            public Void apply(Aggregation.Sum arg) {
                formatter.format("<th class=\"l1\">%s, %s</th>", StatszZPageHandler.TABLE_HEADER_SUM, unit);
                return null;
            }
        }, (Function)new Function<Aggregation.Count, Void>(){

            public Void apply(Aggregation.Count arg) {
                formatter.format("<th class=\"l1\">%s</th>", StatszZPageHandler.TABLE_HEADER_COUNT);
                return null;
            }
        }, (Function)new Function<Aggregation.Mean, Void>(){

            public Void apply(Aggregation.Mean arg) {
                formatter.format("<th class=\"l1\">%s, %s</th>", StatszZPageHandler.TABLE_HEADER_MEAN, unit);
                formatter.format("<th class=\"l1\">%s</th>", StatszZPageHandler.TABLE_HEADER_COUNT);
                return null;
            }
        }, (Function)new Function<Aggregation.Distribution, Void>(){

            public Void apply(Aggregation.Distribution arg) {
                formatter.format("<th class=\"l1\">%s, %s</th>", StatszZPageHandler.TABLE_HEADER_MEAN, unit);
                formatter.format("<th class=\"l1\">%s</th>", StatszZPageHandler.TABLE_HEADER_COUNT);
                formatter.format("<th class=\"l1\">%s, %s</th>", StatszZPageHandler.TABLE_HEADER_MAX, unit);
                formatter.format("<th class=\"l1\">%s, %s</th>", StatszZPageHandler.TABLE_HEADER_MIN, unit);
                formatter.format("<th class=\"l1\">%s</th>", StatszZPageHandler.TABLE_HEADER_DEV);
                formatter.format("<th class=\"l1\">%s</th>", StatszZPageHandler.TABLE_HEADER_HISTOGRAM);
                return null;
            }
        }, Functions.throwAssertionError());
        out.write("</tr>");
        out.write("</thead>");
    }

    private static void emitViewDataRow(final View view, Map.Entry<List<TagValue>, AggregationData> entry, final PrintWriter out, final Formatter formatter) {
        out.write("<tr>");
        for (TagValue tagValue : entry.getKey()) {
            String tagValueStr = tagValue == null ? "" : tagValue.asString();
            formatter.format("<td %s>%s</td>", ALIGN_CENTER, tagValueStr);
        }
        entry.getValue().match((Function)new Function<AggregationData.SumDataDouble, Void>(){

            public Void apply(AggregationData.SumDataDouble arg) {
                formatter.format("<td %s>%.3f</td>", StatszZPageHandler.ALIGN_CENTER, arg.getSum());
                return null;
            }
        }, (Function)new Function<AggregationData.SumDataLong, Void>(){

            public Void apply(AggregationData.SumDataLong arg) {
                formatter.format("<td %s>%d</td>", StatszZPageHandler.ALIGN_CENTER, arg.getSum());
                return null;
            }
        }, (Function)new Function<AggregationData.CountData, Void>(){

            public Void apply(AggregationData.CountData arg) {
                formatter.format("<td %s>%d</td>", StatszZPageHandler.ALIGN_CENTER, arg.getCount());
                return null;
            }
        }, (Function)new Function<AggregationData.MeanData, Void>(){

            public Void apply(AggregationData.MeanData arg) {
                formatter.format("<td %s>%.3f</td>", StatszZPageHandler.ALIGN_CENTER, arg.getMean());
                formatter.format("<td %s>%d</td>", StatszZPageHandler.ALIGN_CENTER, arg.getCount());
                return null;
            }
        }, (Function)new Function<AggregationData.DistributionData, Void>(){

            public Void apply(AggregationData.DistributionData arg) {
                Preconditions.checkArgument((boolean)(view.getAggregation() instanceof Aggregation.Distribution), (Object)"Distribution expected.");
                formatter.format("<td %s>%.3f</td>", StatszZPageHandler.ALIGN_CENTER, arg.getMean());
                formatter.format("<td %s>%d</td>", StatszZPageHandler.ALIGN_CENTER, arg.getCount());
                formatter.format("<td %s>%.3f</td>", StatszZPageHandler.ALIGN_CENTER, arg.getMax());
                formatter.format("<td %s>%.3f</td>", StatszZPageHandler.ALIGN_CENTER, arg.getMin());
                formatter.format("<td %s>%.3f</td>", StatszZPageHandler.ALIGN_CENTER, arg.getSumOfSquaredDeviations());
                StatszZPageHandler.emitHistogramBuckets(((Aggregation.Distribution)view.getAggregation()).getBucketBoundaries().getBoundaries(), arg.getBucketCounts(), out, formatter);
                return null;
            }
        }, Functions.throwAssertionError());
        out.write("</tr>");
    }

    private static void emitHistogramBuckets(List<Double> bucketBoundaries, List<Long> bucketCounts, PrintWriter out, Formatter formatter) {
        Preconditions.checkArgument((bucketBoundaries.size() == bucketCounts.size() - 1 ? 1 : 0) != 0, (Object)"Bucket boundaries and counts don't match");
        out.write("<td>");
        out.write("<table>");
        formatter.format("<thead><tr><th>%s</th><th>%s</th></tr></thead>", TABLE_HEADER_RANGE, TABLE_HEADER_BUCKET_SIZE);
        out.write("<tbody>");
        for (int i = 0; i < bucketCounts.size(); ++i) {
            double low = i == 0 ? Double.NEGATIVE_INFINITY : bucketBoundaries.get(i - 1);
            double high = i == bucketCounts.size() - 1 ? Double.POSITIVE_INFINITY : bucketBoundaries.get(i);
            out.write("<tr>");
            formatter.format("<td>[%.3f...%.3f)</td>", low, high);
            formatter.format("<td>%d</td>", bucketCounts.get(i));
            out.write("</tr>");
        }
        out.write("</tbody>");
        out.write("</table>");
        out.write("</td>");
    }

    private static void emitMeasureTable(Map<String, Measure> measures, PrintWriter out, Formatter formatter) {
        out.write("<h2>Measures with Views</h2>");
        out.write("<p>Below are the measures used in registered views.</p>");
        out.write("<p></p>");
        formatter.format("<table %s frame=box cellspacing=0 cellpadding=2>", TABLE_BORDER);
        StatszZPageHandler.emitMeasureTableHeader(out, formatter);
        out.write("<tbody>");
        for (Map.Entry<String, Measure> entry : measures.entrySet()) {
            StatszZPageHandler.emitMeasureTableRow(entry.getValue(), out, formatter);
        }
        out.write("</tbody>");
        out.write("</table>");
        out.write("<p></p>");
    }

    private static void emitMeasureTableHeader(PrintWriter out, Formatter formatter) {
        out.write("<thead>");
        out.write("<tr>");
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_MEASURE);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_DESCRIPTION);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_UNIT);
        formatter.format("<th colspan=1 class=\"l1\">%s</th>", TABLE_HEADER_MEASURE_TYPE);
        out.write("</tr>");
        out.write("</thead>");
    }

    private static void emitMeasureTableRow(Measure measure, PrintWriter out, Formatter formatter) {
        out.write("<tr>");
        formatter.format("<td><b>%s</b></td>", measure.getName());
        formatter.format("<td align=\"left\">%s&nbsp;</td>", measure.getDescription());
        formatter.format("<td align=\"left\">%s&nbsp;</td>", measure.getUnit());
        String measureType = (String)measure.match(Functions.returnConstant((Object)"Double"), Functions.returnConstant((Object)"Long"), Functions.throwAssertionError());
        formatter.format("<td align=\"left\">%s&nbsp;</td>", measureType);
        out.write("</tr>");
    }

    static StatszZPageHandler create(ViewManager viewManager) {
        return new StatszZPageHandler(viewManager);
    }

    private StatszZPageHandler(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    private static class TreeNode {
        @Nullable
        final View view;
        SortedMap<String, TreeNode> children = Maps.newTreeMap();
        int views = 0;

        TreeNode() {
            this.view = null;
        }

        TreeNode(View view) {
            this.view = (View)Preconditions.checkNotNull((Object)view, (Object)"view");
        }
    }
}

