/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.logcorrelation.log4j2;

import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.unsafe.ContextUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

final class ContextDataUtils {
    private ContextDataUtils() {
    }

    static StringMap injectContextData(@Nullable List<Property> properties, StringMap reusable) {
        if (properties == null || properties.isEmpty()) {
            return ContextDataUtils.getContextAndTracingData();
        }
        ContextDataUtils.putProperties(properties, reusable);
        reusable.putAll((ReadOnlyStringMap)ContextDataUtils.getContextAndTracingData());
        return reusable;
    }

    private static void putProperties(Collection<Property> properties, StringMap stringMap) {
        for (Property property : properties) {
            stringMap.putValue(property.getName(), (Object)property.getValue());
        }
    }

    static StringMap getContextAndTracingData() {
        SortedArrayStringMap stringMap;
        SpanContext spanContext = ContextDataUtils.getCurrentSpanContext();
        ReadOnlyThreadContextMap context = ThreadContext.getThreadContextMap();
        if (context == null) {
            stringMap = new SortedArrayStringMap(ThreadContext.getImmutableContext());
        } else {
            StringMap contextData = context.getReadOnlyContextData();
            stringMap = new SortedArrayStringMap(contextData.size() + 3);
            stringMap.putAll((ReadOnlyStringMap)contextData);
        }
        stringMap.putValue("traceId", (Object)spanContext.getTraceId().toLowerBase16());
        stringMap.putValue("spanId", (Object)spanContext.getSpanId().toLowerBase16());
        stringMap.putValue("traceSampled", (Object)(spanContext.getTraceOptions().isSampled() ? "true" : "false"));
        return stringMap;
    }

    private static SpanContext getCurrentSpanContext() {
        Span span = (Span)ContextUtils.CONTEXT_SPAN_KEY.get();
        return span == null ? SpanContext.INVALID : span.getContext();
    }
}

