/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode;

import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.Implementation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ByteCodeAppender {
    public Size apply(MethodVisitor var1, Implementation.Context var2, MethodDescription var3);

    public static class Simple
    implements ByteCodeAppender {
        private final StackManipulation stackManipulation;

        public Simple(StackManipulation ... stackManipulation) {
            this(Arrays.asList(stackManipulation));
        }

        public Simple(List<? extends StackManipulation> stackManipulations) {
            this.stackManipulation = new StackManipulation.Compound(stackManipulations);
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return new Size(this.stackManipulation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StackManipulation this$stackManipulation = this.stackManipulation;
            StackManipulation other$stackManipulation = other.stackManipulation;
            return !(this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Simple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StackManipulation $stackManipulation = this.stackManipulation;
            result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
            return result;
        }
    }

    public static class Compound
    implements ByteCodeAppender {
        private final List<ByteCodeAppender> byteCodeAppenders = new ArrayList<ByteCodeAppender>();

        public Compound(ByteCodeAppender ... byteCodeAppender) {
            this(Arrays.asList(byteCodeAppender));
        }

        public Compound(List<? extends ByteCodeAppender> byteCodeAppenders) {
            for (ByteCodeAppender byteCodeAppender : byteCodeAppenders) {
                if (byteCodeAppender instanceof Compound) {
                    this.byteCodeAppenders.addAll(((Compound)byteCodeAppender).byteCodeAppenders);
                    continue;
                }
                this.byteCodeAppenders.add(byteCodeAppender);
            }
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Size size = new Size(0, instrumentedMethod.getStackSize());
            for (ByteCodeAppender byteCodeAppender : this.byteCodeAppenders) {
                size = size.merge(byteCodeAppender.apply(methodVisitor, implementationContext, instrumentedMethod));
            }
            return size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Compound)) {
                return false;
            }
            Compound other = (Compound)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ByteCodeAppender> this$byteCodeAppenders = this.byteCodeAppenders;
            List<ByteCodeAppender> other$byteCodeAppenders = other.byteCodeAppenders;
            return !(this$byteCodeAppenders == null ? other$byteCodeAppenders != null : !((Object)this$byteCodeAppenders).equals(other$byteCodeAppenders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Compound;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ByteCodeAppender> $byteCodeAppenders = this.byteCodeAppenders;
            result = result * 59 + ($byteCodeAppenders == null ? 43 : ((Object)$byteCodeAppenders).hashCode());
            return result;
        }
    }

    public static class Size {
        private final int operandStackSize;
        private final int localVariableSize;

        public Size(int operandStackSize, int localVariableSize) {
            this.operandStackSize = operandStackSize;
            this.localVariableSize = localVariableSize;
        }

        public int getOperandStackSize() {
            return this.operandStackSize;
        }

        public int getLocalVariableSize() {
            return this.localVariableSize;
        }

        public Size merge(Size other) {
            return new Size(Math.max(this.operandStackSize, other.operandStackSize), Math.max(this.localVariableSize, other.localVariableSize));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Size)) {
                return false;
            }
            Size other = (Size)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOperandStackSize() != other.getOperandStackSize()) {
                return false;
            }
            return this.getLocalVariableSize() == other.getLocalVariableSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Size;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOperandStackSize();
            result = result * 59 + this.getLocalVariableSize();
            return result;
        }
    }
}

