/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.build;

import io.opencensus.contrib.agent.deps.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.opencensus.contrib.agent.deps.bytebuddy.build.Plugin;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodList;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.ClassFileLocator;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.DynamicType;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.ToStringMethod;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatchers;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@HashCodeAndEqualsPlugin.Enhance
public class ToStringPlugin
implements Plugin {
    @Override
    public boolean matches(TypeDescription target) {
        return target.getDeclaredAnnotations().isAnnotationPresent(Enhance.class);
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        Enhance enhance = typeDescription.getDeclaredAnnotations().ofType(Enhance.class).loadSilent();
        if (((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isToString())).isEmpty()) {
            builder = builder.method(ElementMatchers.isToString()).intercept(ToStringMethod.prefixedBy(enhance.prefix().getPrefixResolver()).withIgnoredFields(enhance.includeSyntheticFields() ? ElementMatchers.none() : ElementMatchers.isSynthetic()).withIgnoredFields(ElementMatchers.isAnnotatedWith(Exclude.class)));
        }
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    public int hashCode() {
        return 17;
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Exclude {
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public Prefix prefix() default Prefix.SIMPLE;

        public boolean includeSyntheticFields() default false;

        public static enum Prefix {
            FULLY_QUALIFIED(ToStringMethod.PrefixResolver.Default.FULLY_QUALIFIED_CLASS_NAME),
            CANONICAL(ToStringMethod.PrefixResolver.Default.CANONICAL_CLASS_NAME),
            SIMPLE(ToStringMethod.PrefixResolver.Default.SIMPLE_CLASS_NAME);

            private final ToStringMethod.PrefixResolver.Default prefixResolver;

            private Prefix(ToStringMethod.PrefixResolver.Default prefixResolver) {
                this.prefixResolver = prefixResolver;
            }

            protected ToStringMethod.PrefixResolver.Default getPrefixResolver() {
                return this.prefixResolver;
            }
        }
    }
}

