/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.graph;

import com.google.errorprone.annotations.DoNotMock;
import io.opencensus.contrib.agent.deps.guava.annotations.Beta;
import io.opencensus.contrib.agent.deps.guava.graph.ElementOrder;
import io.opencensus.contrib.agent.deps.guava.graph.EndpointPair;
import io.opencensus.contrib.agent.deps.guava.graph.Graph;
import io.opencensus.contrib.agent.deps.guava.graph.PredecessorsFunction;
import io.opencensus.contrib.agent.deps.guava.graph.SuccessorsFunction;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@DoNotMock(value="Use NetworkBuilder to create a real instance")
@Beta
public interface Network<N, E>
extends SuccessorsFunction<N>,
PredecessorsFunction<N> {
    public Set<N> nodes();

    public Set<E> edges();

    public Graph<N> asGraph();

    public boolean isDirected();

    public boolean allowsParallelEdges();

    public boolean allowsSelfLoops();

    public ElementOrder<N> nodeOrder();

    public ElementOrder<E> edgeOrder();

    public Set<N> adjacentNodes(N var1);

    @Override
    public Set<N> predecessors(N var1);

    @Override
    public Set<N> successors(N var1);

    public Set<E> incidentEdges(N var1);

    public Set<E> inEdges(N var1);

    public Set<E> outEdges(N var1);

    public int degree(N var1);

    public int inDegree(N var1);

    public int outDegree(N var1);

    public EndpointPair<N> incidentNodes(E var1);

    public Set<E> adjacentEdges(E var1);

    public Set<E> edgesConnecting(N var1, N var2);

    public Set<E> edgesConnecting(EndpointPair<N> var1);

    @NullableDecl
    public E edgeConnectingOrNull(N var1, N var2);

    @NullableDecl
    public E edgeConnectingOrNull(EndpointPair<N> var1);

    public boolean hasEdgeConnecting(N var1, N var2);

    public boolean hasEdgeConnecting(EndpointPair<N> var1);

    public boolean equals(@NullableDecl Object var1);

    public int hashCode();
}

