/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.build;

import io.opencensus.contrib.agent.deps.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.ClassFileLocator;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.DynamicType;
import io.opencensus.contrib.agent.deps.bytebuddy.matcher.ElementMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface Plugin
extends ElementMatcher<TypeDescription> {
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> var1, TypeDescription var2, ClassFileLocator var3);

    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements Plugin {
        private final List<Plugin> plugins = new ArrayList<Plugin>();

        public Compound(Plugin ... plugin) {
            this(Arrays.asList(plugin));
        }

        public Compound(List<? extends Plugin> plugins) {
            for (Plugin plugin : plugins) {
                if (plugin instanceof Compound) {
                    this.plugins.addAll(((Compound)plugin).plugins);
                    continue;
                }
                if (plugin instanceof NoOp) continue;
                this.plugins.add(plugin);
            }
        }

        @Override
        public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
            for (Plugin plugin : this.plugins) {
                if (!plugin.matches(typeDescription)) continue;
                builder = plugin.apply(builder, typeDescription, classFileLocator);
            }
            return builder;
        }

        @Override
        public boolean matches(TypeDescription target) {
            for (Plugin plugin : this.plugins) {
                if (!plugin.matches(target)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.plugins).equals(((Compound)object).plugins);
        }

        public int hashCode() {
            return 17 * 31 + ((Object)this.plugins).hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static abstract class ForElementMatcher
    implements Plugin {
        private final ElementMatcher<? super TypeDescription> matcher;

        protected ForElementMatcher(ElementMatcher<? super TypeDescription> matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(TypeDescription target) {
            return this.matcher.matches(target);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.matcher.equals(((ForElementMatcher)object).matcher);
        }

        public int hashCode() {
            return 17 * 31 + this.matcher.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class NoOp
    implements Plugin {
        @Override
        public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
            throw new IllegalStateException("Cannot apply non-operational plugin");
        }

        @Override
        public boolean matches(TypeDescription target) {
            return false;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            return 17;
        }
    }
}

