/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.guava.collect;

import io.opencensus.contrib.agent.deps.guava.annotations.GwtCompatible;
import io.opencensus.contrib.agent.deps.guava.annotations.VisibleForTesting;
import io.opencensus.contrib.agent.deps.guava.base.Preconditions;
import io.opencensus.contrib.agent.deps.guava.collect.CollectPreconditions;
import io.opencensus.contrib.agent.deps.guava.collect.Hashing;
import io.opencensus.contrib.agent.deps.guava.collect.ImmutableCollection;
import io.opencensus.contrib.agent.deps.guava.collect.ImmutableList;
import io.opencensus.contrib.agent.deps.guava.collect.ImmutableMap;
import io.opencensus.contrib.agent.deps.guava.collect.ImmutableSet;
import io.opencensus.contrib.agent.deps.guava.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private static final int ABSENT = -1;
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    private final transient int[] hashTable;
    @VisibleForTesting
    final transient Object[] alternatingKeysAndValues;
    private final transient int size;
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> create(int n, Object[] alternatingKeysAndValues) {
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(alternatingKeysAndValues[0], alternatingKeysAndValues[1]);
            return new RegularImmutableMap<K, V>(null, alternatingKeysAndValues, 1);
        }
        Preconditions.checkPositionIndex(n, alternatingKeysAndValues.length >> 1);
        int tableSize = ImmutableSet.chooseTableSize(n);
        int[] hashTable = RegularImmutableMap.createHashTable(alternatingKeysAndValues, n, tableSize, 0);
        return new RegularImmutableMap<K, V>(hashTable, alternatingKeysAndValues, n);
    }

    static int[] createHashTable(Object[] alternatingKeysAndValues, int n, int tableSize, int keyOffset) {
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(alternatingKeysAndValues[keyOffset], alternatingKeysAndValues[keyOffset ^ 1]);
            return null;
        }
        int mask = tableSize - 1;
        int[] hashTable = new int[tableSize];
        Arrays.fill(hashTable, -1);
        for (int i = 0; i < n; ++i) {
            Object key = alternatingKeysAndValues[2 * i + keyOffset];
            Object value = alternatingKeysAndValues[2 * i + (keyOffset ^ 1)];
            CollectPreconditions.checkEntryNotNull(key, value);
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int previous;
                if ((previous = hashTable[h &= mask]) == -1) break;
                if (alternatingKeysAndValues[previous].equals(key)) {
                    throw new IllegalArgumentException("Multiple entries with same key: " + key + "=" + value + " and " + alternatingKeysAndValues[previous] + "=" + alternatingKeysAndValues[previous ^ 1]);
                }
                ++h;
            }
            hashTable[h] = 2 * i + keyOffset;
        }
        return hashTable;
    }

    private RegularImmutableMap(int[] hashTable, Object[] alternatingKeysAndValues, int size) {
        this.hashTable = hashTable;
        this.alternatingKeysAndValues = alternatingKeysAndValues;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NullableDecl
    public V get(@NullableDecl Object key) {
        return (V)RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, key);
    }

    static Object get(@NullableDecl int[] hashTable, @NullableDecl Object[] alternatingKeysAndValues, int size, int keyOffset, @NullableDecl Object key) {
        if (key == null) {
            return null;
        }
        if (size == 1) {
            return alternatingKeysAndValues[keyOffset].equals(key) ? alternatingKeysAndValues[keyOffset ^ 1] : null;
        }
        if (hashTable == null) {
            return null;
        }
        int mask = hashTable.length - 1;
        int h = Hashing.smear(key.hashCode());
        int index;
        while ((index = hashTable[h &= mask]) != -1) {
            if (alternatingKeysAndValues[index].equals(key)) {
                return alternatingKeysAndValues[index ^ 1];
            }
            ++h;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keyList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        return new KeySet<Object>(this, keyList);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> map, ImmutableList<K> list) {
            this.map = map;
            this.list = list;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return this.map.get(object) != null;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(Object[] alternatingKeysAndValues, int offset, int size) {
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public Object get(int index) {
            Preconditions.checkElementIndex(index, this.size);
            return this.alternatingKeysAndValues[2 * index + this.offset];
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> map, Object[] alternatingKeysAndValues, int keyOffset, int size) {
            this.map = map;
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.keyOffset = keyOffset;
            this.size = size;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int index) {
                    Preconditions.checkElementIndex(index, EntrySet.this.size);
                    Object key = EntrySet.this.alternatingKeysAndValues[2 * index + EntrySet.this.keyOffset];
                    Object value = EntrySet.this.alternatingKeysAndValues[2 * index + (EntrySet.this.keyOffset ^ 1)];
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
                }

                @Override
                public int size() {
                    return EntrySet.this.size;
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return v != null && v.equals(this.map.get(k));
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

