/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.config.impl;

import io.opencensus.contrib.agent.deps.config.ConfigValueType;
import io.opencensus.contrib.agent.deps.config.impl.AbstractConfigObject;
import io.opencensus.contrib.agent.deps.config.impl.AbstractConfigValue;
import io.opencensus.contrib.agent.deps.config.impl.ConfigBoolean;
import io.opencensus.contrib.agent.deps.config.impl.ConfigDouble;
import io.opencensus.contrib.agent.deps.config.impl.ConfigLong;
import io.opencensus.contrib.agent.deps.config.impl.ConfigNull;
import io.opencensus.contrib.agent.deps.config.impl.ConfigString;
import io.opencensus.contrib.agent.deps.config.impl.SimpleConfigList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

final class DefaultTransformer {
    DefaultTransformer() {
    }

    static AbstractConfigValue transform(AbstractConfigValue value, ConfigValueType requested) {
        if (value.valueType() == ConfigValueType.STRING) {
            String s = (String)value.unwrapped();
            switch (requested) {
                case NUMBER: {
                    try {
                        Long v = Long.parseLong(s);
                        return new ConfigLong(value.origin(), v, s);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double v = Double.parseDouble(s);
                            return new ConfigDouble(value.origin(), v, s);
                        }
                        catch (NumberFormatException e2) {
                            break;
                        }
                    }
                }
                case NULL: {
                    if (!s.equals("null")) break;
                    return new ConfigNull(value.origin());
                }
                case BOOLEAN: {
                    if (s.equals("true") || s.equals("yes") || s.equals("on")) {
                        return new ConfigBoolean(value.origin(), true);
                    }
                    if (!s.equals("false") && !s.equals("no") && !s.equals("off")) break;
                    return new ConfigBoolean(value.origin(), false);
                }
                case LIST: {
                    break;
                }
                case OBJECT: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.STRING) {
            switch (value.valueType()) {
                case NUMBER: 
                case BOOLEAN: {
                    return new ConfigString(value.origin(), value.transformToString());
                }
                case NULL: {
                    break;
                }
                case OBJECT: {
                    break;
                }
                case LIST: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.LIST && value.valueType() == ConfigValueType.OBJECT) {
            AbstractConfigObject o = (AbstractConfigObject)value;
            HashMap<Integer, AbstractConfigValue> values = new HashMap<Integer, AbstractConfigValue>();
            for (String key : o.keySet()) {
                try {
                    int i = Integer.parseInt(key, 10);
                    if (i < 0) continue;
                    values.put(i, o.get(key));
                }
                catch (NumberFormatException e) {}
            }
            if (!values.isEmpty()) {
                ArrayList entryList = new ArrayList(values.entrySet());
                Collections.sort(entryList, new Comparator<Map.Entry<Integer, AbstractConfigValue>>(){

                    @Override
                    public int compare(Map.Entry<Integer, AbstractConfigValue> a, Map.Entry<Integer, AbstractConfigValue> b) {
                        return Integer.valueOf(a.getKey()).compareTo(b.getKey());
                    }
                });
                ArrayList<AbstractConfigValue> list = new ArrayList<AbstractConfigValue>();
                for (Map.Entry entry : entryList) {
                    list.add((AbstractConfigValue)entry.getValue());
                }
                return new SimpleConfigList(value.origin(), list);
            }
        }
        return value;
    }
}

