/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opencensus.contrib.agent.deps.bytebuddy.description.field.FieldDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.method.MethodDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeList;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.StackManipulation;
import io.opencensus.contrib.agent.deps.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.Handle;
import io.opencensus.contrib.agent.deps.bytebuddy.jar.asm.Type;
import io.opencensus.contrib.agent.deps.bytebuddy.utility.JavaType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface JavaConstant {
    public Object asConstantPoolValue();

    public StackManipulation asStackManipulation();

    public TypeDescription getType();

    public static class MethodHandle
    implements JavaConstant {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final HandleType handleType;
        private final TypeDescription ownerType;
        private final String name;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodHandle(HandleType handleType, TypeDescription ownerType, String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.handleType = handleType;
            this.ownerType = ownerType;
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodHandle ofLoaded(Object methodHandle) {
            return MethodHandle.ofLoaded(methodHandle, DISPATCHER.publicLookup());
        }

        public static MethodHandle ofLoaded(Object methodHandle, Object lookup) {
            if (!JavaType.METHOD_HANDLE.getTypeStub().isInstance(methodHandle)) {
                throw new IllegalArgumentException("Expected method handle object: " + methodHandle);
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isInstance(lookup)) {
                throw new IllegalArgumentException("Expected method handle lookup object: " + lookup);
            }
            Dispatcher dispatcher = DISPATCHER.initialize();
            Object methodHandleInfo = dispatcher.reveal(lookup, methodHandle);
            Object methodType = dispatcher.getMethodType(methodHandleInfo);
            return new MethodHandle(HandleType.of(dispatcher.getReferenceKind(methodHandleInfo)), new TypeDescription.ForLoadedType(dispatcher.getDeclaringClass(methodHandleInfo)), dispatcher.getName(methodHandleInfo), new TypeDescription.ForLoadedType(dispatcher.returnType(methodType)), new TypeList.ForLoadedTypes(dispatcher.parameterArray(methodType)));
        }

        public static MethodHandle of(Method method) {
            return MethodHandle.of(new MethodDescription.ForLoadedMethod(method));
        }

        public static MethodHandle of(Constructor<?> constructor) {
            return MethodHandle.of(new MethodDescription.ForLoadedConstructor(constructor));
        }

        public static MethodHandle of(MethodDescription.InDefinedShape methodDescription) {
            return new MethodHandle(HandleType.of(methodDescription), methodDescription.getDeclaringType().asErasure(), methodDescription.getInternalName(), methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodHandle ofSpecial(Method method, Class<?> type) {
            return MethodHandle.ofSpecial(new MethodDescription.ForLoadedMethod(method), new TypeDescription.ForLoadedType(type));
        }

        public static MethodHandle ofSpecial(MethodDescription.InDefinedShape methodDescription, TypeDescription typeDescription) {
            if (!methodDescription.isSpecializableFor(typeDescription)) {
                throw new IllegalArgumentException("Cannot specialize " + methodDescription + " for " + typeDescription);
            }
            return new MethodHandle(HandleType.ofSpecial(methodDescription), typeDescription, methodDescription.getInternalName(), methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodHandle ofGetter(Field field) {
            return MethodHandle.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofGetter(FieldDescription.InDefinedShape fieldDescription) {
            return new MethodHandle(HandleType.ofGetter(fieldDescription), fieldDescription.getDeclaringType().asErasure(), fieldDescription.getInternalName(), fieldDescription.getType().asErasure(), Collections.emptyList());
        }

        public static MethodHandle ofSetter(Field field) {
            return MethodHandle.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofSetter(FieldDescription.InDefinedShape fieldDescription) {
            return new MethodHandle(HandleType.ofSetter(fieldDescription), fieldDescription.getDeclaringType().asErasure(), fieldDescription.getInternalName(), TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asErasure()));
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            String descriptor = stringBuilder.append(")").append(this.getReturnType().getDescriptor()).toString();
            return new Handle(this.getHandleType().getIdentifier(), this.getOwnerType().getInternalName(), this.getName(), descriptor, this.getOwnerType().isInterface());
        }

        @Override
        public StackManipulation asStackManipulation() {
            return new JavaConstantValue(this);
        }

        @Override
        public TypeDescription getType() {
            return JavaType.METHOD_HANDLE.getTypeStub();
        }

        public HandleType getHandleType() {
            return this.handleType;
        }

        public TypeDescription getOwnerType() {
            return this.ownerType;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public TypeList getParameterTypes() {
            return new TypeList.Explicit(this.parameterTypes);
        }

        public String getDescriptor() {
            StringBuilder stringBuilder = new StringBuilder().append('(');
            for (TypeDescription typeDescription : this.parameterTypes) {
                stringBuilder.append(typeDescription.getDescriptor());
            }
            return stringBuilder.append(')').append(this.returnType.getDescriptor()).toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodHandle)) {
                return false;
            }
            MethodHandle aDefault = (MethodHandle)other;
            return this.handleType == aDefault.handleType && this.name.equals(aDefault.name) && this.ownerType.equals(aDefault.ownerType) && this.parameterTypes.equals(aDefault.parameterTypes) && this.returnType.equals(aDefault.returnType);
        }

        public int hashCode() {
            int result = this.handleType.hashCode();
            result = 31 * result + this.ownerType.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public static Class<?> lookupType(Object callerClassLookup) {
            return DISPATCHER.lookupType(callerClassLookup);
        }

        public static enum HandleType {
            INVOKE_VIRTUAL(5),
            INVOKE_STATIC(6),
            INVOKE_SPECIAL(7),
            INVOKE_INTERFACE(9),
            INVOKE_SPECIAL_CONSTRUCTOR(8),
            PUT_FIELD(3),
            GET_FIELD(1),
            PUT_STATIC_FIELD(4),
            GET_STATIC_FIELD(2);

            private final int identifier;

            private HandleType(int identifier) {
                this.identifier = identifier;
            }

            protected static HandleType of(MethodDescription.InDefinedShape methodDescription) {
                if (methodDescription.isStatic()) {
                    return INVOKE_STATIC;
                }
                if (methodDescription.isPrivate()) {
                    return INVOKE_SPECIAL;
                }
                if (methodDescription.isConstructor()) {
                    return INVOKE_SPECIAL_CONSTRUCTOR;
                }
                if (methodDescription.getDeclaringType().isInterface()) {
                    return INVOKE_INTERFACE;
                }
                return INVOKE_VIRTUAL;
            }

            protected static HandleType of(int identifier) {
                for (HandleType handleType : HandleType.values()) {
                    if (handleType.getIdentifier() != identifier) continue;
                    return handleType;
                }
                throw new IllegalArgumentException("Unknown handle type: " + identifier);
            }

            protected static HandleType ofSpecial(MethodDescription.InDefinedShape methodDescription) {
                if (methodDescription.isStatic() || methodDescription.isAbstract()) {
                    throw new IllegalArgumentException("Cannot invoke " + methodDescription + " via invokespecial");
                }
                return methodDescription.isConstructor() ? INVOKE_SPECIAL_CONSTRUCTOR : INVOKE_SPECIAL;
            }

            protected static HandleType ofGetter(FieldDescription.InDefinedShape fieldDescription) {
                return fieldDescription.isStatic() ? GET_STATIC_FIELD : GET_FIELD;
            }

            protected static HandleType ofSetter(FieldDescription.InDefinedShape fieldDescription) {
                return fieldDescription.isStatic() ? PUT_STATIC_FIELD : PUT_FIELD;
            }

            public int getIdentifier() {
                return this.identifier;
            }
        }

        protected static interface Dispatcher {
            public Object reveal(Object var1, Object var2);

            public Object getMethodType(Object var1);

            public int getReferenceKind(Object var1);

            public Class<?> getDeclaringClass(Object var1);

            public String getName(Object var1);

            public Class<?> returnType(Object var1);

            public List<? extends Class<?>> parameterArray(Object var1);

            public static enum ForLegacyVm implements Initializable
            {
                INSTANCE;


                @Override
                public Dispatcher initialize() {
                    throw new IllegalStateException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }

                @Override
                public Object publicLookup() {
                    throw new IllegalStateException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    throw new IllegalStateException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }
            }

            public static class ForJava7CapableVm
            extends AbstractBase
            implements PrivilegedAction<Dispatcher> {
                private final Constructor<?> methodInfo;

                protected ForJava7CapableVm(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method lookupClass, Constructor<?> methodInfo) {
                    super(publicLookup, getName, getDeclaringClass, getReferenceKind, getMethodType, returnType, parameterArray, lookupClass);
                    this.methodInfo = methodInfo;
                }

                @Override
                public Dispatcher initialize() {
                    return AccessController.doPrivileged(this);
                }

                @Override
                public Dispatcher run() {
                    this.methodInfo.setAccessible(true);
                    this.getName.setAccessible(true);
                    this.getDeclaringClass.setAccessible(true);
                    this.getReferenceKind.setAccessible(true);
                    this.getMethodType.setAccessible(true);
                    return this;
                }

                @Override
                public Object reveal(Object lookup, Object methodHandle) {
                    try {
                        return this.methodInfo.newInstance(methodHandle);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodInfo()", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodInfo()", exception.getCause());
                    }
                    catch (InstantiationException exception) {
                        throw new IllegalStateException("Error constructing java.lang.invoke.MethodInfo", exception);
                    }
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForJava7CapableVm)) {
                        return false;
                    }
                    ForJava7CapableVm other = (ForJava7CapableVm)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    Constructor<?> this$methodInfo = this.methodInfo;
                    Constructor<?> other$methodInfo = other.methodInfo;
                    return !(this$methodInfo == null ? other$methodInfo != null : !((Object)this$methodInfo).equals(other$methodInfo));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof ForJava7CapableVm;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    Constructor<?> $methodInfo = this.methodInfo;
                    result = result * 59 + ($methodInfo == null ? 43 : ((Object)$methodInfo).hashCode());
                    return result;
                }
            }

            public static class ForJava8CapableVm
            extends AbstractBase {
                private final Method revealDirect;

                protected ForJava8CapableVm(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method lookupClass, Method revealDirect) {
                    super(publicLookup, getName, getDeclaringClass, getReferenceKind, getMethodType, returnType, parameterArray, lookupClass);
                    this.revealDirect = revealDirect;
                }

                @Override
                public Object reveal(Object lookup, Object methodHandle) {
                    try {
                        return this.revealDirect.invoke(lookup, methodHandle);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles.Lookup#revealDirect", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles.Lookup#revealDirect", exception.getCause());
                    }
                }

                @Override
                public Dispatcher initialize() {
                    return this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForJava8CapableVm)) {
                        return false;
                    }
                    ForJava8CapableVm other = (ForJava8CapableVm)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    Method this$revealDirect = this.revealDirect;
                    Method other$revealDirect = other.revealDirect;
                    return !(this$revealDirect == null ? other$revealDirect != null : !((Object)this$revealDirect).equals(other$revealDirect));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof ForJava8CapableVm;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    Method $revealDirect = this.revealDirect;
                    result = result * 59 + ($revealDirect == null ? 43 : ((Object)$revealDirect).hashCode());
                    return result;
                }
            }

            public static abstract class AbstractBase
            implements Dispatcher,
            Initializable {
                protected final Method publicLookup;
                protected final Method getName;
                protected final Method getDeclaringClass;
                protected final Method getReferenceKind;
                protected final Method getMethodType;
                protected final Method returnType;
                protected final Method parameterArray;
                protected final Method lookupClass;

                protected AbstractBase(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method lookupClass) {
                    this.publicLookup = publicLookup;
                    this.getName = getName;
                    this.getDeclaringClass = getDeclaringClass;
                    this.getReferenceKind = getReferenceKind;
                    this.getMethodType = getMethodType;
                    this.returnType = returnType;
                    this.parameterArray = parameterArray;
                    this.lookupClass = lookupClass;
                }

                @Override
                public Object publicLookup() {
                    try {
                        return this.publicLookup.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles#publicLookup", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles#publicLookup", exception.getCause());
                    }
                }

                @Override
                public Object getMethodType(Object methodHandleInfo) {
                    try {
                        return this.getMethodType.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getMethodType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getMethodType", exception.getCause());
                    }
                }

                @Override
                public int getReferenceKind(Object methodHandleInfo) {
                    try {
                        return (Integer)this.getReferenceKind.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getReferenceKind", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getReferenceKind", exception.getCause());
                    }
                }

                @Override
                public Class<?> getDeclaringClass(Object methodHandleInfo) {
                    try {
                        return (Class)this.getDeclaringClass.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getDeclaringClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getDeclaringClass", exception.getCause());
                    }
                }

                @Override
                public String getName(Object methodHandleInfo) {
                    try {
                        return (String)this.getName.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getName", exception.getCause());
                    }
                }

                @Override
                public Class<?> returnType(Object methodType) {
                    try {
                        return (Class)this.returnType.invoke(methodType, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#returnType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodType#returnType", exception.getCause());
                    }
                }

                @Override
                public List<? extends Class<?>> parameterArray(Object methodType) {
                    try {
                        return Arrays.asList((Class[])this.parameterArray.invoke(methodType, new Object[0]));
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.MethodType#parameterArray", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodType#parameterArray", exception.getCause());
                    }
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    try {
                        return (Class)this.lookupClass.invoke(lookup, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.MethodHandles.Lookup#lookupClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodHandles.Lookup#lookupClass", exception.getCause());
                    }
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AbstractBase)) {
                        return false;
                    }
                    AbstractBase other = (AbstractBase)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Method this$publicLookup = this.publicLookup;
                    Method other$publicLookup = other.publicLookup;
                    if (this$publicLookup == null ? other$publicLookup != null : !((Object)this$publicLookup).equals(other$publicLookup)) {
                        return false;
                    }
                    Method this$getName = this.getName;
                    Method other$getName = other.getName;
                    if (this$getName == null ? other$getName != null : !((Object)this$getName).equals(other$getName)) {
                        return false;
                    }
                    Method this$getDeclaringClass = this.getDeclaringClass;
                    Method other$getDeclaringClass = other.getDeclaringClass;
                    if (this$getDeclaringClass == null ? other$getDeclaringClass != null : !((Object)this$getDeclaringClass).equals(other$getDeclaringClass)) {
                        return false;
                    }
                    Method this$getReferenceKind = this.getReferenceKind;
                    Method other$getReferenceKind = other.getReferenceKind;
                    if (this$getReferenceKind == null ? other$getReferenceKind != null : !((Object)this$getReferenceKind).equals(other$getReferenceKind)) {
                        return false;
                    }
                    Method this$getMethodType = this.getMethodType;
                    Method other$getMethodType = other.getMethodType;
                    if (this$getMethodType == null ? other$getMethodType != null : !((Object)this$getMethodType).equals(other$getMethodType)) {
                        return false;
                    }
                    Method this$returnType = this.returnType;
                    Method other$returnType = other.returnType;
                    if (this$returnType == null ? other$returnType != null : !((Object)this$returnType).equals(other$returnType)) {
                        return false;
                    }
                    Method this$parameterArray = this.parameterArray;
                    Method other$parameterArray = other.parameterArray;
                    if (this$parameterArray == null ? other$parameterArray != null : !((Object)this$parameterArray).equals(other$parameterArray)) {
                        return false;
                    }
                    Method this$lookupClass = this.lookupClass;
                    Method other$lookupClass = other.lookupClass;
                    return !(this$lookupClass == null ? other$lookupClass != null : !((Object)this$lookupClass).equals(other$lookupClass));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof AbstractBase;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Method $publicLookup = this.publicLookup;
                    result = result * 59 + ($publicLookup == null ? 43 : ((Object)$publicLookup).hashCode());
                    Method $getName = this.getName;
                    result = result * 59 + ($getName == null ? 43 : ((Object)$getName).hashCode());
                    Method $getDeclaringClass = this.getDeclaringClass;
                    result = result * 59 + ($getDeclaringClass == null ? 43 : ((Object)$getDeclaringClass).hashCode());
                    Method $getReferenceKind = this.getReferenceKind;
                    result = result * 59 + ($getReferenceKind == null ? 43 : ((Object)$getReferenceKind).hashCode());
                    Method $getMethodType = this.getMethodType;
                    result = result * 59 + ($getMethodType == null ? 43 : ((Object)$getMethodType).hashCode());
                    Method $returnType = this.returnType;
                    result = result * 59 + ($returnType == null ? 43 : ((Object)$returnType).hashCode());
                    Method $parameterArray = this.parameterArray;
                    result = result * 59 + ($parameterArray == null ? 43 : ((Object)$parameterArray).hashCode());
                    Method $lookupClass = this.lookupClass;
                    result = result * 59 + ($lookupClass == null ? 43 : ((Object)$lookupClass).hashCode());
                    return result;
                }
            }

            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        return new ForJava8CapableVm(Class.forName("java.lang.invoke.MethodHandles").getMethod("publicLookup", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getName", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getDeclaringClass", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getReferenceKind", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getMethodType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("returnType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("parameterArray", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getMethod("lookupClass", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getMethod("revealDirect", JavaType.METHOD_HANDLE.load()));
                    }
                    catch (Exception ignored) {
                        try {
                            return new ForJava7CapableVm(Class.forName("java.lang.invoke.MethodHandles").getMethod("publicLookup", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getName", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getDeclaringClass", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getReferenceKind", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getMethodType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("returnType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("parameterArray", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getMethod("lookupClass", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getConstructor(JavaType.METHOD_HANDLE.load()));
                        }
                        catch (Exception ignored2) {
                            return ForLegacyVm.INSTANCE;
                        }
                    }
                }
            }

            public static interface Initializable {
                public Dispatcher initialize();

                public Object publicLookup();

                public Class<?> lookupType(Object var1);
            }
        }
    }

    public static class MethodType
    implements JavaConstant {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodType(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodType ofLoaded(Object methodType) {
            if (!JavaType.METHOD_TYPE.getTypeStub().isInstance(methodType)) {
                throw new IllegalArgumentException("Expected method type object: " + methodType);
            }
            return MethodType.of(DISPATCHER.returnType(methodType), DISPATCHER.parameterArray(methodType));
        }

        public static MethodType of(Class<?> returnType, Class<?> ... parameterType) {
            return MethodType.of(new TypeDescription.ForLoadedType(returnType), new TypeList.ForLoadedTypes(parameterType));
        }

        public static MethodType of(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            return new MethodType(returnType, parameterTypes);
        }

        public static MethodType of(Method method) {
            return MethodType.of(new MethodDescription.ForLoadedMethod(method));
        }

        public static MethodType of(Constructor<?> constructor) {
            return MethodType.of(new MethodDescription.ForLoadedConstructor(constructor));
        }

        public static MethodType of(MethodDescription methodDescription) {
            return new MethodType(methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodType ofSetter(Field field) {
            return MethodType.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodType ofSetter(FieldDescription fieldDescription) {
            return new MethodType(TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asErasure()));
        }

        public static MethodType ofGetter(Field field) {
            return MethodType.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodType ofGetter(FieldDescription fieldDescription) {
            return new MethodType(fieldDescription.getType().asErasure(), Collections.emptyList());
        }

        public static MethodType ofConstant(Object instance) {
            return MethodType.ofConstant(instance.getClass());
        }

        public static MethodType ofConstant(Class<?> type) {
            return MethodType.ofConstant(new TypeDescription.ForLoadedType(type));
        }

        public static MethodType ofConstant(TypeDescription typeDescription) {
            return new MethodType(typeDescription, Collections.emptyList());
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public TypeList getParameterTypes() {
            return new TypeList.Explicit(this.parameterTypes);
        }

        public String getDescriptor() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription typeDescription : this.parameterTypes) {
                stringBuilder.append(typeDescription.getDescriptor());
            }
            return stringBuilder.append(')').append(this.returnType.getDescriptor()).toString();
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            return Type.getMethodType(stringBuilder.append(")").append(this.getReturnType().getDescriptor()).toString());
        }

        @Override
        public StackManipulation asStackManipulation() {
            return new JavaConstantValue(this);
        }

        @Override
        public TypeDescription getType() {
            return JavaType.METHOD_TYPE.getTypeStub();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodType)) {
                return false;
            }
            MethodType that = (MethodType)other;
            return this.parameterTypes.equals(that.parameterTypes) && this.returnType.equals(that.returnType);
        }

        public int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        protected static interface Dispatcher {
            public Class<?> returnType(Object var1);

            public Class<?>[] parameterArray(Object var1);

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public Class<?> returnType(Object methodType) {
                    throw new IllegalStateException("Unsupported type for the current JVM: java.lang.invoke.MethodType");
                }

                @Override
                public Class<?>[] parameterArray(Object methodType) {
                    throw new IllegalStateException("Unsupported type for the current JVM: java.lang.invoke.MethodType");
                }
            }

            public static class ForJava7CapableVm
            implements Dispatcher {
                private final Method returnType;
                private final Method parameterArray;

                protected ForJava7CapableVm(Method returnType, Method parameterArray) {
                    this.returnType = returnType;
                    this.parameterArray = parameterArray;
                }

                @Override
                public Class<?> returnType(Object methodType) {
                    try {
                        return (Class)this.returnType.invoke(methodType, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#returnType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodType#returnType", exception.getCause());
                    }
                }

                @Override
                public Class<?>[] parameterArray(Object methodType) {
                    try {
                        return (Class[])this.parameterArray.invoke(methodType, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#parameterArray", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodType#parameterArray", exception.getCause());
                    }
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForJava7CapableVm)) {
                        return false;
                    }
                    ForJava7CapableVm other = (ForJava7CapableVm)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Method this$returnType = this.returnType;
                    Method other$returnType = other.returnType;
                    if (this$returnType == null ? other$returnType != null : !((Object)this$returnType).equals(other$returnType)) {
                        return false;
                    }
                    Method this$parameterArray = this.parameterArray;
                    Method other$parameterArray = other.parameterArray;
                    return !(this$parameterArray == null ? other$parameterArray != null : !((Object)this$parameterArray).equals(other$parameterArray));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForJava7CapableVm;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Method $returnType = this.returnType;
                    result = result * 59 + ($returnType == null ? 43 : ((Object)$returnType).hashCode());
                    Method $parameterArray = this.parameterArray;
                    result = result * 59 + ($parameterArray == null ? 43 : ((Object)$parameterArray).hashCode());
                    return result;
                }
            }

            public static enum CreationAction implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        Class<?> methodType = JavaType.METHOD_TYPE.load();
                        return new ForJava7CapableVm(methodType.getMethod("returnType", new Class[0]), methodType.getMethod("parameterArray", new Class[0]));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }
}

