/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading;

import io.opencensus.contrib.agent.deps.bytebuddy.description.type.TypeDescription;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.ClassInjector;
import io.opencensus.contrib.agent.deps.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;

public interface ClassLoadingStrategy<T extends ClassLoader> {
    public static final ClassLoader BOOTSTRAP_LOADER = null;
    public static final ProtectionDomain NO_PROTECTION_DOMAIN = null;

    public Map<TypeDescription, Class<?>> load(T var1, Map<TypeDescription, byte[]> var2);

    public static class ForUnsafeInjection
    implements ClassLoadingStrategy<ClassLoader> {
        private final ProtectionDomain protectionDomain;

        public ForUnsafeInjection() {
            this(NO_PROTECTION_DOMAIN);
        }

        public ForUnsafeInjection(ProtectionDomain protectionDomain) {
            this.protectionDomain = protectionDomain;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            return new ClassInjector.UsingUnsafe(classLoader, this.protectionDomain).inject(types);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForUnsafeInjection)) {
                return false;
            }
            ForUnsafeInjection other = (ForUnsafeInjection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProtectionDomain this$protectionDomain = this.protectionDomain;
            ProtectionDomain other$protectionDomain = other.protectionDomain;
            return !(this$protectionDomain == null ? other$protectionDomain != null : !this$protectionDomain.equals(other$protectionDomain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForUnsafeInjection;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProtectionDomain $protectionDomain = this.protectionDomain;
            result = result * 59 + ($protectionDomain == null ? 43 : $protectionDomain.hashCode());
            return result;
        }
    }

    public static class ForBootstrapInjection
    implements ClassLoadingStrategy<ClassLoader> {
        private final Instrumentation instrumentation;
        private final File folder;

        public ForBootstrapInjection(Instrumentation instrumentation, File folder) {
            this.instrumentation = instrumentation;
            this.folder = folder;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            ClassInjector.UsingReflection classInjector = classLoader == null ? ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation) : new ClassInjector.UsingReflection(classLoader);
            return classInjector.inject(types);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForBootstrapInjection)) {
                return false;
            }
            ForBootstrapInjection other = (ForBootstrapInjection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Instrumentation this$instrumentation = this.instrumentation;
            Instrumentation other$instrumentation = other.instrumentation;
            if (this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation)) {
                return false;
            }
            File this$folder = this.folder;
            File other$folder = other.folder;
            return !(this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForBootstrapInjection;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instrumentation $instrumentation = this.instrumentation;
            result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
            File $folder = this.folder;
            result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
            return result;
        }
    }

    public static class UsingLookup
    implements ClassLoadingStrategy<ClassLoader> {
        private final ClassInjector classInjector;
        private final ClassLoader classLoader;

        protected UsingLookup(ClassInjector classInjector, ClassLoader classLoader) {
            this.classInjector = classInjector;
            this.classLoader = classLoader;
        }

        public static ClassLoadingStrategy<ClassLoader> of(Object lookup) {
            ClassInjector.UsingLookup classInjector = ClassInjector.UsingLookup.of(lookup);
            return new UsingLookup(classInjector, classInjector.lookupType().getClassLoader());
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader != this.classLoader) {
                throw new IllegalStateException("Cannot define a type in " + classLoader + " with lookup based on " + this.classLoader);
            }
            return this.classInjector.inject(types);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsingLookup)) {
                return false;
            }
            UsingLookup other = (UsingLookup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassInjector this$classInjector = this.classInjector;
            ClassInjector other$classInjector = other.classInjector;
            if (this$classInjector == null ? other$classInjector != null : !this$classInjector.equals(other$classInjector)) {
                return false;
            }
            ClassLoader this$classLoader = this.classLoader;
            ClassLoader other$classLoader = other.classLoader;
            return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UsingLookup;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassInjector $classInjector = this.classInjector;
            result = result * 59 + ($classInjector == null ? 43 : $classInjector.hashCode());
            ClassLoader $classLoader = this.classLoader;
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            return result;
        }
    }

    public static interface Configurable<S extends ClassLoader>
    extends ClassLoadingStrategy<S> {
        public Configurable<S> with(ProtectionDomain var1);

        public Configurable<S> with(PackageDefinitionStrategy var1);

        public Configurable<S> allowExistingTypes();
    }

    public static enum Default implements Configurable<ClassLoader>
    {
        WRAPPER(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, false)),
        WRAPPER_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, false)),
        CHILD_FIRST(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, true)),
        CHILD_FIRST_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, true)),
        INJECTION(new InjectionDispatcher());

        private static final boolean DEFAULT_FORBID_EXISTING = true;
        private final Configurable<ClassLoader> dispatcher;

        private Default(Configurable<ClassLoader> dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            return this.dispatcher.load(classLoader, types);
        }

        @Override
        public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
            return this.dispatcher.with(protectionDomain);
        }

        @Override
        public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
            return this.dispatcher.with(packageDefinitionStrategy);
        }

        @Override
        public Configurable<ClassLoader> allowExistingTypes() {
            return this.dispatcher.allowExistingTypes();
        }

        protected static class WrappingDispatcher
        implements Configurable<ClassLoader> {
            private static final boolean CHILD_FIRST = true;
            private static final boolean PARENT_FIRST = false;
            private final ProtectionDomain protectionDomain;
            private final ByteArrayClassLoader.PersistenceHandler persistenceHandler;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean childFirst;
            private final boolean forbidExisting;

            protected WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst) {
                this(NO_PROTECTION_DOMAIN, PackageDefinitionStrategy.Trivial.INSTANCE, persistenceHandler, childFirst, true);
            }

            private WrappingDispatcher(ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst, boolean forbidExisting) {
                this.protectionDomain = protectionDomain;
                this.packageDefinitionStrategy = packageDefinitionStrategy;
                this.persistenceHandler = persistenceHandler;
                this.childFirst = childFirst;
                this.forbidExisting = forbidExisting;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, this.protectionDomain, this.persistenceHandler, this.packageDefinitionStrategy, this.childFirst, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
                return new WrappingDispatcher(protectionDomain, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
                return new WrappingDispatcher(this.protectionDomain, packageDefinitionStrategy, this.persistenceHandler, this.childFirst, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> allowExistingTypes() {
                return new InjectionDispatcher(this.protectionDomain, this.packageDefinitionStrategy, false);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WrappingDispatcher)) {
                    return false;
                }
                WrappingDispatcher other = (WrappingDispatcher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ProtectionDomain this$protectionDomain = this.protectionDomain;
                ProtectionDomain other$protectionDomain = other.protectionDomain;
                if (this$protectionDomain == null ? other$protectionDomain != null : !this$protectionDomain.equals(other$protectionDomain)) {
                    return false;
                }
                ByteArrayClassLoader.PersistenceHandler this$persistenceHandler = this.persistenceHandler;
                ByteArrayClassLoader.PersistenceHandler other$persistenceHandler = other.persistenceHandler;
                if (this$persistenceHandler == null ? other$persistenceHandler != null : !((Object)((Object)this$persistenceHandler)).equals((Object)other$persistenceHandler)) {
                    return false;
                }
                PackageDefinitionStrategy this$packageDefinitionStrategy = this.packageDefinitionStrategy;
                PackageDefinitionStrategy other$packageDefinitionStrategy = other.packageDefinitionStrategy;
                if (this$packageDefinitionStrategy == null ? other$packageDefinitionStrategy != null : !this$packageDefinitionStrategy.equals(other$packageDefinitionStrategy)) {
                    return false;
                }
                if (this.childFirst != other.childFirst) {
                    return false;
                }
                return this.forbidExisting == other.forbidExisting;
            }

            protected boolean canEqual(Object other) {
                return other instanceof WrappingDispatcher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ProtectionDomain $protectionDomain = this.protectionDomain;
                result = result * 59 + ($protectionDomain == null ? 43 : $protectionDomain.hashCode());
                ByteArrayClassLoader.PersistenceHandler $persistenceHandler = this.persistenceHandler;
                result = result * 59 + ($persistenceHandler == null ? 43 : ((Object)((Object)$persistenceHandler)).hashCode());
                PackageDefinitionStrategy $packageDefinitionStrategy = this.packageDefinitionStrategy;
                result = result * 59 + ($packageDefinitionStrategy == null ? 43 : $packageDefinitionStrategy.hashCode());
                result = result * 59 + (this.childFirst ? 79 : 97);
                result = result * 59 + (this.forbidExisting ? 79 : 97);
                return result;
            }
        }

        protected static class InjectionDispatcher
        implements Configurable<ClassLoader> {
            private final ProtectionDomain protectionDomain;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean forbidExisting;

            protected InjectionDispatcher() {
                this(NO_PROTECTION_DOMAIN, PackageDefinitionStrategy.NoOp.INSTANCE, true);
            }

            private InjectionDispatcher(ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
                this.protectionDomain = protectionDomain;
                this.packageDefinitionStrategy = packageDefinitionStrategy;
                this.forbidExisting = forbidExisting;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return new ClassInjector.UsingReflection(classLoader, this.protectionDomain, this.packageDefinitionStrategy, this.forbidExisting).inject(types);
            }

            @Override
            public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
                return new InjectionDispatcher(protectionDomain, this.packageDefinitionStrategy, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
                return new InjectionDispatcher(this.protectionDomain, packageDefinitionStrategy, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> allowExistingTypes() {
                return new InjectionDispatcher(this.protectionDomain, this.packageDefinitionStrategy, false);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InjectionDispatcher)) {
                    return false;
                }
                InjectionDispatcher other = (InjectionDispatcher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ProtectionDomain this$protectionDomain = this.protectionDomain;
                ProtectionDomain other$protectionDomain = other.protectionDomain;
                if (this$protectionDomain == null ? other$protectionDomain != null : !this$protectionDomain.equals(other$protectionDomain)) {
                    return false;
                }
                PackageDefinitionStrategy this$packageDefinitionStrategy = this.packageDefinitionStrategy;
                PackageDefinitionStrategy other$packageDefinitionStrategy = other.packageDefinitionStrategy;
                if (this$packageDefinitionStrategy == null ? other$packageDefinitionStrategy != null : !this$packageDefinitionStrategy.equals(other$packageDefinitionStrategy)) {
                    return false;
                }
                return this.forbidExisting == other.forbidExisting;
            }

            protected boolean canEqual(Object other) {
                return other instanceof InjectionDispatcher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ProtectionDomain $protectionDomain = this.protectionDomain;
                result = result * 59 + ($protectionDomain == null ? 43 : $protectionDomain.hashCode());
                PackageDefinitionStrategy $packageDefinitionStrategy = this.packageDefinitionStrategy;
                result = result * 59 + ($packageDefinitionStrategy == null ? 43 : $packageDefinitionStrategy.hashCode());
                result = result * 59 + (this.forbidExisting ? 79 : 97);
                return result;
            }
        }
    }
}

