/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.stats;

import io.opencensus.common.Function;
import io.opencensus.common.Timestamp;
import io.opencensus.internal.Utils;
import io.opencensus.stats.AutoValue_AggregationData_CountData;
import io.opencensus.stats.AutoValue_AggregationData_DistributionData;
import io.opencensus.stats.AutoValue_AggregationData_DistributionData_Exemplar;
import io.opencensus.stats.AutoValue_AggregationData_LastValueDataDouble;
import io.opencensus.stats.AutoValue_AggregationData_LastValueDataLong;
import io.opencensus.stats.AutoValue_AggregationData_MeanData;
import io.opencensus.stats.AutoValue_AggregationData_SumDataDouble;
import io.opencensus.stats.AutoValue_AggregationData_SumDataLong;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AggregationData {
    private AggregationData() {
    }

    public abstract <T> T match(Function<? super SumDataDouble, T> var1, Function<? super SumDataLong, T> var2, Function<? super CountData, T> var3, Function<? super DistributionData, T> var4, Function<? super LastValueDataDouble, T> var5, Function<? super LastValueDataLong, T> var6, Function<? super AggregationData, T> var7);

    @Immutable
    public static abstract class LastValueDataLong
    extends AggregationData {
        LastValueDataLong() {
        }

        public static LastValueDataLong create(long lastValue) {
            return new AutoValue_AggregationData_LastValueDataLong(lastValue);
        }

        public abstract long getLastValue();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p5.apply(this);
        }
    }

    @Immutable
    public static abstract class LastValueDataDouble
    extends AggregationData {
        LastValueDataDouble() {
        }

        public static LastValueDataDouble create(double lastValue) {
            return new AutoValue_AggregationData_LastValueDataDouble(lastValue);
        }

        public abstract double getLastValue();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p4.apply(this);
        }
    }

    @Immutable
    public static abstract class DistributionData
    extends AggregationData {
        DistributionData() {
        }

        public static DistributionData create(double mean, long count, double min, double max, double sumOfSquaredDeviations, List<Long> bucketCounts, List<Exemplar> exemplars) {
            if (min != Double.POSITIVE_INFINITY || max != Double.NEGATIVE_INFINITY) {
                Utils.checkArgument(min <= max, "max should be greater or equal to min.");
            }
            Utils.checkNotNull(bucketCounts, "bucket counts should not be null.");
            List<Long> bucketCountsCopy = Collections.unmodifiableList(new ArrayList<Long>(bucketCounts));
            for (Long bucket : bucketCountsCopy) {
                Utils.checkNotNull(bucket, "bucket should not be null.");
            }
            Utils.checkNotNull(exemplars, "exemplar list should not be null.");
            for (Exemplar exemplar : exemplars) {
                Utils.checkNotNull(exemplar, "exemplar should not be null.");
            }
            return new AutoValue_AggregationData_DistributionData(mean, count, min, max, sumOfSquaredDeviations, bucketCountsCopy, Collections.unmodifiableList(new ArrayList<Exemplar>(exemplars)));
        }

        public static DistributionData create(double mean, long count, double min, double max, double sumOfSquaredDeviations, List<Long> bucketCounts) {
            return DistributionData.create(mean, count, min, max, sumOfSquaredDeviations, bucketCounts, Collections.<Exemplar>emptyList());
        }

        public abstract double getMean();

        public abstract long getCount();

        public abstract double getMin();

        public abstract double getMax();

        public abstract double getSumOfSquaredDeviations();

        public abstract List<Long> getBucketCounts();

        public abstract List<Exemplar> getExemplars();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p3.apply(this);
        }

        @Immutable
        public static abstract class Exemplar {
            Exemplar() {
            }

            public abstract double getValue();

            public abstract Timestamp getTimestamp();

            public abstract Map<String, String> getAttachments();

            public static Exemplar create(double value, Timestamp timestamp, Map<String, String> attachments) {
                Utils.checkNotNull(attachments, "attachments");
                Map<String, String> attachmentsCopy = Collections.unmodifiableMap(new HashMap<String, String>(attachments));
                for (Map.Entry<String, String> entry : attachmentsCopy.entrySet()) {
                    Utils.checkNotNull(entry.getKey(), "key of attachments");
                    Utils.checkNotNull(entry.getValue(), "value of attachments");
                }
                return new AutoValue_AggregationData_DistributionData_Exemplar(value, timestamp, attachmentsCopy);
            }
        }
    }

    @Deprecated
    @Immutable
    public static abstract class MeanData
    extends AggregationData {
        MeanData() {
        }

        public static MeanData create(double mean, long count) {
            return new AutoValue_AggregationData_MeanData(mean, count);
        }

        public abstract double getMean();

        public abstract long getCount();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return defaultFunction.apply(this);
        }
    }

    @Immutable
    public static abstract class CountData
    extends AggregationData {
        CountData() {
        }

        public static CountData create(long count) {
            return new AutoValue_AggregationData_CountData(count);
        }

        public abstract long getCount();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p2.apply(this);
        }
    }

    @Immutable
    public static abstract class SumDataLong
    extends AggregationData {
        SumDataLong() {
        }

        public static SumDataLong create(long sum) {
            return new AutoValue_AggregationData_SumDataLong(sum);
        }

        public abstract long getSum();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p1.apply(this);
        }
    }

    @Immutable
    public static abstract class SumDataDouble
    extends AggregationData {
        SumDataDouble() {
        }

        public static SumDataDouble create(double sum) {
            return new AutoValue_AggregationData_SumDataDouble(sum);
        }

        public abstract double getSum();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p0.apply(this);
        }
    }
}

