/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.openapitools.jackson.dataformat.hal.annotation.Resource;
import io.openapitools.jackson.dataformat.hal.deser.HALBeanDeserializer;
import io.openapitools.jackson.dataformat.hal.deser.ReservedProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HALBeanDeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        Resource ann = (Resource)beanDesc.getClassAnnotations().get(Resource.class);
        if (ann != null) {
            return new HALBeanDeserializer((BeanDeserializerBase)((BeanDeserializer)deserializer));
        }
        return deserializer;
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        Resource ann = (Resource)beanDesc.getClassAnnotations().get(Resource.class);
        if (ann != null) {
            ArrayList<BeanPropertyDefinition> modified = new ArrayList<BeanPropertyDefinition>();
            Iterator<BeanPropertyDefinition> defIt = propDefs.iterator();
            while (defIt.hasNext()) {
                BeanPropertyDefinition pbd = defIt.next();
                for (ReservedProperty rp : ReservedProperty.values()) {
                    String alternateName = rp.alternateName(pbd, pbd.getName());
                    if (pbd.getName().equals(alternateName)) continue;
                    modified.add(pbd.withName(new PropertyName(alternateName)));
                    defIt.remove();
                }
            }
            propDefs.addAll(modified);
        }
        return propDefs;
    }
}

