/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openapitools.jackson.dataformat.hal.deser.ReservedProperty;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class HALBeanDeserializer
extends DelegatingDeserializer {
    public HALBeanDeserializer(BeanDeserializerBase delegate) {
        super((JsonDeserializer)delegate);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        TreeNode tn = p.getCodec().readTree(p);
        if (tn.isObject()) {
            ObjectNode root = (ObjectNode)tn;
            for (ReservedProperty rp : ReservedProperty.values()) {
                ObjectNode on = (ObjectNode)tn.get(rp.getPropertyName());
                if (on == null) continue;
                Iterator it = on.fields();
                while (it.hasNext()) {
                    Map.Entry jn = (Map.Entry)it.next();
                    root.set(rp.alternateName((String)jn.getKey()), (JsonNode)jn.getValue());
                }
                root.remove(rp.getPropertyName());
            }
        }
        JsonParser modifiedParser = tn.traverse(p.getCodec());
        modifiedParser.nextToken();
        return this._delegatee.deserialize(modifiedParser, ctxt);
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new HALBeanDeserializer((BeanDeserializerBase)newDelegatee);
    }
}

