/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.processor;

import io.objectbox.annotation.BaseEntity;
import io.objectbox.annotation.NameInDb;
import io.objectbox.annotation.Uid;
import io.objectbox.generator.BoxGenerator;
import io.objectbox.generator.GeneratorJob;
import io.objectbox.generator.GeneratorOutput;
import io.objectbox.generator.idsync.IdSync;
import io.objectbox.generator.idsync.IdSyncException;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.HasParsedElement;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.PropertyType;
import io.objectbox.generator.model.Schema;
import io.objectbox.processor.FileHelperKt;
import io.objectbox.processor.Messages;
import io.objectbox.processor.ObjectBoxProcessor;
import io.objectbox.processor.Properties;
import io.objectbox.processor.Relations;
import io.objectbox.processor.TypeHelper;
import io.objectbox.reporting.BasicBuildTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J,\u0010\"\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060$H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010 \u001a\u000203H\u0016J&\u00104\u001a\u00020\u00042\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u0002060'2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080'H\u0002J.\u00109\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;2\u0006\u0010/\u001a\u00020%H\u0002J.\u0010<\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010:\u001a\u00020;2\u0006\u00100\u001a\u0002012\u0006\u0010=\u001a\u00020%H\u0002J\u001e\u0010>\u001a\u00020\u00042\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0$2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010B\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u0004H\u0002J\f\u0010D\u001a\u00020\u001f*\u000201H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lio/objectbox/processor/ObjectBoxProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "allowNumberedConstructorArgs", "", "customDefaultPackage", "", "customModelPath", "daoCompat", "daoCompatPackage", "debug", "elementUtils", "Ljavax/lang/model/util/Elements;", "filer", "Ljavax/annotation/processing/Filer;", "flatbuffersSchemaPath", "incremental", "javaLangObjectType", "Ljavax/lang/model/type/TypeMirror;", "messages", "Lio/objectbox/processor/Messages;", "schema", "Lio/objectbox/generator/model/Schema;", "getSchema", "()Lio/objectbox/generator/model/Schema;", "setSchema", "(Lio/objectbox/generator/model/Schema;)V", "transformationEnabled", "typeUtils", "Ljavax/lang/model/util/Types;", "findAndParse", "", "env", "Ljavax/annotation/processing/RoundEnvironment;", "findAnnotatedSuperElements", "annotatedElements", "", "Ljavax/lang/model/element/Element;", "entityInheritanceChain", "", "type", "getSupportedAnnotationTypes", "getSupportedOptions", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "hasAllArgsConstructor", "entity", "entityModel", "Lio/objectbox/generator/model/Entity;", "init", "Ljavax/annotation/processing/ProcessingEnvironment;", "parametersMatchProperties", "parameters", "Ljavax/lang/model/element/VariableElement;", "properties", "Lio/objectbox/generator/model/Property;", "parseEntity", "relations", "Lio/objectbox/processor/Relations;", "parseProperties", "entityElement", "process", "annotations", "Ljavax/lang/model/element/TypeElement;", "syncIdModel", "trackStats", "completed", "ensureIdProperty", "Companion", "objectbox-processor"})
public class ObjectBoxProcessor
extends AbstractProcessor {
    @Nullable
    private Schema schema;
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private Messages messages;
    private TypeMirror javaLangObjectType;
    private String customModelPath;
    private String customDefaultPackage;
    private boolean daoCompat;
    private boolean transformationEnabled;
    private String daoCompatPackage;
    private String flatbuffersSchemaPath;
    private boolean debug;
    private boolean allowNumberedConstructorArgs;
    private boolean incremental;
    @NotNull
    public static final String OPTION_MODEL_PATH = "objectbox.modelPath";
    @NotNull
    public static final String OPTION_MYOBJECTBOX_PACKAGE = "objectbox.myObjectBoxPackage";
    @NotNull
    public static final String OPTION_DAO_COMPAT = "objectbox.daoCompat";
    @NotNull
    public static final String OPTION_DAO_PACKAGE = "objectbox.daoPackage";
    @NotNull
    public static final String OPTION_FLATBUFFERS_SCHEMA_FOLDER = "objectbox.flatbuffersSchemaFolder";
    @NotNull
    public static final String OPTION_DEBUG = "objectbox.debug";
    @NotNull
    public static final String OPTION_TRANSFORMATION_ENABLED = "objectbox.transformationEnabled";
    @NotNull
    public static final String OPTION_ALLOW_NUMBERED_CONSTRUCTOR_ARGS = "objectbox.allowNumberedConstructorArgs";
    @NotNull
    public static final String OPTION_INCREMENTAL = "objectbox.incremental";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Schema getSchema() {
        return this.schema;
    }

    public final void setSchema(@Nullable Schema schema) {
        this.schema = schema;
    }

    @Override
    public synchronized void init(@NotNull ProcessingEnvironment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        super.init(env);
        Elements elements = env.getElementUtils();
        Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"env.elementUtils");
        this.elementUtils = elements;
        Types types = env.getTypeUtils();
        Intrinsics.checkExpressionValueIsNotNull((Object)types, (String)"env.typeUtils");
        this.typeUtils = types;
        Filer filer = env.getFiler();
        Intrinsics.checkExpressionValueIsNotNull((Object)filer, (String)"env.filer");
        this.filer = filer;
        Elements elements2 = this.elementUtils;
        if (elements2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"elementUtils");
        }
        TypeMirror typeMirror = elements2.getTypeElement(Object.class.getCanonicalName()).asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"elementUtils.getTypeElem\u2026a.canonicalName).asType()");
        this.javaLangObjectType = typeMirror;
        Map<String, String> options = env.getOptions();
        this.customModelPath = options.get(OPTION_MODEL_PATH);
        this.customDefaultPackage = options.get(OPTION_MYOBJECTBOX_PACKAGE);
        this.daoCompat = Intrinsics.areEqual((Object)"true", (Object)options.get(OPTION_DAO_COMPAT));
        this.debug = Intrinsics.areEqual((Object)"true", (Object)options.get(OPTION_DEBUG));
        this.daoCompatPackage = options.get(OPTION_DAO_PACKAGE);
        this.flatbuffersSchemaPath = options.get(OPTION_FLATBUFFERS_SCHEMA_FOLDER);
        this.transformationEnabled = Intrinsics.areEqual((Object)"false", (Object)options.get(OPTION_TRANSFORMATION_ENABLED)) ^ true;
        this.allowNumberedConstructorArgs = Intrinsics.areEqual((Object)"false", (Object)options.get(OPTION_ALLOW_NUMBERED_CONSTRUCTOR_ARGS)) ^ true;
        this.incremental = Intrinsics.areEqual((Object)"true", (Object)options.get(OPTION_INCREMENTAL));
        Messager messager = env.getMessager();
        Intrinsics.checkExpressionValueIsNotNull((Object)messager, (String)"env.messager");
        Messages messages = this.messages = new Messages(messager, this.debug);
        if (messages == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
        }
        messages.info("Starting ObjectBox processor (debug: " + this.debug + ", incremental: " + this.incremental + ')');
    }

    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(io.objectbox.annotation.Entity.class.getCanonicalName());
        types.add(BaseEntity.class.getCanonicalName());
        return types;
    }

    @Override
    @NotNull
    public Set<String> getSupportedOptions() {
        LinkedHashSet<String> options = new LinkedHashSet<String>();
        options.add(OPTION_MODEL_PATH);
        options.add(OPTION_MYOBJECTBOX_PACKAGE);
        options.add(OPTION_DAO_COMPAT);
        options.add(OPTION_DAO_PACKAGE);
        options.add(OPTION_FLATBUFFERS_SCHEMA_FOLDER);
        options.add(OPTION_TRANSFORMATION_ENABLED);
        options.add(OPTION_DEBUG);
        options.add(OPTION_ALLOW_NUMBERED_CONSTRUCTOR_ARGS);
        options.add(OPTION_INCREMENTAL);
        if (this.incremental) {
            options.add(IncrementalAnnotationProcessorType.AGGREGATING.getProcessorOption());
        }
        return options;
    }

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latestSupported()");
        return sourceVersion;
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment env) {
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        try {
            this.findAndParse(env);
        }
        catch (Throwable e) {
            new BasicBuildTracker("Processor").trackFatal("Processing failed", e);
            throw e;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void findAndParse(RoundEnvironment env) {
        boolean $i$f$map22;
        String string;
        Messages messages = this.messages;
        if (messages == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
        }
        Relations relations = new Relations(messages);
        Messages messages2 = this.messages;
        if (messages2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
        }
        if (messages2.getErrorRaised()) {
            return;
        }
        Set<? extends Element> entities = env.getElementsAnnotatedWith(io.objectbox.annotation.Entity.class);
        if (entities.size() == 0) {
            return;
        }
        if (this.daoCompat && this.daoCompatPackage != null) {
            string = this.daoCompatPackage;
        } else if (this.customDefaultPackage != null) {
            string = this.customDefaultPackage;
        } else {
            void $this$mapTo$iv$iv22;
            Set<? extends Element> set = entities;
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"entities");
            Iterable $this$map$iv = set;
            $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Elements elements = this.elementUtils;
                if (elements == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"elementUtils");
                }
                PackageElement packageElement = elements.getPackageOf((Element)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)packageElement, (String)"elementUtils.getPackageOf(it)");
                String string2 = packageElement.getQualifiedName().toString();
                collection.add(string2);
            }
            List packages = (List)destination$iv$iv;
            string = Companion.selectPackage$objectbox_processor(packages);
        }
        String defaultJavaPackage = string;
        Schema schema = new Schema("default", 1, defaultJavaPackage);
        $i$f$map22 = false;
        Set $i$f$map22 = new LinkedHashSet();
        boolean $this$mapTo$iv$iv22 = false;
        boolean bl = false;
        Set $this$run = $i$f$map22;
        boolean bl2 = false;
        Set<? extends Element> set = env.getElementsAnnotatedWith(io.objectbox.annotation.Entity.class);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"env.getElementsAnnotatedWith(Entity::class.java)");
        $this$run.addAll((Collection)set);
        Set<? extends Element> set2 = env.getElementsAnnotatedWith(BaseEntity.class);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"env.getElementsAnnotated\u2026h(BaseEntity::class.java)");
        $this$run.addAll((Collection)set2);
        Set annotatedElements = CollectionsKt.toSet((Iterable)$this$run);
        Iterator<? extends Element> $this$mapTo$iv$iv22 = entities.iterator();
        while ($this$mapTo$iv$iv22.hasNext()) {
            Element entity;
            Element element = entity = $this$mapTo$iv$iv22.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"entity");
            this.parseEntity(annotatedElements, schema, relations, element);
        }
        Messages messages3 = this.messages;
        if (messages3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
        }
        if (messages3.getErrorRaised()) {
            return;
        }
        if (!relations.resolve(schema)) {
            return;
        }
        Messages messages4 = this.messages;
        if (messages4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
        }
        if (messages4.getErrorRaised()) {
            return;
        }
        try {
            schema.finish();
        }
        catch (Exception e) {
            Messages messages5 = this.messages;
            if (messages5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages5.error("Code generation failed: " + e);
            e.printStackTrace();
            return;
        }
        if (!this.syncIdModel(schema)) {
            return;
        }
        this.schema = schema;
        boolean completed = false;
        try {
            Filer filer = this.filer;
            if (filer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filer");
            }
            GeneratorJob job = new GeneratorJob(schema, GeneratorOutput.create((Filer)filer));
            job.setDaoCompat(this.daoCompat);
            String string3 = this.flatbuffersSchemaPath;
            if (string3 != null) {
                String string4 = string3;
                boolean bl3 = false;
                boolean bl4 = false;
                String it = string4;
                boolean bl5 = false;
                job.setOutputFlatbuffersSchema(GeneratorOutput.create((String)it));
            }
            new BoxGenerator().generateAll(job);
            completed = true;
        }
        catch (Exception e) {
            Messages messages6 = this.messages;
            if (messages6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages6.error("Code generation failed: " + e);
            e.printStackTrace();
        }
        this.trackStats(schema, completed);
    }

    private final void trackStats(Schema schema, boolean completed) {
        int toOneCount = 0;
        int toManyCount = 0;
        int propertyCount = 0;
        Iterator iterator = schema.getEntities().iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Entity entity2 = entity = (Entity)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
            List list = entity2.getToManyRelations();
            toManyCount += list != null ? list.size() : 0;
            List list2 = entity.getToOneRelations();
            toOneCount += list2 != null ? list2.size() : 0;
            List list3 = entity.getProperties();
            propertyCount += list3 != null ? list3.size() : 0;
        }
        int n = toOneCount;
        int n2 = toManyCount;
        int n3 = propertyCount;
        int n4 = schema.getEntities().size();
        boolean bl = completed;
        boolean bl2 = this.daoCompat;
        new BasicBuildTracker("Processor").trackStats(bl, bl2, n4, n3, n, n2);
    }

    private final void parseEntity(Set<? extends Element> annotatedElements, Schema schema, Relations relations, Element entity) {
        Uid uidAnnotation;
        Entity entityModel;
        Object v3;
        Object object;
        boolean bl;
        Iterable iterable;
        String name;
        block12: {
            name = entity.getSimpleName().toString();
            if (this.debug) {
                Messages messages = this.messages;
                if (messages == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                }
                messages.debug("Parsing entity " + name + "...");
            }
            List list = schema.getEntities();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schema.entities");
            iterable = list;
            bl = false;
            object = iterable;
            boolean bl2 = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Entity it = (Entity)t;
                boolean bl3 = false;
                Entity entity2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"it");
                if (!Intrinsics.areEqual((Object)entity2.getClassName(), (Object)name)) continue;
                v3 = t;
                break block12;
            }
            v3 = null;
        }
        Entity entity3 = v3;
        if (entity3 != null) {
            iterable = entity3;
            bl = false;
            boolean bl4 = false;
            Iterable it = iterable;
            boolean bl5 = false;
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.error("There is already an entity class '" + name + "': '" + it.getJavaPackage() + '.' + it.getClassName() + "'.", entity);
            return;
        }
        Entity entity4 = entityModel = schema.addEntity(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)entity4, (String)"entityModel");
        entity4.setSkipGeneration(true);
        entityModel.setSkipCreationInDb(false);
        Elements elements = this.elementUtils;
        if (elements == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"elementUtils");
        }
        PackageElement packageElement = elements.getPackageOf(entity);
        Intrinsics.checkExpressionValueIsNotNull((Object)packageElement, (String)"elementUtils.getPackageOf(entity)");
        entityModel.setJavaPackage(packageElement.getQualifiedName().toString());
        String string = this.daoCompatPackage;
        if (string == null) {
            string = entityModel.getJavaPackage();
        }
        entityModel.setJavaPackageDao(string);
        entityModel.setJavaPackageTest(entityModel.getJavaPackageDao());
        NameInDb nameInDbAnnotation = entity.getAnnotation(NameInDb.class);
        if (nameInDbAnnotation != null) {
            object = nameInDbAnnotation.value();
            boolean it = false;
            if (object.length() > 0) {
                entityModel.setDbName(nameInDbAnnotation.value());
            }
        }
        if ((uidAnnotation = entity.getAnnotation(Uid.class)) != null) {
            long uid = uidAnnotation.value() == 0L ? -1L : uidAnnotation.value();
            entityModel.setModelUid(Long.valueOf(uid));
        }
        this.parseProperties(annotatedElements, relations, entityModel, entity);
        this.ensureIdProperty(entityModel);
        if (!this.transformationEnabled && relations.hasRelations(entityModel) && !entityModel.getHasBoxStoreField()) {
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.error("To use relations in '" + entityModel.getClassName() + "' " + "add a field '__boxStore' of type 'BoxStore'.", entity);
        }
        relations.ensureTargetIdProperties(entityModel);
        entityModel.setConstructors(this.hasAllArgsConstructor(entity, entityModel));
    }

    private final boolean findAnnotatedSuperElements(Set<? extends Element> annotatedElements, List<Element> entityInheritanceChain, TypeMirror type) {
        Types types = this.typeUtils;
        if (types == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
        }
        for (TypeMirror typeMirror : types.directSupertypes(type)) {
            Element matchingElement;
            Object v9;
            boolean bl;
            Object object;
            block15: {
                Types types2 = this.typeUtils;
                if (types2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
                }
                TypeMirror typeMirror2 = this.javaLangObjectType;
                if (typeMirror2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"javaLangObjectType");
                }
                if (types2.isSameType(typeMirror, typeMirror2)) continue;
                if (this.debug) {
                    Messages messages = this.messages;
                    if (messages == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                    }
                    messages.debug(type + " has super type " + typeMirror + '.');
                }
                object = annotatedElements;
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    boolean bl3;
                    Element annotatedElement = (Element)t;
                    boolean bl4 = false;
                    if (annotatedElement.getKind() != ElementKind.CLASS) {
                        bl3 = false;
                    } else {
                        Types types3 = this.typeUtils;
                        if (types3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
                        }
                        Types types4 = this.typeUtils;
                        if (types4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
                        }
                        TypeMirror typeMirror3 = types4.erasure(annotatedElement.asType());
                        Types types5 = this.typeUtils;
                        if (types5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
                        }
                        bl3 = types3.isSameType(typeMirror3, types5.erasure(typeMirror));
                    }
                    if (!bl3) continue;
                    v9 = t;
                    break block15;
                }
                v9 = null;
            }
            Element element = matchingElement = (Element)v9;
            if (element != null) {
                object = element;
                bl = false;
                boolean bl5 = false;
                Object it = object;
                boolean bl6 = false;
                entityInheritanceChain.add((Element)it);
                if (this.debug) {
                    Messages messages = this.messages;
                    if (messages == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                    }
                    messages.debug(typeMirror + " is annotated, add to inheritance chain.");
                }
            }
            TypeMirror typeMirror4 = typeMirror;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror4, (String)"superType");
            boolean hasMatches = this.findAnnotatedSuperElements(annotatedElements, entityInheritanceChain, typeMirror4);
            if (matchingElement == null && !hasMatches) continue;
            return true;
        }
        return false;
    }

    private final void parseProperties(Set<? extends Element> annotatedElements, Relations relations, Entity entityModel, Element entityElement) {
        List entityInheritanceChain = CollectionsKt.mutableListOf((Object[])new Element[]{entityElement});
        TypeMirror typeMirror = entityElement.asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"entityElement.asType()");
        if (this.findAnnotatedSuperElements(annotatedElements, entityInheritanceChain, typeMirror) && this.debug) {
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.debug("Detected entity inheritance chain: " + CollectionsKt.joinToString$default((Iterable)entityInheritanceChain, (CharSequence)"->", null, null, (int)0, null, (Function1)parseProperties.1.INSTANCE, (int)30, null));
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)entityInheritanceChain);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element element = (Element)element$iv;
            boolean bl = false;
            Elements elements = this.elementUtils;
            if (elements == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"elementUtils");
            }
            Types types = this.typeUtils;
            if (types == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
            }
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            Properties properties = new Properties(elements, types, messages, relations, entityModel, element);
            boolean bl2 = false;
            boolean bl3 = false;
            Properties $this$with = properties;
            boolean bl4 = false;
            $this$with.parseFields();
            entityModel.setHasBoxStoreField(entityModel.getHasBoxStoreField() || $this$with.hasBoxStoreField());
        }
    }

    private final void ensureIdProperty(@NotNull Entity $this$ensureIdProperty) {
        int idPropertyCount;
        int n;
        List list = $this$ensureIdProperty.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"properties");
        Iterable $this$count$iv = list;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Property it = (Property)element$iv;
                boolean bl = false;
                Property property = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"it");
                if (!property.isPrimaryKey()) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = idPropertyCount = count$iv;
        }
        if (idPropertyCount == 0) {
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.error("No @Id property found for '" + $this$ensureIdProperty.getClassName() + "', add @Id on a not-null long property.", (HasParsedElement)$this$ensureIdProperty);
        } else if (idPropertyCount > 1) {
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.error("Only one @Id property is allowed for '" + $this$ensureIdProperty.getClassName() + "'.", (HasParsedElement)$this$ensureIdProperty);
        }
    }

    private final boolean hasAllArgsConstructor(Element entity, Entity entityModel) {
        if (this.debug) {
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.debug("Checking for all-args constructor for " + entityModel.getClassName() + "...");
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn((Iterable<? extends Element>)entity.getEnclosedElements());
        List properties = entityModel.getProperties();
        Iterator<ExecutableElement> iterator = constructors.iterator();
        while (iterator.hasNext()) {
            ExecutableElement constructor;
            ExecutableElement executableElement = constructor = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"constructor");
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (this.debug) {
                Messages messages = this.messages;
                if (messages == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                }
                messages.debug("Checking constructor " + constructor + "...");
            }
            if (parameters.size() != properties.size()) continue;
            List<? extends VariableElement> list = parameters;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"parameters");
            List list2 = properties;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"properties");
            if (!this.parametersMatchProperties(list, list2)) continue;
            if (this.debug) {
                Messages messages = this.messages;
                if (messages == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                }
                messages.debug("Valid all-args constructor found");
            }
            return true;
        }
        if (this.debug) {
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            messages.debug("No all-args constructor found for " + entityModel.getClassName());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parametersMatchProperties(List<? extends VariableElement> parameters, List<Property> properties) {
        Types types = this.typeUtils;
        if (types == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
        }
        TypeHelper typeHelper = new TypeHelper(types);
        boolean bl = false;
        for (VariableElement param : (Iterable)parameters) {
            String altName;
            void idx;
            Property property = properties.get((int)idx);
            String string = altName = this.allowNumberedConstructorArgs ? "arg" + (int)idx : null;
            if (property.getParsedElement() != null) {
                Object object = property.getParsedElement();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.VariableElement");
                }
                VariableElement parsedElement = (VariableElement)object;
                if (Intrinsics.areEqual((Object)param.getSimpleName(), (Object)parsedElement.getSimpleName()) ^ true) {
                    if (Intrinsics.areEqual((Object)altName, (Object)param.getSimpleName().toString())) {
                        if (this.debug) {
                            Messages messages = this.messages;
                            if (messages == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                            }
                            messages.debug("Constructor param name alternative accepted: " + altName + " for " + parsedElement.getSimpleName());
                        }
                    } else {
                        if (this.debug) {
                            Messages messages = this.messages;
                            if (messages == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                            }
                            messages.debug("Constructor param name differs: " + param.getSimpleName() + " vs. " + parsedElement.getSimpleName() + " (" + altName + ')');
                        }
                        return false;
                    }
                }
                Types types2 = this.typeUtils;
                if (types2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
                }
                if (!types2.isSameType(param.asType(), parsedElement.asType())) {
                    Messages messages = this.messages;
                    if (messages == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                    }
                    messages.debug("Constructor param type differs: " + param.asType() + " vs. " + parsedElement.asType());
                    return false;
                }
            } else {
                PropertyType paramPropertyType = typeHelper.getPropertyType(param.asType());
                if (paramPropertyType != property.getPropertyType()) {
                    Messages messages = this.messages;
                    if (messages == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                    }
                    messages.debug("Constructor param type differs (virtual property)");
                    return false;
                }
                if (Intrinsics.areEqual((Object)param.getSimpleName().toString(), (Object)property.getPropertyName()) ^ true) {
                    if (Intrinsics.areEqual((Object)altName, (Object)property.getPropertyName()) && this.debug) {
                        Messages messages = this.messages;
                        if (messages == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                        }
                        messages.debug("Constructor param name alternative accepted: " + altName + " for " + property.getPropertyName());
                    }
                    Messages messages = this.messages;
                    if (messages == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                    }
                    messages.debug("Constructor param name differs (virtual property)");
                    return false;
                }
            }
            ++idx;
        }
        return true;
    }

    private final boolean syncIdModel(Schema schema) {
        File modelFolder;
        File file;
        boolean useDefaultPath;
        CharSequence charSequence = this.customModelPath;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = useDefaultPath = charSequence == null || charSequence.length() == 0;
        if (useDefaultPath) {
            File projectRoot;
            try {
                Filer filer = this.filer;
                if (filer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"filer");
                }
                projectRoot = FileHelperKt.findProjectRoot(filer);
                projectRoot = new File(projectRoot, "objectbox-models/default.json");
            }
            catch (FileNotFoundException e) {
                Messages messages = this.messages;
                if (messages == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                }
                messages.error("Could not find project root to create model file in. " + "Add absolute path to model file with processor option 'objectbox.modelPath'. (" + e.getMessage() + ')');
                return false;
            }
            file = projectRoot;
        } else {
            file = new File(this.customModelPath);
        }
        File modelFile = file;
        File file2 = modelFolder = modelFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"modelFolder");
        if (!file2.isDirectory()) {
            if (useDefaultPath) {
                if (!modelFolder.mkdirs()) {
                    Messages messages = this.messages;
                    if (messages == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                    }
                    messages.error("Could not create default model folder at '" + modelFolder.getAbsolutePath() + "'. " + "Add absolute path to model file with processor option 'objectbox.modelPath'.");
                    return false;
                }
            } else {
                Messages messages = this.messages;
                if (messages == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
                }
                messages.error("The model folder does not exist at '" + modelFolder.getAbsolutePath() + '\'' + " (based on the option objectbox.modelPath='" + this.customModelPath + "').");
                return false;
            }
        }
        try {
            new IdSync(modelFile).sync(schema);
        }
        catch (IdSyncException e) {
            String string;
            Messages messages = this.messages;
            if (messages == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messages");
            }
            if ((string = e.getMessage()) == null) {
                string = "Could not sync id model for unknown reason.";
            }
            messages.error(string);
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u0004\u0018\u00010\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/objectbox/processor/ObjectBoxProcessor$Companion;", "", "()V", "OPTION_ALLOW_NUMBERED_CONSTRUCTOR_ARGS", "", "OPTION_DAO_COMPAT", "OPTION_DAO_PACKAGE", "OPTION_DEBUG", "OPTION_FLATBUFFERS_SCHEMA_FOLDER", "OPTION_INCREMENTAL", "OPTION_MODEL_PATH", "OPTION_MYOBJECTBOX_PACKAGE", "OPTION_TRANSFORMATION_ENABLED", "selectPackage", "packages", "", "selectPackage$objectbox_processor", "objectbox-processor"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String selectPackage$objectbox_processor(@NotNull List<String> packages) {
            SortedSet packagesSorted;
            block5: {
                Intrinsics.checkParameterIsNotNull(packages, (String)"packages");
                packagesSorted = CollectionsKt.toSortedSet((Iterable)packages);
                if (packagesSorted.size() < 2) break block5;
                String first = (String)packagesSorted.first();
                Iterator iterator = packagesSorted.iterator();
                boolean bl = false;
                int n = 0;
                Iterator it = iterator;
                boolean bl2 = false;
                it.next();
                String second = (String)it.next();
                int indexCommonDot = -1;
                bl = false;
                n = Integer.MAX_VALUE;
                while (true) {
                    void commonDotCount;
                    int indexDot1;
                    block7: {
                        int n2;
                        String string;
                        block6: {
                            String string2;
                            String string3;
                            int indexSub = indexCommonDot + 1;
                            String string4 = first;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"first");
                            indexDot1 = StringsKt.indexOf$default((CharSequence)string4, (char)'.', (int)indexSub, (boolean)false, (int)4, null);
                            String string5 = second;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"second");
                            int indexDot2 = StringsKt.indexOf$default((CharSequence)string5, (char)'.', (int)indexSub, (boolean)false, (int)4, null);
                            if (indexDot1 == -1 || indexDot2 != indexDot1) break block6;
                            string = first;
                            n2 = 0;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(indexSub, indexDot1), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            string = second;
                            n2 = 0;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(indexSub, indexDot1), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            if (!(Intrinsics.areEqual((Object)string3, (Object)string2) ^ true)) break block7;
                        }
                        if (StringsKt.startsWith$default((String)second, (String)first, (boolean)false, (int)2, null)) {
                            return first;
                        }
                        if (commonDotCount < 2) break;
                        string = first;
                        n2 = 0;
                        boolean bl3 = false;
                        String string6 = string.substring(n2, indexCommonDot);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        return string6;
                    }
                    indexCommonDot = indexDot1;
                    if (commonDotCount == n) break;
                    ++commonDotCount;
                }
            }
            return (String)CollectionsKt.sorted((Iterable)packagesSorted).get(0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

