/*
 * Copyright 2020 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.objectbox.sync.listener;

import io.objectbox.annotation.apihint.Experimental;
import io.objectbox.sync.SyncChange;

/**
 * A {@link SyncListener} with empty implementations of all interface methods.
 * This is helpful if you only want to override some methods.
 */
@Experimental
public abstract class AbstractSyncListener implements SyncListener {

    @Override
    public void onLoggedIn() {
    }

    @Override
    public void onLoginFailed(long syncLoginCode) {
    }

    @Override
    public void onUpdatesCompleted() {
    }

    @Override
    public void onSyncChanges(SyncChange[] syncChanges) {
    }

    @Override
    public void onServerTimeUpdate(long serverTimeNanos) {
    }

    @Override
    public void onDisconnected() {
    }
}
