/*
 * Copyright 2017 ObjectBox Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * ObjectBox is an an easy to use, object-oriented lightweight database and a full alternative to SQLite.
 * <p>
 * The following core classes are the essential interface to ObjectBox:
 * <ul>
 * <li>MyObjectBox: Generated by the Gradle plugin, supplies a {@link io.objectbox.BoxStoreBuilder}
 * to build a BoxStore for your app.</li>
 * <li>{@link io.objectbox.BoxStore}: The database interface, allows to manage Boxes.</li>
 * <li>{@link io.objectbox.Box}: Persists and queries for Objects, there is one for each Entity class.</li>
 * </ul>
 * <p>
 * For more details look at the documentation of individual classes and
 * <a href="https://docs.objectbox.io">docs.objectbox.io</a>.
 */
@ParametersAreNonnullByDefault
package io.objectbox;

import javax.annotation.ParametersAreNonnullByDefault;