/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateNotFoundException;
import io.objectbox.generator.GeneratorJob;
import io.objectbox.generator.GeneratorOutput;
import io.objectbox.generator.PropertyCollector;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.Schema;
import io.objectbox.generator.model.ToManyBase;
import io.objectbox.generator.model.ToOne;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BoxGenerator {
    public static final String MYOBJECTBOX_FTL = "myobjectbox.ftl";
    public static final String BASE_PACKAGE_PATH = "/io/objectbox/generator/";
    private final Template templateMyObjectBox;
    private final Template templateCursor;
    private final Template templateEntityInfo;
    private final Template templateFlatbuffersSchema;
    private final Template templateDao;
    private final Template templateDaoSession;

    public BoxGenerator() throws IOException {
        BoxGenerator.log("ObjectBox Generator");
        BoxGenerator.log("Copyright 2017-2018 ObjectBox Ltd, objectbox.io. Licensed under GPL V3.");
        BoxGenerator.log("This program comes with ABSOLUTELY NO WARRANTY");
        Configuration config = this.getConfiguration(MYOBJECTBOX_FTL);
        this.templateMyObjectBox = config.getTemplate(MYOBJECTBOX_FTL);
        this.templateCursor = config.getTemplate("cursor.ftl");
        this.templateEntityInfo = config.getTemplate("entity-info.ftl");
        this.templateFlatbuffersSchema = config.getTemplate("flatbuffers-schema.ftl");
        this.templateDao = config.getTemplate("dao.ftl");
        this.templateDaoSession = config.getTemplate("dao-session.ftl");
    }

    private Configuration getConfiguration(String probingTemplate) throws IOException {
        Configuration config = new Configuration(Configuration.VERSION_2_3_25);
        config.setClassForTemplateLoading(this.getClass(), BASE_PACKAGE_PATH);
        try {
            config.getTemplate(probingTemplate);
        }
        catch (TemplateNotFoundException e) {
            File dir = new File("../../objectbox-generator/src/main/resources//io/objectbox/generator/");
            if (!dir.exists()) {
                dir = new File("objectbox-generator/src/main/resources//io/objectbox/generator/");
            }
            if (dir.exists() && new File(dir, probingTemplate).exists()) {
                config.setDirectoryForTemplateLoading(dir);
                config.getTemplate(probingTemplate);
            }
            throw e;
        }
        return config;
    }

    public void generateAll(GeneratorJob job) throws Exception {
        long start = System.currentTimeMillis();
        Schema schema = job.getSchema();
        if (!schema.isFinished()) {
            throw new IllegalStateException("Must call schema.finish() first");
        }
        BoxGenerator.log("Processing schema version " + schema.getVersion() + "...");
        List<Entity> entities = schema.getEntities();
        for (Entity entity : entities) {
            Map<String, Object> extras = this.createExtrasForCursor(entity);
            this.generate(this.templateCursor, job, entity.getJavaPackageDao(), entity.getClassNameDao(), entity, extras);
            this.generate(this.templateEntityInfo, job, entity.getJavaPackageDao(), entity.getClassName() + "_", entity, this.createExtrasForEntityInfo(entity));
        }
        if (job.getOutputFlatbuffersSchema() != null) {
            this.generate(this.templateFlatbuffersSchema, job.getOutputFlatbuffersSchema(), "", "flatbuffers", ".fbs", job.getSchema(), null, null);
        }
        this.generate(this.templateMyObjectBox, job, schema.getDefaultJavaPackageDao(), "My" + schema.getPrefix() + "ObjectBox", null, this.createExtrasForMyObjectBox(schema));
        if (job.isDaoCompat()) {
            for (Entity entity : entities) {
                entity.setClassNameDao(entity.getClassName() + "Dao");
                this.generate(this.templateDao, job, entity.getJavaPackageDao(), entity.getClassNameDao(), entity);
            }
            this.generate(this.templateDaoSession, job, schema.getDefaultJavaPackageDao(), schema.getPrefix() + "DaoSession", null);
        }
        long time = System.currentTimeMillis() - start;
        BoxGenerator.log("Processed " + entities.size() + " entities in " + time + "ms");
    }

    private Map<String, Object> createExtrasForMyObjectBox(Schema schema) {
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("io.objectbox.BoxStore");
        imports.add("io.objectbox.BoxStoreBuilder");
        imports.add("io.objectbox.ModelBuilder");
        imports.add("io.objectbox.ModelBuilder.EntityBuilder");
        imports.add("io.objectbox.model.PropertyFlags");
        imports.add("io.objectbox.model.PropertyType");
        for (Entity entity : schema.getEntities()) {
            String javaPackageDao;
            String javaPackage = entity.getJavaPackage();
            if (!javaPackage.equals(schema.getDefaultJavaPackage())) {
                imports.add(String.format("%s.%s", javaPackage, entity.getClassName()));
            }
            if ((javaPackageDao = entity.getJavaPackageDao()).equals(schema.getDefaultJavaPackageDao())) continue;
            imports.add(String.format("%s.%s", javaPackageDao, entity.getClassNameDao()));
            imports.add(String.format("%s.%s_", javaPackageDao, entity.getClassName()));
        }
        HashMap<String, Object> extras = new HashMap<String, Object>();
        extras.put("imports", imports);
        return extras;
    }

    private Map<String, Object> createExtrasForCursor(Entity entity) {
        String javaPackage;
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("io.objectbox.BoxStore");
        imports.add("io.objectbox.Cursor");
        imports.add("io.objectbox.annotation.apihint.Internal");
        imports.add("io.objectbox.internal.CursorFactory");
        if (this.isNotEmpty(entity.getIncomingToManyRelations()) || this.isNotEmpty(entity.getToManyRelations())) {
            imports.add("java.util.List");
        }
        if (this.isNotEmpty(entity.getToManyRelations())) {
            imports.add("io.objectbox.relation.ToMany");
        }
        if (this.isNotEmpty(entity.getToOneRelations())) {
            imports.add("io.objectbox.relation.ToOne");
        }
        if (this.isNotEmpty(javaPackage = entity.getJavaPackage()) && !javaPackage.equals(entity.getJavaPackageDao())) {
            imports.add(String.format("%s.%s", javaPackage, entity.getClassName()));
        }
        imports.addAll(entity.getAdditionalImportsDao());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imports", imports);
        map.put("propertyCollector", new PropertyCollector(entity).createPropertyCollector());
        return map;
    }

    private Map<String, Object> createExtrasForEntityInfo(Entity entity) {
        TreeSet<String> imports = new TreeSet<String>();
        String javaPackageDao = entity.getJavaPackageDao();
        if (this.isNotEmpty(javaPackageDao)) {
            imports.add(String.format("%s.%s.Factory", javaPackageDao, entity.getClassNameDao()));
        }
        imports.add("io.objectbox.EntityInfo");
        imports.add("io.objectbox.annotation.apihint.Internal");
        imports.add("io.objectbox.internal.CursorFactory");
        imports.add("io.objectbox.internal.IdGetter");
        if (entity.hasRelations()) {
            imports.add("io.objectbox.relation.RelationInfo");
            imports.add("io.objectbox.relation.ToOne");
            imports.add("io.objectbox.internal.ToOneGetter");
            List<ToManyBase> toManyRelations = entity.getToManyRelations();
            if (this.isNotEmpty(toManyRelations)) {
                imports.add("io.objectbox.internal.ToManyGetter");
                imports.add("java.util.List");
            }
            for (ToOne toOne : entity.getToOneRelations()) {
                this.addImportIfPackageDiffers(imports, entity, toOne.getTargetEntity());
            }
            for (ToManyBase toMany : toManyRelations) {
                this.addImportIfPackageDiffers(imports, entity, toMany.getTargetEntity());
            }
        }
        imports.addAll(entity.getAdditionalImportsDao());
        HashMap<String, Object> extras = new HashMap<String, Object>();
        extras.put("imports", imports);
        return extras;
    }

    private void addImportIfPackageDiffers(Set<String> imports, Entity entity, Entity targetEntity) {
        String targetPackageDao = targetEntity.getJavaPackageDao();
        if (this.isNotEmpty(targetPackageDao) && !targetPackageDao.equals(entity.getJavaPackageDao())) {
            imports.add(String.format("%s.%s_", targetPackageDao, targetEntity.getClassName()));
        }
    }

    private void generate(Template template, GeneratorJob job, String javaPackage, String javaClassName, Entity entity) throws Exception {
        this.generate(template, job.getOutput(), javaPackage, javaClassName, ".java", job.getSchema(), entity, null);
    }

    private void generate(Template template, GeneratorJob job, String javaPackage, String javaClassName, Entity entity, Map<String, Object> extrasForTemplate) throws Exception {
        this.generate(template, job.getOutput(), javaPackage, javaClassName, ".java", job.getSchema(), entity, extrasForTemplate);
    }

    private void generate(Template template, GeneratorOutput output, String javaPackage, String fileName, String fileExtension, Schema schema, Entity entity, Map<String, Object> extrasForTemplate) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("schema", schema);
        root.put("entity", entity);
        if (extrasForTemplate != null) {
            root.putAll(extrasForTemplate);
        }
        String filePath = javaPackage + "." + fileName + fileExtension;
        try {
            try (Writer writer = output.createWriter(javaPackage, fileName, fileExtension);){
                template.process(root, writer);
                writer.flush();
            }
            BoxGenerator.log("Written " + filePath);
        }
        catch (Exception ex) {
            System.err.println("Data map for template: " + root);
            System.err.println("Error while generating " + filePath);
            throw ex;
        }
    }

    private boolean isNotEmpty(String value) {
        return value != null && value.length() > 0;
    }

    private boolean isNotEmpty(List list) {
        return list != null && !list.isEmpty();
    }

    private static void log(String message) {
        System.out.println("[ObjectBox] " + message);
    }
}

