/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.HasParsedElement;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.PropertyType;
import io.objectbox.generator.model.Schema;

public class ToOne
implements HasParsedElement {
    private final Schema schema;
    private final Entity sourceEntity;
    private final Entity targetEntity;
    private final Property targetIdProperty;
    private String resolvedKeyJavaType;
    private boolean resolvedKeyUseEquals;
    private String name;
    private String nameToOne;
    private final boolean useFkProperty;
    private Object parsedElement;
    private boolean toOneFieldAccessible;

    public ToOne(Schema schema, Entity sourceEntity, Entity targetEntity, Property targetIdProperty, boolean useFkProperty) {
        this.schema = schema;
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.targetIdProperty = targetIdProperty;
        this.useFkProperty = useFkProperty;
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public Property getTargetIdProperty() {
        return this.targetIdProperty;
    }

    public String getResolvedKeyJavaType() {
        return this.resolvedKeyJavaType;
    }

    public boolean getResolvedKeyUseEquals() {
        return this.resolvedKeyUseEquals;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUseFkProperty() {
        return this.useFkProperty;
    }

    public String getNameToOne() {
        return this.nameToOne;
    }

    public String getToOneValueExpression() {
        return this.toOneFieldAccessible ? this.nameToOne : "get" + TextUtil.capFirst(this.nameToOne) + "()";
    }

    public void setNameToOne(String nameToOne) {
        this.nameToOne = nameToOne;
    }

    public void setToOneFieldAccessible(boolean toOneFieldAccessible) {
        this.toOneFieldAccessible = toOneFieldAccessible;
    }

    public boolean isToOneFieldAccessible() {
        return this.toOneFieldAccessible;
    }

    public boolean isPlainToOne() {
        return this.name.equals(this.nameToOne);
    }

    void init2ndPass() {
        if (this.name == null) {
            char[] nameCharArray = this.targetEntity.getClassName().toCharArray();
            nameCharArray[0] = Character.toLowerCase(nameCharArray[0]);
            this.name = new String(nameCharArray);
        }
        if (this.nameToOne == null) {
            this.nameToOne = this.targetIdProperty != null ? this.name + "ToOne" : this.name;
        }
    }

    void init3ndPass() {
        if (this.targetIdProperty != null) {
            PropertyType propertyType = this.targetIdProperty.getPropertyType();
            if (propertyType == null) {
                this.targetIdProperty.setPropertyType(PropertyType.RelationId);
                this.targetIdProperty.init2ndPass();
                this.targetIdProperty.init3ndPass();
            } else if (propertyType != PropertyType.RelationId) {
                throw new RuntimeException("To-one target ID property type is incompatible with a to-one relation: " + (Object)((Object)propertyType));
            }
            this.resolvedKeyJavaType = this.schema.mapToJavaTypeNullable(propertyType);
            this.resolvedKeyUseEquals = this.checkUseEquals(propertyType);
        }
    }

    protected boolean checkUseEquals(PropertyType propertyType) {
        boolean useEquals;
        switch (propertyType) {
            case Byte: 
            case Short: 
            case Int: 
            case Long: 
            case Boolean: 
            case Float: {
                useEquals = true;
                break;
            }
            default: {
                useEquals = false;
            }
        }
        return useEquals;
    }

    @Override
    public Object getParsedElement() {
        return this.parsedElement;
    }

    @Override
    public void setParsedElement(Object parsedElement) {
        this.parsedElement = parsedElement;
    }

    public String toString() {
        String sourceName = this.sourceEntity != null ? this.sourceEntity.getClassName() : null;
        String targetName = this.targetEntity != null ? this.targetEntity.getClassName() : null;
        return "ToOne '" + this.name + "' from " + sourceName + " to " + targetName;
    }
}

