/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.Schema;
import io.objectbox.generator.model.ToManyBase;
import io.objectbox.generator.model.ToManyStandalone;
import java.util.List;

public class ToManyToMany
extends ToManyBase {
    private Property[] sourceProperties;
    private String linkedToManyName;
    private ToManyStandalone backlinkToMany;

    public ToManyToMany(Schema schema, Entity sourceEntity, Entity targetEntity, String linkedToManyName) {
        super(schema, sourceEntity, targetEntity);
        this.linkedToManyName = linkedToManyName;
    }

    public Property[] getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(Property[] sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public String getLinkedToManyName() {
        return this.linkedToManyName;
    }

    public ToManyStandalone getBacklinkToMany() {
        return this.backlinkToMany;
    }

    @Override
    void init2ndPass() {
        super.init2ndPass();
        List<Property> pks = this.sourceEntity.getPropertiesPk();
        if (pks.isEmpty()) {
            throw new RuntimeException("Source entity has no primary key, but we need it for " + this);
        }
        this.sourceProperties = new Property[pks.size()];
        this.sourceProperties = pks.toArray(this.sourceProperties);
        if (this.linkedToManyName == null || this.linkedToManyName.length() == 0) {
            throw new RuntimeException("Linked ToMany name not specified");
        }
    }

    @Override
    void init3rdPass() {
        super.init3rdPass();
        for (ToManyBase toMany : this.getTargetEntity().getToManyRelations()) {
            if (toMany.getTargetEntity() != this.sourceEntity || !this.linkedToManyName.equalsIgnoreCase(toMany.getName()) || !(toMany instanceof ToManyStandalone)) continue;
            if (this.backlinkToMany != null) {
                throw new IllegalStateException("More than one matching backlink: " + this.backlinkToMany + " vs. " + toMany);
            }
            this.backlinkToMany = (ToManyStandalone)toMany;
        }
        if (this.backlinkToMany == null) {
            throw new IllegalStateException("No matching backlink found for " + this);
        }
    }
}

