/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.HasParsedElement;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.PropertyOrderList;
import io.objectbox.generator.model.Schema;

public abstract class ToManyBase
implements HasParsedElement {
    private final Schema schema;
    protected String name;
    protected final Entity sourceEntity;
    protected final Entity targetEntity;
    private final PropertyOrderList propertyOrderList;
    private boolean fieldAccessible;
    private Object parsedElement;

    public ToManyBase(Schema schema, Entity sourceEntity, Entity targetEntity) {
        this.schema = schema;
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.propertyOrderList = new PropertyOrderList();
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFieldAccessible() {
        return this.fieldAccessible;
    }

    public void setFieldAccessible(boolean fieldAccessible) {
        this.fieldAccessible = fieldAccessible;
    }

    public String getValueExpression() {
        return this.fieldAccessible ? this.name : "get" + TextUtil.capFirst(this.name) + "()";
    }

    public void orderAsc(Property ... properties) {
        for (Property property : properties) {
            this.targetEntity.validatePropertyExists(property);
            this.propertyOrderList.addPropertyAsc(property);
        }
    }

    public void orderDesc(Property ... properties) {
        for (Property property : properties) {
            this.targetEntity.validatePropertyExists(property);
            this.propertyOrderList.addPropertyDesc(property);
        }
    }

    public String getOrder() {
        if (this.propertyOrderList.isEmpty()) {
            return null;
        }
        return this.propertyOrderList.getCommaSeparatedString("T");
    }

    public String getOrderSpec() {
        if (this.propertyOrderList.isEmpty()) {
            return null;
        }
        return this.propertyOrderList.getOrderSpec();
    }

    @Override
    public Object getParsedElement() {
        return this.parsedElement;
    }

    @Override
    public void setParsedElement(Object parsedElement) {
        this.parsedElement = parsedElement;
    }

    void init2ndPass() {
        if (this.name == null) {
            char[] nameCharArray = this.targetEntity.getClassName().toCharArray();
            nameCharArray[0] = Character.toLowerCase(nameCharArray[0]);
            this.name = new String(nameCharArray) + "List";
        }
    }

    void init3rdPass() {
    }

    public String toString() {
        String sourceName = this.sourceEntity != null ? this.sourceEntity.getClassName() : null;
        String targetName = this.targetEntity != null ? this.targetEntity.getClassName() : null;
        return "ToMany '" + this.name + "' from " + sourceName + " to " + targetName;
    }
}

