/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.PropertyType;
import io.objectbox.generator.model.Schema;
import io.objectbox.generator.model.ToManyBase;
import io.objectbox.generator.model.ToOne;
import java.util.List;

public class ToMany
extends ToManyBase {
    private Property[] sourceProperties;
    private final Property[] targetProperties;
    private ToOne backlinkToOne;

    public ToMany(Schema schema, Entity sourceEntity, Property[] sourceProperties, Entity targetEntity, Property[] targetProperties) {
        super(schema, sourceEntity, targetEntity);
        this.sourceProperties = sourceProperties;
        this.targetProperties = targetProperties;
    }

    public Property[] getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(Property[] sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public Property[] getTargetProperties() {
        return this.targetProperties;
    }

    public ToOne getBacklinkToOne() {
        return this.backlinkToOne;
    }

    @Override
    void init2ndPass() {
        int count;
        super.init2ndPass();
        if (this.sourceProperties == null) {
            List<Property> pks = this.sourceEntity.getPropertiesPk();
            if (pks.isEmpty()) {
                throw new RuntimeException("Source entity has no primary key, but we need it for " + this);
            }
            this.sourceProperties = new Property[pks.size()];
            this.sourceProperties = pks.toArray(this.sourceProperties);
        }
        if ((count = this.sourceProperties.length) != this.targetProperties.length) {
            throw new RuntimeException("Source properties do not match target properties: " + this);
        }
        for (int i = 0; i < count; ++i) {
            Property sourceProperty = this.sourceProperties[i];
            Property targetProperty = this.targetProperties[i];
            PropertyType sourceType = sourceProperty.getPropertyType();
            PropertyType targetType = targetProperty.getPropertyType();
            if (sourceType == null || targetType == null) {
                throw new RuntimeException("Property type uninitialized");
            }
            if (sourceType.supportsRelationToTarget(targetType)) continue;
            throw new RuntimeException("To-many property types incompatible: " + this + " (" + (Object)((Object)sourceType) + " vs. " + (Object)((Object)targetType) + ")");
        }
    }

    @Override
    void init3rdPass() {
        super.init3rdPass();
        if (this.targetProperties.length == 1) {
            String propertyName = this.targetProperties[0].getPropertyName();
            for (ToOne toOne : this.getTargetEntity().getToOneRelations()) {
                if (toOne.getTargetEntity() != this.sourceEntity || !propertyName.equalsIgnoreCase(toOne.getNameToOne()) && !propertyName.equalsIgnoreCase(toOne.getTargetIdProperty().getPropertyName())) continue;
                if (this.backlinkToOne != null) {
                    throw new IllegalStateException("More than one matching backlink: " + this.backlinkToOne + " vs. " + toOne);
                }
                this.backlinkToOne = toOne;
            }
            if (this.backlinkToOne == null) {
                throw new IllegalStateException("No matching backlink found for " + this);
            }
        }
    }
}

