/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.IdUid;
import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.PropertyType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class Schema {
    public static final String DEFAULT_NAME = "default";
    private final int version;
    private final String defaultJavaPackage;
    private String defaultJavaPackageDao;
    private String defaultJavaPackageTest;
    private final List<Entity> entities;
    private Map<PropertyType, Mapping> propertyTypeMapping;
    private boolean hasKeepSectionsByDefault;
    private boolean useActiveEntitiesByDefault;
    private final String name;
    private final String prefix;
    private IdUid lastEntityId;
    private IdUid lastIndexId;
    private IdUid lastRelationId;
    private boolean isFinished;

    public Schema(String name, int version, String defaultJavaPackage) {
        this.name = name;
        this.prefix = name.equals(DEFAULT_NAME) ? "" : TextUtil.capFirst(name);
        this.version = version;
        this.defaultJavaPackage = defaultJavaPackage;
        this.entities = new ArrayList<Entity>();
        this.initTypeMappings();
    }

    public Schema(int version, String defaultJavaPackage) {
        this(DEFAULT_NAME, version, defaultJavaPackage);
    }

    public void enableKeepSectionsByDefault() {
        this.hasKeepSectionsByDefault = true;
    }

    public void enableActiveEntitiesByDefault() {
        this.useActiveEntitiesByDefault = true;
    }

    private void initTypeMappings() {
        this.propertyTypeMapping = new EnumMap<PropertyType, Mapping>(PropertyType.class);
        this.propertyTypeMapping.put(PropertyType.Boolean, new Mapping(1, "Bool", "Boolean", "boolean"));
        this.propertyTypeMapping.put(PropertyType.Byte, new Mapping(2, "Byte", "Byte", "byte"));
        this.propertyTypeMapping.put(PropertyType.Char, new Mapping(4, "Char", "Character", "char"));
        this.propertyTypeMapping.put(PropertyType.Short, new Mapping(3, "Short", "Short", "short"));
        this.propertyTypeMapping.put(PropertyType.Int, new Mapping(5, "Int", "Integer", "int"));
        this.propertyTypeMapping.put(PropertyType.Long, new Mapping(6, "Long", "Long", "long"));
        this.propertyTypeMapping.put(PropertyType.Float, new Mapping(7, "Float", "Float", "float"));
        this.propertyTypeMapping.put(PropertyType.Double, new Mapping(8, "Double", "Double", "double"));
        this.propertyTypeMapping.put(PropertyType.String, new Mapping(9, "String", "String", "String"));
        this.propertyTypeMapping.put(PropertyType.ByteArray, new Mapping(23, "ByteVector", "byte[]", "byte[]"));
        this.propertyTypeMapping.put(PropertyType.Date, new Mapping(10, "Date", "java.util.Date", "java.util.Date"));
        this.propertyTypeMapping.put(PropertyType.RelationId, new Mapping(11, "Relation", "Long", "long"));
    }

    public Entity addEntity(String className) {
        Entity entity = new Entity(this, className);
        this.entities.add(entity);
        return entity;
    }

    public Entity addProtobufEntity(String className) {
        Entity entity = this.addEntity(className);
        entity.useProtobuf();
        return entity;
    }

    public String mapToDbType(PropertyType propertyType) {
        return this.mapType(this.propertyTypeMapping, (PropertyType)propertyType).dbType;
    }

    public short mapToDbTypeId(PropertyType propertyType) {
        return this.mapType(this.propertyTypeMapping, (PropertyType)propertyType).dbTypeId;
    }

    public String mapToJavaTypeNullable(PropertyType propertyType) {
        return this.mapType(this.propertyTypeMapping, (PropertyType)propertyType).javaTypeNullable;
    }

    public String mapToJavaTypeNotNull(PropertyType propertyType) {
        return this.mapType(this.propertyTypeMapping, (PropertyType)propertyType).javaTypeNotNull;
    }

    private <T> T mapType(Map<PropertyType, T> map, PropertyType propertyType) {
        T dbType = map.get((Object)propertyType);
        if (dbType == null) {
            throw new IllegalStateException("No mapping for " + (Object)((Object)propertyType));
        }
        return dbType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getDefaultJavaPackage() {
        return this.defaultJavaPackage;
    }

    public String getDefaultJavaPackageDao() {
        return this.defaultJavaPackageDao;
    }

    public void setDefaultJavaPackageDao(String defaultJavaPackageDao) {
        this.defaultJavaPackageDao = defaultJavaPackageDao;
    }

    public String getDefaultJavaPackageTest() {
        return this.defaultJavaPackageTest;
    }

    public void setDefaultJavaPackageTest(String defaultJavaPackageTest) {
        this.defaultJavaPackageTest = defaultJavaPackageTest;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public boolean isHasKeepSectionsByDefault() {
        return this.hasKeepSectionsByDefault;
    }

    public boolean isUseActiveEntitiesByDefault() {
        return this.useActiveEntitiesByDefault;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public IdUid getLastEntityId() {
        return this.lastEntityId;
    }

    public void setLastEntityId(IdUid lastEntityId) {
        this.lastEntityId = lastEntityId;
    }

    public IdUid getLastIndexId() {
        return this.lastIndexId;
    }

    public void setLastIndexId(IdUid lastIndexId) {
        this.lastIndexId = lastIndexId;
    }

    public IdUid getLastRelationId() {
        return this.lastRelationId;
    }

    public void setLastRelationId(IdUid lastRelationId) {
        this.lastRelationId = lastRelationId;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void finish() {
        List<Entity> entities = this.getEntities();
        for (Entity entity : entities) {
            if (entity.getClassNameDao() != null) continue;
            entity.setClassNameDao(entity.getClassName() + "Cursor");
        }
        this.init2ndPass();
        this.init3rdPass();
        this.isFinished = true;
    }

    void init2ndPass() {
        if (this.defaultJavaPackageDao == null) {
            this.defaultJavaPackageDao = this.defaultJavaPackage;
        }
        if (this.defaultJavaPackageTest == null) {
            this.defaultJavaPackageTest = this.defaultJavaPackageDao;
        }
        for (Entity entity : this.entities) {
            entity.init2ndPass();
        }
    }

    void init3rdPass() {
        for (Entity entity : this.entities) {
            entity.init3rdPass();
        }
    }

    private static class Mapping {
        final short dbTypeId;
        final String dbType;
        final String javaTypeNullable;
        final String javaTypeNotNull;

        Mapping(short dbTypeId, String dbType, String javaTypeNullable, String javaTypeNotNull) {
            this.dbType = dbType;
            this.dbTypeId = dbTypeId;
            this.javaTypeNotNull = javaTypeNotNull;
            this.javaTypeNullable = javaTypeNullable;
        }
    }
}

