/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.model.Property;
import java.util.ArrayList;
import java.util.List;

public class PropertyOrderList {
    private List<Property> properties = new ArrayList<Property>();
    private List<String> propertiesOrder = new ArrayList<String>();

    public void addProperty(Property property) {
        this.properties.add(property);
        this.propertiesOrder.add(null);
    }

    public void addPropertyAsc(Property property) {
        this.properties.add(property);
        this.propertiesOrder.add("ASC");
    }

    public void addPropertyDesc(Property property) {
        this.properties.add(property);
        this.propertiesOrder.add("DESC");
    }

    public void addOrderRaw(String order) {
        this.properties.add(null);
        this.propertiesOrder.add(order);
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<String> getPropertiesOrder() {
        return this.propertiesOrder;
    }

    public String getCommaSeparatedString(String tablePrefixOrNull) {
        StringBuilder builder = new StringBuilder();
        int size = this.properties.size();
        for (int i = 0; i < size; ++i) {
            Property property = this.properties.get(i);
            String order = this.propertiesOrder.get(i);
            if (property != null) {
                if (tablePrefixOrNull != null) {
                    builder.append(tablePrefixOrNull).append('.');
                }
                builder.append('\'').append(property.getDbName()).append('\'').append(' ');
            }
            if (order != null) {
                builder.append(order);
            }
            if (i >= size - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String getOrderSpec() {
        List<Property> properties = this.getProperties();
        List<String> propertiesOrder = this.getPropertiesOrder();
        StringBuilder builder = new StringBuilder();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            Property property = properties.get(i);
            String order = propertiesOrder.get(i);
            builder.append(property.getPropertyName());
            if (order != null) {
                builder.append(' ').append(order);
            }
            if (i >= size - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

