/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.IdUid;
import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.HasParsedElement;
import io.objectbox.generator.model.Index;
import io.objectbox.generator.model.PropertyType;
import io.objectbox.generator.model.Schema;
import java.util.LinkedHashSet;
import java.util.Set;

public class Property
implements HasParsedElement {
    private final Schema schema;
    private final Entity entity;
    private Entity targetEntity;
    private PropertyType propertyType;
    private final String propertyName;
    private IdUid modelId;
    private IdUid modelIndexId;
    private String dbName;
    private String dbType;
    private Short dbTypeId;
    private String customType;
    private String customTypeClassName;
    private String converter;
    private String converterClassName;
    private String codeBeforeField;
    private String codeBeforeGetter;
    private String codeBeforeSetter;
    private String javaDocField;
    private String javaDocGetter;
    private String javaDocSetter;
    private boolean primaryKey;
    private boolean pkAsc;
    private boolean pkDesc;
    private boolean pkAutoincrement;
    private boolean unique;
    private boolean notNull;
    private boolean nonPrimitiveType;
    private boolean idAssignable;
    private boolean fieldAccessible;
    private int ordinal;
    private String javaType;
    private boolean nonDefaultDbName;
    private String virtualTargetName;
    private String virtualTargetValueExpression;
    private String getterMethodName;
    private Object parsedElement;
    private Integer propertyFlags;
    private Set<String> propertyFlagsNames;
    private Index index;

    public Property(Schema schema, Entity entity, PropertyType propertyType, String propertyName) {
        this.schema = schema;
        this.entity = entity;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public IdUid getModelId() {
        return this.modelId;
    }

    public void setModelId(IdUid modelId) {
        this.modelId = modelId;
    }

    public IdUid getModelIndexId() {
        return this.modelIndexId;
    }

    public void setModelIndexId(IdUid modelIndexId) {
        this.modelIndexId = modelIndexId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean isNonDefaultDbName() {
        return this.nonDefaultDbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public Short getDbTypeId() {
        return this.dbTypeId;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isPkAsc() {
        return this.pkAsc;
    }

    public boolean isPkDesc() {
        return this.pkDesc;
    }

    public boolean isAutoincrement() {
        return this.pkAutoincrement;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isNonPrimitiveType() {
        return this.nonPrimitiveType || !this.propertyType.isScalar() || this.customType != null;
    }

    public boolean isIdAssignable() {
        return this.idAssignable;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeInEntity() {
        if (this.customTypeClassName != null) {
            return this.customTypeClassName;
        }
        return this.javaType;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getCustomType() {
        return this.customType;
    }

    public String getCustomTypeClassName() {
        return this.customTypeClassName;
    }

    public String getConverter() {
        return this.converter;
    }

    public String getConverterClassName() {
        return this.converterClassName;
    }

    public String getCodeBeforeField() {
        return this.codeBeforeField;
    }

    public String getCodeBeforeGetter() {
        return this.codeBeforeGetter;
    }

    public String getCodeBeforeSetter() {
        return this.codeBeforeSetter;
    }

    public String getJavaDocField() {
        return this.javaDocField;
    }

    public String getJavaDocGetter() {
        return this.javaDocGetter;
    }

    public String getJavaDocSetter() {
        return this.javaDocSetter;
    }

    public boolean isFieldAccessible() {
        return this.fieldAccessible;
    }

    public boolean isVirtual() {
        return this.virtualTargetName != null;
    }

    public String getVirtualTargetValueExpression() {
        return this.virtualTargetValueExpression;
    }

    public String getVirtualTargetName() {
        return this.virtualTargetName;
    }

    public String getGetterMethodName() {
        return this.getterMethodName;
    }

    public void convertToRelationId(Entity target) {
        if (this.propertyType != PropertyType.Long && this.propertyType != PropertyType.RelationId) {
            throw new RuntimeException("Relation ID property must be of type long: " + this);
        }
        this.setPropertyType(PropertyType.RelationId);
        this.targetEntity = target;
        if (this.index == null) {
            this.index = new Index();
            this.index.addProperty(this);
            this.entity.addIndex(this.index);
        }
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public String getValueExpression() {
        if (this.fieldAccessible) {
            return this.propertyName;
        }
        if (this.getterMethodName != null && this.getterMethodName.length() > 0) {
            return this.getterMethodName + "()";
        }
        return "get" + TextUtil.capFirst(this.propertyName) + "()";
    }

    public String getSetValueExpression(String value) {
        if (this.fieldAccessible) {
            return this.propertyName + " = " + value;
        }
        return "set" + TextUtil.capFirst(this.propertyName) + "(" + value + ")";
    }

    public String getDatabaseValueExpression() {
        return this.getDatabaseValueExpression(this.getValueExpression());
    }

    public String getDatabaseValueExpression(String entityValue) {
        StringBuilder builder = new StringBuilder();
        if (this.customType != null) {
            builder.append(this.propertyName).append("Converter.convertToDatabaseValue(");
        }
        builder.append(entityValue);
        if (this.customType != null) {
            builder.append(')');
        }
        if (this.propertyType == PropertyType.Boolean) {
            builder.append(" ? 1 : 0");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append(".getTime()");
        }
        return builder.toString();
    }

    public String getEntityValueExpression(String databaseValue) {
        StringBuilder builder = new StringBuilder();
        if (this.customType != null) {
            builder.append(this.propertyName).append("Converter.convertToEntityProperty(");
        }
        if (this.propertyType == PropertyType.Byte) {
            builder.append("(byte) ");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append("new java.util.Date(");
        }
        builder.append(databaseValue);
        if (this.propertyType == PropertyType.Boolean) {
            builder.append(" != 0");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append(")");
        }
        if (this.customType != null) {
            builder.append(')');
        }
        return builder.toString();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    void init2ndPass() {
        if (this.idAssignable && !this.primaryKey) {
            throw new RuntimeException("idSelfAssignable set for non-ID property");
        }
        if (this.dbType == null) {
            this.dbType = this.schema.mapToDbType(this.propertyType);
            this.dbTypeId = this.schema.mapToDbTypeId(this.propertyType);
        }
        if (this.dbName == null) {
            this.dbName = TextUtil.dbName(this.propertyName);
            this.nonDefaultDbName = false;
        } else if (this.primaryKey && this.propertyType == PropertyType.Long && this.dbName.equals("_id")) {
            this.nonDefaultDbName = false;
        }
        this.javaType = !this.nonPrimitiveType ? this.schema.mapToJavaTypeNotNull(this.propertyType) : this.schema.mapToJavaTypeNullable(this.propertyType);
    }

    void init3ndPass() {
    }

    @Override
    public Object getParsedElement() {
        return this.parsedElement;
    }

    @Override
    public void setParsedElement(Object parsedElement) {
        this.parsedElement = parsedElement;
    }

    public void computePropertyFlags() {
        int flags = 0;
        LinkedHashSet<String> flagsNames = new LinkedHashSet<String>();
        if (this.isPrimaryKey()) {
            flags |= 1;
            flagsNames.add("PropertyFlags.ID");
        }
        if (this.isIdAssignable()) {
            flags |= 0x80;
            flagsNames.add("PropertyFlags.ID_SELF_ASSIGNABLE");
        }
        if (this.isNotNull() && !this.isPrimaryKey()) {
            flags |= 4;
            flagsNames.add("PropertyFlags.NOT_NULL");
        }
        if (this.isNonPrimitiveType() && this.getPropertyType().isScalar()) {
            flags |= 2;
            flagsNames.add("PropertyFlags.NON_PRIMITIVE_TYPE");
        }
        if (this.isVirtual()) {
            flags |= 0x400;
            flagsNames.add("PropertyFlags.VIRTUAL");
        }
        if (this.getPropertyType() == PropertyType.RelationId) {
            flags |= 8;
            flagsNames.add("PropertyFlags.INDEXED");
            flags |= 0x200;
            flagsNames.add("PropertyFlags.INDEX_PARTIAL_SKIP_ZERO");
        } else if (this.getIndex() != null) {
            switch (this.getIndex().getType()) {
                case 0: 
                case 8: {
                    flags |= 8;
                    flagsNames.add("PropertyFlags.INDEXED");
                    break;
                }
                case 2048: {
                    flags |= 0x800;
                    flagsNames.add("PropertyFlags.INDEX_HASH");
                    break;
                }
                case 4096: {
                    flags |= 0x1000;
                    flagsNames.add("PropertyFlags.INDEX_HASH64");
                }
            }
            if (this.getIndex().isUnique()) {
                flags |= 0x20;
                flagsNames.add("PropertyFlags.UNIQUE");
            }
        }
        this.propertyFlags = flags;
        this.propertyFlagsNames = flagsNames;
    }

    public int getPropertyFlags() {
        if (this.propertyFlags == null) {
            this.computePropertyFlags();
        }
        return this.propertyFlags;
    }

    public Set<String> getPropertyFlagsNames() {
        if (this.propertyFlagsNames == null) {
            this.computePropertyFlags();
        }
        return this.propertyFlagsNames;
    }

    public String toString() {
        return "Property " + this.propertyName + " of " + this.entity.getClassName();
    }

    public static class PropertyBuilder {
        private final Property property;

        public PropertyBuilder(Schema schema, Entity entity, PropertyType propertyType, String propertyName) {
            this.property = new Property(schema, entity, propertyType, propertyName);
        }

        public PropertyBuilder dbName(String dbName) {
            this.property.dbName = dbName;
            this.property.nonDefaultDbName = dbName != null;
            return this;
        }

        public PropertyBuilder dbType(String dbType) {
            this.property.dbType = dbType;
            return this;
        }

        public PropertyBuilder modelId(IdUid modelId) {
            this.property.modelId = modelId;
            return this;
        }

        public PropertyBuilder modelIndexId(IdUid indexId) {
            this.property.modelIndexId = indexId;
            return this;
        }

        public PropertyBuilder primaryKey() {
            this.property.primaryKey = true;
            return this;
        }

        public PropertyBuilder primaryKeyAsc() {
            this.property.primaryKey = true;
            this.property.pkAsc = true;
            return this;
        }

        public PropertyBuilder primaryKeyDesc() {
            this.property.primaryKey = true;
            this.property.pkDesc = true;
            return this;
        }

        public PropertyBuilder autoincrement() {
            if (!this.property.primaryKey || this.property.propertyType != PropertyType.Long) {
                throw new RuntimeException("AUTOINCREMENT is only available to primary key properties of type long/Long");
            }
            this.property.pkAutoincrement = true;
            return this;
        }

        public PropertyBuilder unique() {
            this.property.unique = true;
            return this;
        }

        public PropertyBuilder notNull() {
            this.property.notNull = true;
            return this;
        }

        public PropertyBuilder idAssignable() {
            this.property.idAssignable = true;
            return this;
        }

        public PropertyBuilder fieldAccessible() {
            this.property.fieldAccessible = true;
            return this;
        }

        public PropertyBuilder nonPrimitiveType() {
            if (!this.property.propertyType.isScalar()) {
                throw new RuntimeException("Type is already non-primitive");
            }
            this.property.nonPrimitiveType = true;
            return this;
        }

        public PropertyBuilder index() {
            Index index = new Index();
            index.addProperty(this.property);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder indexAsc(String indexNameOrNull, boolean isUnique) {
            Index index = new Index();
            index.addPropertyAsc(this.property);
            if (isUnique) {
                index.makeUnique();
            }
            index.setName(indexNameOrNull);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder indexAsc(String indexNameOrNull, int type, int maxValueLength, boolean unique) {
            Index index = new Index();
            index.addPropertyAsc(this.property);
            index.setName(indexNameOrNull);
            index.setType(type);
            index.setMaxValueLength(maxValueLength);
            if (unique) {
                index.makeUnique();
            }
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder indexDesc(String indexNameOrNull, boolean isUnique) {
            Index index = new Index();
            index.addPropertyDesc(this.property);
            if (isUnique) {
                index.makeUnique();
            }
            index.setName(indexNameOrNull);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder customType(String customType, String converter) {
            this.property.customType = customType;
            this.property.customTypeClassName = TextUtil.getClassnameFromFullyQualified(customType);
            this.property.converter = converter;
            this.property.converterClassName = TextUtil.getClassnameFromFullyQualified(converter);
            return this;
        }

        public PropertyBuilder codeBeforeField(String code) {
            this.property.codeBeforeField = code;
            return this;
        }

        public PropertyBuilder codeBeforeGetter(String code) {
            this.property.codeBeforeGetter = code;
            return this;
        }

        public PropertyBuilder codeBeforeSetter(String code) {
            this.property.codeBeforeSetter = code;
            return this;
        }

        public PropertyBuilder codeBeforeGetterAndSetter(String code) {
            this.property.codeBeforeGetter = code;
            this.property.codeBeforeSetter = code;
            return this;
        }

        public PropertyBuilder javaDocField(String javaDoc) {
            this.property.javaDocField = this.checkConvertToJavaDoc(javaDoc);
            return this;
        }

        private String checkConvertToJavaDoc(String javaDoc) {
            return TextUtil.checkConvertToJavaDoc(javaDoc, "    ");
        }

        public PropertyBuilder javaDocGetter(String javaDoc) {
            this.property.javaDocGetter = this.checkConvertToJavaDoc(javaDoc);
            return this;
        }

        public PropertyBuilder javaDocSetter(String javaDoc) {
            this.property.javaDocSetter = this.checkConvertToJavaDoc(javaDoc);
            return this;
        }

        public PropertyBuilder javaDocGetterAndSetter(String javaDoc) {
            javaDoc = this.checkConvertToJavaDoc(javaDoc);
            this.property.javaDocGetter = javaDoc;
            this.property.javaDocSetter = javaDoc;
            return this;
        }

        public PropertyBuilder virtualTargetName(String virtualTargetName) {
            this.property.virtualTargetName = virtualTargetName;
            return this;
        }

        public PropertyBuilder virtualTargetValueExpression(String virtualTargetValueExpression) {
            this.property.virtualTargetValueExpression = virtualTargetValueExpression;
            return this;
        }

        public PropertyBuilder getterMethodName(String getterMethodName) {
            this.property.getterMethodName = getterMethodName;
            return this;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

