/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.html;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.html.HtmlTag;
import io.noties.markwon.html.MarkwonHtmlParser;
import io.noties.markwon.html.MarkwonHtmlRenderer;
import io.noties.markwon.html.MarkwonHtmlRendererNoOp;
import io.noties.markwon.html.TagHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MarkwonHtmlRendererImpl
extends MarkwonHtmlRenderer {
    private final boolean allowNonClosedTags;
    private final Map<String, TagHandler> tagHandlers;

    MarkwonHtmlRendererImpl(boolean allowNonClosedTags, @NonNull Map<String, TagHandler> tagHandlers) {
        this.allowNonClosedTags = allowNonClosedTags;
        this.tagHandlers = tagHandlers;
    }

    @Override
    public void render(final @NonNull MarkwonVisitor visitor, @NonNull MarkwonHtmlParser parser) {
        int end = !this.allowNonClosedTags ? -1 : visitor.length();
        parser.flushInlineTags(end, new MarkwonHtmlParser.FlushAction<HtmlTag.Inline>(){

            @Override
            public void apply(@NonNull List<HtmlTag.Inline> tags) {
                for (HtmlTag.Inline inline : tags) {
                    TagHandler handler;
                    if (!inline.isClosed() || (handler = MarkwonHtmlRendererImpl.this.tagHandler(inline.name())) == null) continue;
                    handler.handle(visitor, MarkwonHtmlRendererImpl.this, inline);
                }
            }
        });
        parser.flushBlockTags(end, new MarkwonHtmlParser.FlushAction<HtmlTag.Block>(){

            @Override
            public void apply(@NonNull List<HtmlTag.Block> tags) {
                for (HtmlTag.Block block : tags) {
                    if (!block.isClosed()) continue;
                    TagHandler handler = MarkwonHtmlRendererImpl.this.tagHandler(block.name());
                    if (handler != null) {
                        handler.handle(visitor, MarkwonHtmlRendererImpl.this, block);
                        continue;
                    }
                    this.apply(block.children());
                }
            }
        });
        parser.reset();
    }

    @Override
    @Nullable
    public TagHandler tagHandler(@NonNull String tagName) {
        return this.tagHandlers.get(tagName);
    }

    static class Builder {
        private final Map<String, TagHandler> tagHandlers = new HashMap<String, TagHandler>(2);
        private boolean allowNonClosedTags;
        private boolean excludeDefaults;
        private boolean isBuilt;

        Builder() {
        }

        void allowNonClosedTags(boolean allowNonClosedTags) {
            this.checkState();
            this.allowNonClosedTags = allowNonClosedTags;
        }

        void addHandler(@NonNull TagHandler tagHandler) {
            this.checkState();
            for (String tag : tagHandler.supportedTags()) {
                this.tagHandlers.put(tag, tagHandler);
            }
        }

        @Nullable
        TagHandler getHandler(@NonNull String tagName) {
            this.checkState();
            return this.tagHandlers.get(tagName);
        }

        public void excludeDefaults(boolean excludeDefaults) {
            this.checkState();
            this.excludeDefaults = excludeDefaults;
        }

        boolean excludeDefaults() {
            return this.excludeDefaults;
        }

        @NonNull
        public MarkwonHtmlRenderer build() {
            this.checkState();
            this.isBuilt = true;
            return this.tagHandlers.size() > 0 ? new MarkwonHtmlRendererImpl(this.allowNonClosedTags, Collections.unmodifiableMap(this.tagHandlers)) : new MarkwonHtmlRendererNoOp();
        }

        private void checkState() {
            if (this.isBuilt) {
                throw new IllegalStateException("Builder has been already built");
            }
        }

        void addDefaultTagHandler(@NonNull TagHandler tagHandler) {
            for (String tag : tagHandler.supportedTags()) {
                if (this.tagHandlers.containsKey(tag)) continue;
                this.tagHandlers.put(tag, tagHandler);
            }
        }
    }
}

