/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tables;

import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.ClickableSpan;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import io.noties.markwon.ext.tables.TableRowSpan;

public class TableAwareMovementMethod
implements MovementMethod {
    private final MovementMethod wrapped;

    @NonNull
    public static TableAwareMovementMethod wrap(@NonNull MovementMethod movementMethod) {
        return new TableAwareMovementMethod(movementMethod);
    }

    @NonNull
    public static TableAwareMovementMethod create() {
        return new TableAwareMovementMethod(LinkMovementMethod.getInstance());
    }

    public static boolean handleTableRowTouchEvent(@NonNull TextView widget, @NonNull Spannable buffer, @NonNull MotionEvent event) {
        int line;
        if (event.getAction() != 1) {
            return false;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= widget.getTotalPaddingLeft();
        y -= widget.getTotalPaddingTop();
        Layout layout = widget.getLayout();
        int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
        TableRowSpan[] spans = (TableRowSpan[])buffer.getSpans(off, off, TableRowSpan.class);
        if (spans.length == 0) {
            return false;
        }
        TableRowSpan span = spans[0];
        Layout rowLayout = span.findLayoutForHorizontalOffset(x);
        if (rowLayout != null) {
            int rowY = layout.getLineTop(line);
            int rowLine = rowLayout.getLineForVertical(y - rowY);
            int rowOffset = rowLayout.getOffsetForHorizontal(rowLine, (float)(x % span.cellWidth()));
            ClickableSpan[] rowClickableSpans = (ClickableSpan[])((Spanned)rowLayout.getText()).getSpans(rowOffset, rowOffset, ClickableSpan.class);
            if (rowClickableSpans.length > 0) {
                rowClickableSpans[0].onClick((View)widget);
                return true;
            }
        }
        return false;
    }

    public TableAwareMovementMethod(@NonNull MovementMethod wrapped) {
        this.wrapped = wrapped;
    }

    public void initialize(TextView widget, Spannable text) {
        this.wrapped.initialize(widget, text);
    }

    public boolean onKeyDown(TextView widget, Spannable text, int keyCode, KeyEvent event) {
        return this.wrapped.onKeyDown(widget, text, keyCode, event);
    }

    public boolean onKeyUp(TextView widget, Spannable text, int keyCode, KeyEvent event) {
        return this.wrapped.onKeyUp(widget, text, keyCode, event);
    }

    public boolean onKeyOther(TextView view, Spannable text, KeyEvent event) {
        return this.wrapped.onKeyOther(view, text, event);
    }

    public void onTakeFocus(TextView widget, Spannable text, int direction) {
        this.wrapped.onTakeFocus(widget, text, direction);
    }

    public boolean onTrackballEvent(TextView widget, Spannable text, MotionEvent event) {
        return this.wrapped.onTrackballEvent(widget, text, event);
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        return this.wrapped.onTouchEvent(widget, buffer, event) || TableAwareMovementMethod.handleTableRowTouchEvent(widget, buffer, event);
    }

    public boolean onGenericMotionEvent(TextView widget, Spannable text, MotionEvent event) {
        return this.wrapped.onGenericMotionEvent(widget, text, event);
    }

    public boolean canSelectArbitrarily() {
        return this.wrapped.canSelectArbitrarily();
    }
}

