/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tables;

import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.Markwon;
import java.util.ArrayList;
import java.util.List;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;

public class Table {
    private final List<Row> rows;

    @Nullable
    public static Table parse(@NonNull Markwon markwon, @NonNull TableBlock tableBlock) {
        ParseVisitor visitor = new ParseVisitor(markwon);
        tableBlock.accept((Visitor)visitor);
        List<Row> rows = visitor.rows();
        Table table = rows == null ? null : new Table(rows);
        return table;
    }

    public Table(@NonNull List<Row> rows) {
        this.rows = rows;
    }

    @NonNull
    public List<Row> rows() {
        return this.rows;
    }

    public String toString() {
        return "Table{rows=" + this.rows + '}';
    }

    static class ParseVisitor
    extends AbstractVisitor {
        private final Markwon markwon;
        private List<Row> rows;
        private List<Column> pendingRow;
        private boolean pendingRowIsHeader;

        ParseVisitor(@NonNull Markwon markwon) {
            this.markwon = markwon;
        }

        @Nullable
        public List<Row> rows() {
            return this.rows;
        }

        public void visit(CustomNode customNode) {
            if (customNode instanceof TableCell) {
                TableCell cell = (TableCell)customNode;
                if (this.pendingRow == null) {
                    this.pendingRow = new ArrayList<Column>(2);
                }
                this.pendingRow.add(new Column(ParseVisitor.alignment(cell.getAlignment()), this.markwon.render((Node)cell)));
                this.pendingRowIsHeader = cell.isHeader();
                return;
            }
            if (customNode instanceof TableHead || customNode instanceof TableRow) {
                this.visitChildren((Node)customNode);
                if (this.pendingRow != null && this.pendingRow.size() > 0) {
                    if (this.rows == null) {
                        this.rows = new ArrayList<Row>(2);
                    }
                    this.rows.add(new Row(this.pendingRowIsHeader, this.pendingRow));
                }
                this.pendingRow = null;
                this.pendingRowIsHeader = false;
                return;
            }
            this.visitChildren((Node)customNode);
        }

        @NonNull
        private static Alignment alignment(@NonNull TableCell.Alignment alignment) {
            Alignment out = TableCell.Alignment.RIGHT == alignment ? Alignment.RIGHT : (TableCell.Alignment.CENTER == alignment ? Alignment.CENTER : Alignment.LEFT);
            return out;
        }
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static class Column {
        private final Alignment alignment;
        private final Spanned content;

        public Column(@NonNull Alignment alignment, @NonNull Spanned content) {
            this.alignment = alignment;
            this.content = content;
        }

        @NonNull
        public Alignment alignment() {
            return this.alignment;
        }

        @NonNull
        public Spanned content() {
            return this.content;
        }

        public String toString() {
            return "Column{alignment=" + (Object)((Object)this.alignment) + ", content=" + this.content + '}';
        }
    }

    public static class Row {
        private final boolean isHeader;
        private final List<Column> columns;

        public Row(boolean isHeader, @NonNull List<Column> columns) {
            this.isHeader = isHeader;
            this.columns = columns;
        }

        public boolean header() {
            return this.isHeader;
        }

        @NonNull
        public List<Column> columns() {
            return this.columns;
        }

        public String toString() {
            return "Row{isHeader=" + this.isHeader + ", columns=" + this.columns + '}';
        }
    }
}

