/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tables;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.ReplacementSpan;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.core.spans.TextLayoutSpan;
import io.noties.markwon.ext.tables.TableSpan;
import io.noties.markwon.ext.tables.TableTheme;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableSpan;
import io.noties.markwon.utils.LeadingMarginUtils;
import io.noties.markwon.utils.SpanUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class TableRowSpan
extends ReplacementSpan {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private final TableTheme theme;
    private final List<Cell> cells;
    private final List<Layout> layouts;
    private final TextPaint textPaint;
    private final boolean header;
    private final boolean odd;
    private final Rect rect = new Rect();
    private final Paint paint = new Paint(1);
    private int width;
    private int height;
    private Invalidator invalidator;

    public TableRowSpan(@NonNull TableTheme theme, @NonNull List<Cell> cells, boolean header, boolean odd) {
        this.theme = theme;
        this.cells = cells;
        this.layouts = new ArrayList<Layout>(cells.size());
        this.textPaint = new TextPaint();
        this.header = header;
        this.odd = odd;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
        if (this.layouts.size() > 0 && fm != null) {
            int max = 0;
            for (Layout layout : this.layouts) {
                int height = layout.getHeight();
                if (height <= max) continue;
                max = height;
            }
            this.height = max;
            int padding = this.theme.tableCellPadding() * 2;
            fm.ascent = -(max + padding);
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint p) {
        boolean isFirstTableRow;
        int spanWidth = SpanUtils.width((Canvas)canvas, (CharSequence)text);
        if (this.recreateLayouts(spanWidth)) {
            this.width = spanWidth;
            if (p instanceof TextPaint) {
                this.textPaint.set((TextPaint)p);
            } else {
                this.textPaint.set(p);
            }
            this.makeNewLayouts();
        }
        int maxHeight = 0;
        int padding = this.theme.tableCellPadding();
        int size = this.layouts.size();
        int w = this.cellWidth(size);
        int roundingDiff = w - this.width / size;
        if (this.header) {
            this.theme.applyTableHeaderRowStyle(this.paint);
        } else if (this.odd) {
            this.theme.applyTableOddRowStyle(this.paint);
        } else {
            this.theme.applyTableEvenRowStyle(this.paint);
        }
        if (this.paint.getColor() != 0) {
            int save = canvas.save();
            try {
                this.rect.set(0, 0, this.width, bottom - top);
                canvas.translate(x, (float)top);
                canvas.drawRect(this.rect, this.paint);
            }
            finally {
                canvas.restoreToCount(save);
            }
        }
        this.paint.set(p);
        this.theme.applyTableBorderStyle(this.paint);
        int borderWidth = this.theme.tableBorderWidth(this.paint);
        boolean drawBorder = borderWidth > 0;
        int heightDiff = (bottom - top - this.height) / 4;
        if (drawBorder) {
            TableSpan span;
            boolean first = false;
            Spanned spanned = (Spanned)text;
            TableSpan[] spans = (TableSpan[])spanned.getSpans(start, end, TableSpan.class);
            if (spans != null && spans.length > 0 && LeadingMarginUtils.selfStart((int)start, (CharSequence)text, (Object)(span = spans[0]))) {
                first = true;
                this.rect.set((int)x, top, this.width, top + borderWidth);
                canvas.drawRect(this.rect, this.paint);
            }
            this.rect.set((int)x, bottom - borderWidth, this.width, bottom);
            canvas.drawRect(this.rect, this.paint);
            isFirstTableRow = first;
        } else {
            isFirstTableRow = false;
        }
        int borderWidthHalf = borderWidth / 2;
        int borderTop = isFirstTableRow ? borderWidth : 0;
        int borderBottom = bottom - top - borderWidth;
        for (int i = 0; i < size; ++i) {
            Layout layout = this.layouts.get(i);
            int save = canvas.save();
            try {
                canvas.translate(x + (float)(i * w), (float)top);
                if (drawBorder) {
                    if (i == 0) {
                        this.rect.set(0, borderTop, borderWidth, borderBottom);
                    } else {
                        this.rect.set(-borderWidthHalf, borderTop, borderWidthHalf, borderBottom);
                    }
                    canvas.drawRect(this.rect, this.paint);
                    if (i == size - 1) {
                        this.rect.set(w - borderWidth - roundingDiff, borderTop, w - roundingDiff, borderBottom);
                        canvas.drawRect(this.rect, this.paint);
                    }
                }
                canvas.translate((float)padding, (float)(padding + heightDiff));
                layout.draw(canvas);
                if (layout.getHeight() <= maxHeight) continue;
                maxHeight = layout.getHeight();
                continue;
            }
            finally {
                canvas.restoreToCount(save);
            }
        }
        if (this.height != maxHeight && this.invalidator != null) {
            this.invalidator.invalidate();
        }
    }

    private boolean recreateLayouts(int newWidth) {
        return this.width != newWidth;
    }

    private void makeNewLayouts() {
        this.textPaint.setFakeBoldText(this.header);
        int columns = this.cells.size();
        int padding = this.theme.tableCellPadding() * 2;
        int w = this.cellWidth(columns) - padding;
        this.layouts.clear();
        int size = this.cells.size();
        for (int i = 0; i < size; ++i) {
            this.makeLayout(i, w, this.cells.get(i));
        }
    }

    private void makeLayout(final int index, final int width, final @NonNull Cell cell) {
        Runnable recreate = new Runnable(){

            @Override
            public void run() {
                Invalidator invalidator = TableRowSpan.this.invalidator;
                if (invalidator != null) {
                    TableRowSpan.this.layouts.remove(index);
                    TableRowSpan.this.makeLayout(index, width, cell);
                    invalidator.invalidate();
                }
            }
        };
        Object spannable = cell.text instanceof Spannable ? (Spannable)cell.text : new SpannableString(cell.text);
        StaticLayout layout = new StaticLayout((CharSequence)spannable, this.textPaint, width, TableRowSpan.alignment(cell.alignment), 1.0f, 0.0f, false);
        TextLayoutSpan.applyTo((Spannable)spannable, (Layout)layout);
        this.scheduleAsyncDrawables((Spannable)spannable, recreate);
        this.layouts.add(index, (Layout)layout);
    }

    private void scheduleAsyncDrawables(@NonNull Spannable spannable, final @NonNull Runnable recreate) {
        AsyncDrawableSpan[] spans = (AsyncDrawableSpan[])spannable.getSpans(0, spannable.length(), AsyncDrawableSpan.class);
        if (spans != null && spans.length > 0) {
            for (AsyncDrawableSpan span : spans) {
                AsyncDrawable drawable = span.getDrawable();
                if (drawable.isAttached()) continue;
                drawable.setCallback2((Drawable.Callback)new CallbackAdapter(){

                    @Override
                    public void invalidateDrawable(@NonNull Drawable who) {
                        recreate.run();
                    }
                });
            }
        }
    }

    @Nullable
    public Layout findLayoutForHorizontalOffset(int x) {
        int size = this.layouts.size();
        int w = this.cellWidth(size);
        int i = x / w;
        if (i >= size) {
            return null;
        }
        return this.layouts.get(i);
    }

    public int cellWidth() {
        return this.cellWidth(this.layouts.size());
    }

    protected int cellWidth(int size) {
        return (int)(1.0f * (float)this.width / (float)size + 0.5f);
    }

    @SuppressLint(value={"SwitchIntDef"})
    private static Layout.Alignment alignment(int alignment) {
        Layout.Alignment out;
        switch (alignment) {
            case 1: {
                out = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 2: {
                out = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            default: {
                out = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return out;
    }

    public void invalidator(@Nullable Invalidator invalidator) {
        this.invalidator = invalidator;
    }

    private static abstract class CallbackAdapter
    implements Drawable.Callback {
        private CallbackAdapter() {
        }

        public void invalidateDrawable(@NonNull Drawable who) {
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        }
    }

    public static class Cell {
        final int alignment;
        final CharSequence text;

        public Cell(int alignment, CharSequence text) {
            this.alignment = alignment;
            this.text = text;
        }

        public int alignment() {
            return this.alignment;
        }

        public CharSequence text() {
            return this.text;
        }

        @NonNull
        public String toString() {
            return "Cell{alignment=" + this.alignment + ", text=" + this.text + '}';
        }
    }

    public static interface Invalidator {
        public void invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Alignment {
    }
}

