/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.editor;

import android.text.Editable;
import androidx.annotation.NonNull;
import io.noties.markwon.Markwon;
import io.noties.markwon.editor.EditHandler;
import io.noties.markwon.editor.MarkwonEditorImpl;
import io.noties.markwon.editor.PersistedSpans;
import io.noties.markwon.editor.PunctuationSpan;
import java.util.HashMap;
import java.util.Map;

public abstract class MarkwonEditor {
    @NonNull
    public static MarkwonEditor create(@NonNull Markwon markwon) {
        return MarkwonEditor.builder(markwon).build();
    }

    @NonNull
    public static Builder builder(@NonNull Markwon markwon) {
        return new Builder(markwon);
    }

    public abstract void process(@NonNull Editable var1);

    public abstract void preRender(@NonNull Editable var1, @NonNull PreRenderResultListener var2);

    static class SpansHandlerImpl
    implements SpansHandler {
        private final Map<Class<?>, EditHandler> spanHandlers;

        SpansHandlerImpl(@NonNull Map<Class<?>, EditHandler> spanHandlers) {
            this.spanHandlers = spanHandlers;
        }

        @Override
        public void handle(@NonNull PersistedSpans spans, @NonNull Editable editable, @NonNull String input, @NonNull Object span, int spanStart, int spanTextLength) {
            EditHandler handler = this.spanHandlers.get(span.getClass());
            if (handler != null) {
                handler.handleMarkdownSpan(spans, editable, input, span, spanStart, spanTextLength);
            }
        }
    }

    static interface SpansHandler {
        public void handle(@NonNull PersistedSpans var1, @NonNull Editable var2, @NonNull String var3, @NonNull Object var4, int var5, int var6);
    }

    public static class Builder {
        private final Markwon markwon;
        private final PersistedSpans.Provider persistedSpansProvider = PersistedSpans.provider();
        private final Map<Class<?>, EditHandler> editHandlers = new HashMap(0);
        private Class<?> punctuationSpanType;

        Builder(@NonNull Markwon markwon) {
            this.markwon = markwon;
        }

        @NonNull
        public <T> Builder useEditHandler(@NonNull EditHandler<T> handler) {
            this.editHandlers.put(handler.markdownSpanType(), handler);
            return this;
        }

        @NonNull
        public <T> Builder punctuationSpan(@NonNull Class<T> type, @NonNull PersistedSpans.SpanFactory<T> factory) {
            this.punctuationSpanType = type;
            this.persistedSpansProvider.persistSpan(type, factory);
            return this;
        }

        @NonNull
        public MarkwonEditor build() {
            Class<?> punctuationSpanType = this.punctuationSpanType;
            if (punctuationSpanType == null) {
                this.punctuationSpan(PunctuationSpan.class, new PersistedSpans.SpanFactory<PunctuationSpan>(){

                    @Override
                    @NonNull
                    public PunctuationSpan create() {
                        return new PunctuationSpan();
                    }
                });
                punctuationSpanType = this.punctuationSpanType;
            }
            for (EditHandler handler : this.editHandlers.values()) {
                handler.init(this.markwon);
                handler.configurePersistedSpans(this.persistedSpansProvider);
            }
            SpansHandlerImpl spansHandler = this.editHandlers.size() == 0 ? null : new SpansHandlerImpl(this.editHandlers);
            return new MarkwonEditorImpl(this.markwon, this.persistedSpansProvider, punctuationSpanType, spansHandler);
        }
    }

    public static interface PreRenderResultListener {
        public void onPreRenderResult(@NonNull PreRenderResult var1);
    }

    public static interface PreRenderResult {
        @NonNull
        public Editable resultEditable();

        public void dispatchTo(@NonNull Editable var1);
    }
}

